/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2;

import com.metamatrix.jdbc.base.BaseColumns;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseImplBlob;
import com.metamatrix.jdbc.base.BaseImplClob;
import com.metamatrix.jdbc.base.BaseImplResultSet;
import com.metamatrix.jdbc.base.BaseParameters;
import com.metamatrix.jdbc.db2.DB2ImplBlob;
import com.metamatrix.jdbc.db2.DB2ImplClob;
import com.metamatrix.jdbc.db2.DB2ImplStatement;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataReader;
import com.metamatrix.jdbc.db2.drda.DRDAColumn;
import com.metamatrix.jdbc.db2.drda.DRDACommunication;
import com.metamatrix.jdbc.db2.drda.DRDAPkgNamCsn;
import com.metamatrix.jdbc.db2.drda.DRDAResultSetRequest;
import com.metamatrix.jdbc.db2.drda.DRDAStatementRequest;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilPagedTempBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.sql.SQLException;

public class DB2ImplResultSet
extends BaseImplResultSet {
    private static String footprint = "$Revision:   3.56.1.2  $";
    DRDAResultSetRequest request;
    BaseData nullBaseData;
    boolean isClosed;
    DRDACommunication comm;
    boolean isCachedResultSet;

    public DB2ImplResultSet(DRDAResultSetRequest dRDAResultSetRequest, DRDACommunication dRDACommunication) throws SQLException {
        this.request = dRDAResultSetRequest;
        this.isClosed = false;
        this.isCachedResultSet = false;
        this.comm = dRDACommunication;
    }

    public DB2ImplResultSet(DRDAStatementRequest dRDAStatementRequest, DRDACommunication dRDACommunication) throws SQLException {
        this.request = new DRDAResultSetRequest(dRDAStatementRequest.implConn, dRDAStatementRequest.comm, dRDAStatementRequest.reader, dRDAStatementRequest.writer, dRDAStatementRequest.packageConsistencyToken);
        this.request.columnDescriptions = dRDAStatementRequest.columnDescriptions;
        this.request.parameterDescriptions = dRDAStatementRequest.parameterDescriptions;
        this.request.chainCommit = dRDAStatementRequest.chainCommit;
        this.request.lobLocParam = dRDAStatementRequest.lobLocParam;
        this.request.useOUTOVRlob = dRDAStatementRequest.useOUTOVRlob;
        this.request.queryDataEndPosition = dRDAStatementRequest.queryDataEndPosition;
        this.request.queryDataLen = dRDAStatementRequest.queryDataLen;
        this.request.isCursorOpen = dRDAStatementRequest.isCursorOpen;
        this.request.isCursorHeldOpen = dRDAStatementRequest.isCursorHeldOpen;
        this.request.isStoredProcedure = dRDAStatementRequest.isStoredProcedure;
        this.request.moreData = dRDAStatementRequest.moreData;
        this.request.hasClobColumns = dRDAStatementRequest.hasClobColumns;
        this.request.hasLobCols = dRDAStatementRequest.hasLobCols;
        this.isClosed = false;
        this.isCachedResultSet = false;
        this.comm = dRDACommunication;
    }

    public DB2ImplResultSet() throws SQLException {
        this.isClosed = true;
    }

    public void close() throws SQLException {
        try {
            if (!this.isClosed) {
                this.request.discardRemainingRows();
                if (!this.request.reader.atEndOfReply()) {
                    this.request.processReply(this.warnings);
                }
                if (this.request.isCursorOpen) {
                    if (this.comm.serverType == 9 && this.implStatement != null) {
                        if (((DB2ImplStatement)this.implStatement).resultSetArray == null || ((DB2ImplStatement)this.implStatement).resultSetArray.length <= 1) {
                            this.request.closeQuery(this.warnings);
                            this.request.submitRequest();
                            this.request.processReply(this.warnings);
                            if (this.comm.implConn.inAutoCommit && this.comm.implConn.inLocalTransaction) {
                                this.comm.implConn.comm.packageManager.updatePackageSections();
                            }
                        }
                    } else {
                        this.request.closeQuery(this.warnings);
                        this.request.submitRequest();
                        this.request.processReply(this.warnings);
                        if (this.comm.implConn.inAutoCommit && this.comm.implConn.inLocalTransaction) {
                            this.comm.implConn.comm.packageManager.updatePackageSections();
                        }
                    }
                } else if (this.comm.implConn.autoCommitResults && this.comm.implConn.inAutoCommit && this.comm.implConn.inLocalTransaction && (((DB2ImplStatement)this.implStatement).resultSetArray == null || ((DB2ImplStatement)this.implStatement).resultSetArray.length <= 1)) {
                    this.comm.implConn.commitTransaction();
                }
                if (this.request.reader != null) {
                    this.request.reader.empty();
                }
                if (this.request.SQLAM6LOBReader != null) {
                    this.request.SQLAM6LOBReader.close();
                }
            }
            this.isClosed = true;
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException(utilException);
        }
    }

    public boolean fetchAtPosition(int n) throws SQLException {
        if (this.isClosed) {
            return false;
        }
        this.request.hasWarnings = false;
        return this.request.getNextRow(this.warnings);
    }

    public BaseData getData(int n, int n2) throws SQLException {
        if (this.comm.supportsStoredProcMetadata && this.implStatement != null && this.implStatement.databaseMetaDataResultSet != 0) {
            if (this.nullBaseData == null) {
                this.nullBaseData = new BaseData(this.comm.implConn.db2Connection);
            }
            switch (this.implStatement.databaseMetaDataResultSet) {
                case 1: {
                    if (n <= 5) break;
                    return this.nullBaseData;
                }
                case 2: {
                    if (n <= 18) break;
                    return this.nullBaseData;
                }
            }
        }
        BaseData baseData = this.request.getColumnBaseDataObject(n, n2, this.warnings);
        if (this.implStatement != null && this.implStatement.databaseMetaDataResultSet != 0) {
            switch (this.implStatement.databaseMetaDataResultSet) {
                case 1: {
                    if (this.comm.supportsStoredProcMetadata && n == 1) {
                        baseData.setString(this.comm.implConn.databaseName.toUpperCase());
                    }
                    if (n != 2 || baseData.isNull()) break;
                    baseData.setString(baseData.getString(-1, this.comm.exceptions).trim());
                    break;
                }
                case 2: {
                    if (this.comm.supportsStoredProcMetadata && n == 1) {
                        baseData.setString(this.comm.implConn.databaseName.toUpperCase());
                    }
                    if (!(n != 2 && n != 6 || baseData.isNull())) {
                        baseData.setString(baseData.getString(-1, this.comm.exceptions).trim());
                    }
                    if (n == 5) {
                        BaseData baseData2 = this.request.getColumnBaseDataObject(n + 1, 10, this.warnings);
                        if (this.comm.serverOS == 8) {
                            boolean bl;
                            int n3 = this.request.getColumnBaseDataObject(23, 10, this.warnings).getIntegerNoConvert();
                            boolean bl2 = bl = n3 == 65535;
                            if (bl) {
                                String string = baseData2.getString(-1, this.exceptions);
                                if (string.indexOf("LONG VARCHAR") != -1) {
                                    string = "LONG VARCHAR() FOR BIT DATA";
                                } else if (string.indexOf("VARCHAR") != -1) {
                                    string = "VARCHAR() FOR BIT DATA";
                                } else if (string.indexOf("CHAR") != -1) {
                                    string = "CHAR() FOR BIT DATA";
                                }
                                baseData2.setString(string);
                            }
                        }
                        baseData.setData(4, this.request.drdaUtil.DB2ToJdbcTypeName(baseData2.getString(-1, this.exceptions)));
                    }
                    if (this.comm.serverOS != 8 || n != 11) break;
                    if (baseData.getString(-1, this.exceptions).equalsIgnoreCase("N")) {
                        baseData.setData(4, new Integer(0));
                        break;
                    }
                    if (baseData.getString(-1, this.exceptions).equalsIgnoreCase("Y")) {
                        baseData.setData(4, new Integer(1));
                        break;
                    }
                    baseData.setData(4, new Integer(2));
                    break;
                }
                case 6: {
                    if (n == 2 && !baseData.isNull()) {
                        baseData.setString(baseData.getString(-1, this.comm.exceptions).trim());
                    }
                    if (!(n != 4 && n != 7 || baseData.isNull())) {
                        baseData.setString(baseData.getString(-1, this.comm.exceptions).trim());
                    }
                    if (n == 6) {
                        BaseData baseData3 = this.request.getColumnBaseDataObject(n + 1, 10, this.warnings);
                        baseData.setData(4, this.request.drdaUtil.DB2ToJdbcTypeName(baseData3.getString(-1, this.exceptions)));
                    }
                    if (this.comm.serverOS == 8 && n == 5) {
                        if (baseData.getString(-1, this.exceptions).equalsIgnoreCase("IN")) {
                            baseData.setData(4, new Integer(1));
                        } else if (baseData.getString(-1, this.exceptions).equalsIgnoreCase("INOUT")) {
                            baseData.setData(4, new Integer(2));
                        } else if (baseData.getString(-1, this.exceptions).equalsIgnoreCase("OUT")) {
                            baseData.setData(4, new Integer(4));
                        } else {
                            baseData.setData(4, new Integer(0));
                        }
                    }
                    if (this.comm.serverOS != 8 || n != 12) break;
                    if (baseData.getString(-1, this.exceptions).equalsIgnoreCase("NO")) {
                        baseData.setData(4, new Integer(0));
                        break;
                    }
                    if (baseData.getString(-1, this.exceptions).equalsIgnoreCase("YES")) {
                        baseData.setData(4, new Integer(1));
                        break;
                    }
                    baseData.setData(4, new Integer(2));
                    break;
                }
                case 7: {
                    if (n == 3) {
                        BaseData baseData4 = this.request.getColumnBaseDataObject(n + 1, 10, this.warnings);
                        baseData.setData(4, this.request.drdaUtil.DB2ToJdbcTypeName(baseData4.getString(-1, this.exceptions)));
                    }
                    if (n == 7 && baseData.isNull) {
                        baseData.setInteger(0);
                    }
                    if (n != 4 || baseData.isNull || !baseData.getString(-1, this.exceptions).equalsIgnoreCase("")) break;
                    baseData.setString(this.request.drdaUtil.JdbcToDB2TypeName(((DRDAColumn)this.request.columnDescriptions.get((int)(n - 1))).baseDataObj.getIntegerNoConvert()));
                    break;
                }
                case 10: {
                    if (!(n != 6 && n != 4 && n != 8 || baseData.isNull())) {
                        baseData.setString(baseData.getString(-1, this.comm.exceptions).trim());
                    }
                }
                case 11: 
                case 12: {
                    if ((n == 1 || n == 5) && baseData.isNull) {
                        baseData.setString(((DB2ImplStatement)this.implStatement).implConn.databaseName.toUpperCase());
                    }
                    if (!(n != 2 && n != 6 || baseData.isNull())) {
                        baseData.setString(baseData.getString(-1, this.comm.exceptions).trim());
                    }
                    if ((n == 10 || n == 11) && baseData.isNull) {
                        baseData.setData(4, new Integer(3));
                    }
                    if (n == 14 && baseData.isNull) {
                        baseData.setData(4, new Integer(7));
                    }
                    if (n != 11 || this.comm.serverOS != 8 || this.comm.supportsStoredProcMetadata && (!this.comm.disableImportedKeysSystemProc || this.implStatement.databaseMetaDataResultSet != 12) && this.implStatement.databaseMetaDataResultSet != 10) break;
                    if (baseData.getString(-1, this.exceptions).equals("A")) {
                        baseData.setData(4, new Integer(3));
                        break;
                    }
                    if (baseData.getString(-1, this.exceptions).equals("C")) {
                        baseData.setData(4, new Integer(0));
                        break;
                    }
                    if (baseData.getString(-1, this.exceptions).equals("N")) {
                        baseData.setData(4, new Integer(2));
                        break;
                    }
                    if (baseData.getString(-1, this.exceptions).equals("R")) {
                        baseData.setData(4, new Integer(1));
                        break;
                    }
                    baseData.setData(4, new Integer(3));
                    break;
                }
                case 16: {
                    if (n == 7 && !baseData.isNull()) {
                        baseData.setNull(10);
                    }
                    if (n != 2 && n != 4 && n != 5 && n != 6 || baseData.isNull()) break;
                    baseData.setString(baseData.getString(-1, this.comm.exceptions).trim());
                    break;
                }
                case 13: {
                    if (n != 2 && n != 5 && n != 13 || baseData.isNull()) break;
                    baseData.setString(baseData.getString(-1, this.comm.exceptions).trim());
                    break;
                }
                case 5: {
                    if (n != 2 || baseData.isNull()) break;
                    baseData.setString(baseData.getString(-1, this.comm.exceptions).trim());
                    break;
                }
                case 9: 
                case 14: {
                    if (n != 2 || baseData.isNull()) break;
                    baseData.setString(baseData.getString(-1, this.comm.exceptions).trim());
                    break;
                }
                case 15: {
                    if (n != 1 && n != 2 || baseData.isNull()) break;
                    baseData.setString(baseData.getString(-1, this.comm.exceptions).trim());
                    break;
                }
            }
        }
        return baseData;
    }

    public void makeResultSetCached(UtilPagedTempBuffer utilPagedTempBuffer, int n, BaseColumns baseColumns, BaseParameters baseParameters, DRDAPkgNamCsn dRDAPkgNamCsn, boolean bl, boolean bl2, boolean bl3) throws SQLException {
        this.isCachedResultSet = true;
        UtilPagedTempBuffer utilPagedTempBuffer2 = utilPagedTempBuffer;
        DRDAByteOrderedDataReader dRDAByteOrderedDataReader = this.comm.createReader(utilPagedTempBuffer2, n);
        this.request = new DRDAResultSetRequest(this.request.implConn, this.request.comm, dRDAByteOrderedDataReader, this.request.writer, dRDAPkgNamCsn);
        this.request.setParameters(baseParameters);
        this.request.isStoredProcedureRS = bl;
        this.request.columnDescriptions = baseColumns;
        this.request.isCachedRequest = true;
        this.request.isStoredProcedure = true;
        this.request.processMode = 0;
        this.request.processReply(this.warnings);
        this.request.isCursorOpen = bl2;
        this.request.moreData = bl3;
    }

    public BaseColumns getColumnDescriptions() {
        return this.request.columnDescriptions;
    }

    protected boolean setupForNextResultSetInMultipleResult() throws SQLException {
        return true;
    }

    public BaseImplBlob readBlob(RandomAccessFile randomAccessFile) throws SQLException, IOException {
        try {
            long l = randomAccessFile.readLong();
            UtilPagedTempBuffer utilPagedTempBuffer = new UtilPagedTempBuffer();
            byte[] byArray = new byte[32000];
            int n = 0;
            long l2 = 0L;
            int n2 = new Long(l).intValue();
            while (n2 > 0) {
                n = randomAccessFile.read(byArray, 0, Math.min(32000, n2));
                utilPagedTempBuffer.write(l2, byArray, 0, n);
                n2 -= n;
                l2 += (long)n;
            }
            DB2ImplBlob dB2ImplBlob = new DB2ImplBlob(l, this.comm.implConn, utilPagedTempBuffer);
            return dB2ImplBlob;
        }
        catch (UtilException utilException) {
            throw new SQLException(utilException.getMessage());
        }
    }

    public void writeBlob(RandomAccessFile randomAccessFile, BaseImplBlob baseImplBlob) throws SQLException, IOException {
        try {
            UtilPagedTempBuffer utilPagedTempBuffer = ((DB2ImplBlob)baseImplBlob).getData();
            long l = utilPagedTempBuffer.getSize();
            randomAccessFile.writeLong(l);
            InputStream inputStream = utilPagedTempBuffer.getInputStream();
            int n = new Long(l).intValue();
            int n2 = 0;
            int n3 = 0;
            byte[] byArray = new byte[16384];
            while (n > 0) {
                n2 = inputStream.read(byArray, 0, Math.min(16384, n));
                randomAccessFile.write(byArray, 0, n2);
                n -= n2;
                n3 += n2;
            }
        }
        catch (IOException iOException) {
            throw this.comm.exceptions.getException(iOException);
        }
    }

    public BaseImplClob readClob(RandomAccessFile randomAccessFile) throws SQLException, IOException {
        try {
            boolean bl = randomAccessFile.readBoolean();
            long l = randomAccessFile.readLong();
            UtilPagedTempBuffer utilPagedTempBuffer = new UtilPagedTempBuffer();
            byte[] byArray = new byte[32000];
            int n = 0;
            long l2 = 0L;
            int n2 = new Long(l).intValue();
            while (n2 > 0) {
                n = randomAccessFile.read(byArray, 0, Math.min(32000, n2));
                utilPagedTempBuffer.write(l2, byArray, 0, n);
                n2 -= n;
                l2 += (long)n;
            }
            DB2ImplClob dB2ImplClob = new DB2ImplClob(this.comm.implConn, utilPagedTempBuffer, this.comm.transliteratorPool.getTransliteratorForCodePage("1200"));
            dB2ImplClob.setIsEmulatedClob(bl);
            return dB2ImplClob;
        }
        catch (UtilException utilException) {
            throw new SQLException(utilException.getMessage());
        }
    }

    public void writeClob(RandomAccessFile randomAccessFile, BaseImplClob baseImplClob) throws SQLException, IOException {
        try {
            UtilPagedTempBuffer utilPagedTempBuffer = ((DB2ImplClob)baseImplClob).getData();
            long l = utilPagedTempBuffer.getSize();
            randomAccessFile.writeBoolean(((DB2ImplClob)baseImplClob).getIsEmulatedClob());
            randomAccessFile.writeLong(l);
            InputStream inputStream = utilPagedTempBuffer.getInputStream();
            int n = new Long(l).intValue();
            int n2 = 0;
            int n3 = 0;
            byte[] byArray = new byte[16384];
            while (n > 0) {
                n2 = inputStream.read(byArray, 0, Math.min(16384, n));
                randomAccessFile.write(byArray, 0, n2);
                n -= n2;
                n3 += n2;
            }
        }
        catch (IOException iOException) {
            throw this.comm.exceptions.getException(iOException);
        }
    }

    public int getColumnAccess() {
        return 2;
    }
}

