/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.bridges.internal.ui.wizards;

import com.metamatrix.bridges.internal.ui.wizards.BridgeModelImportPage;
import com.metamatrix.bridges.io.BridgeImporter;
import com.metamatrix.bridges.io.IBridgeImporterListener;
import com.metamatrix.bridges.io.MetaMatrixOptionInfo;
import com.metamatrix.bridges.ui.BridgesUiPlugin;
import com.metamatrix.bridges.ui.IBridgesUiConstants;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.modeler.compare.DifferenceProcessor;
import com.metamatrix.modeler.compare.MergeProcessor;
import com.metamatrix.modeler.compare.ModelerComparePlugin;
import com.metamatrix.modeler.compare.ui.wizard.IDifferencingWizard;
import com.metamatrix.modeler.compare.ui.wizard.ShowDifferencesPage;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.ui.internal.wizard.AbstractWizard;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class BridgeImportWizard
extends AbstractWizard
implements IBridgeImporterListener,
IBridgesUiConstants,
IBridgesUiConstants.ExtensionPoints,
IBridgesUiConstants.Images,
IBridgesUiConstants.ExtensionPoints.ImporterBridge,
IExecutableExtension,
IDifferencingWizard,
FileUtils.Constants {
    private static final String EMPTY_STRING = "";
    private static final String PREFIX = I18nUtil.getPropertyPrefix((Class)(class$com$metamatrix$bridges$internal$ui$wizards$BridgeImportWizard == null ? (class$com$metamatrix$bridges$internal$ui$wizards$BridgeImportWizard = BridgeImportWizard.class$("com.metamatrix.bridges.internal.ui.wizards.BridgeImportWizard")) : class$com$metamatrix$bridges$internal$ui$wizards$BridgeImportWizard));
    private static final String UNKNOWN_TYPE = "unknownImporterType";
    private BridgeImporter importer;
    private MultiStatus result;
    private BridgeModelImportPage bmiPage;
    private ShowDifferencesPage sdPage;
    private List diffReports;
    private DifferenceProcessor diffProcessor;
    private boolean importComplete;
    private String importerTypeId = "unknownImporterType";
    static /* synthetic */ Class class$com$metamatrix$bridges$internal$ui$wizards$BridgeImportWizard;

    public BridgeImportWizard() {
        super((AbstractUIPlugin)BridgesUiPlugin.getDefault(), IBridgesUiConstants.UTIL.getString(PREFIX + "title"), BridgesUiPlugin.getDefault().getImageDescriptor("icons/full/wizban/importerWizard.gif"));
    }

    public boolean canFinish() {
        boolean result = false;
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage == this.bmiPage) {
            result = this.importer.isValid();
            if (this.importer.updatesRequired()) {
                result = false;
            }
        } else {
            boolean lastPage = currentPage == this.getPages()[this.getPages().length - 1];
            result = lastPage && currentPage.isPageComplete();
        }
        return result;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.sdPage) {
            return null;
        }
        return super.getPreviousPage(page);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.bmiPage && this.importer.updatesRequired()) {
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor theMonitor) throws InvocationTargetException {
                    if (!BridgeImportWizard.this.importComplete) {
                        BridgeImportWizard.this.result = BridgeImportWizard.this.importer.executeImport(theMonitor);
                        BridgeImportWizard.this.importComplete = true;
                    }
                }
            };
            try {
                ProgressMonitorDialog dlg = new ProgressMonitorDialog(this.getShell());
                dlg.run(true, true, (IRunnableWithProgress)op);
                if (dlg.getProgressMonitor().isCanceled()) {
                    return null;
                }
                return this.sdPage;
            }
            catch (Exception err) {
                this.importer.log(err.getMessage(), 4, err);
                return null;
            }
        }
        return null;
    }

    public boolean canFlipToNextPage(IWizardPage thePage) {
        if (this.importer.isValid() && this.importer.updatesRequired() && thePage == this.bmiPage) {
            return this.bmiPage.isPageComplete();
        }
        return false;
    }

    public int getPageCount() {
        if (this.getPages() != null && this.importer.updatesRequired()) {
            return 2;
        }
        return 1;
    }

    public void createPageControls(Composite thePageContainer) {
        this.createPageControls(thePageContainer, false);
    }

    public boolean finish() {
        boolean success = false;
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor theMonitor) throws InvocationTargetException {
                if (!BridgeImportWizard.this.importComplete) {
                    BridgeImportWizard.this.result = BridgeImportWizard.this.importer.executeImport(theMonitor);
                }
                BridgeImportWizard.this.importer.finish(!theMonitor.isCanceled());
                if (!theMonitor.isCanceled() && BridgeImportWizard.this.diffProcessor != null) {
                    MergeProcessor merge = ModelerComparePlugin.createMergeProcessor((DifferenceProcessor)BridgeImportWizard.this.diffProcessor);
                    merge.execute(theMonitor);
                }
                String targetPath = BridgeImportWizard.this.importer.getTargetLocation();
                IResource rsrc = ModelerCore.getWorkspace().getRoot().findMember(targetPath);
                if (rsrc == null && targetPath.indexOf("/") > -1) {
                    targetPath = targetPath.substring(targetPath.indexOf("/"));
                    rsrc = ModelerCore.getWorkspace().getRoot().findMember(targetPath);
                }
                if (rsrc != null) {
                    try {
                        rsrc.refreshLocal(2, theMonitor);
                    }
                    catch (CoreException e) {
                        throw new MetaMatrixRuntimeException((Throwable)e, e.getMessage());
                    }
                }
            }
        };
        try {
            ProgressMonitorDialog dlg = new ProgressMonitorDialog(this.getShell());
            dlg.run(true, true, (IRunnableWithProgress)op);
            if (this.result != null && !this.result.isOK()) {
                String errTitle = IBridgesUiConstants.UTIL.getString("BridgeImportWizard.errTitle");
                String err = IBridgesUiConstants.UTIL.getString("BridgeImportWizard.errFinish");
                ErrorDialog.openError((Shell)this.getShell(), (String)errTitle, (String)err, (IStatus)this.result);
            }
            if (dlg.getProgressMonitor().isCanceled()) {
                return true;
            }
            success = true;
        }
        catch (Exception err) {
            this.importer.log(err.getMessage(), 4, err);
            success = false;
        }
        return success;
    }

    public String getImporterTypeId() {
        return this.importerTypeId;
    }

    public List getDifferenceReports() {
        block4: {
            if (this.diffReports == null) {
                this.diffReports = new ArrayList();
                IRunnableWithProgress op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException {
                        try {
                            Iterator entries = BridgeImportWizard.this.importer.getUpdateMappings().iterator();
                            HashMap mappings = new HashMap();
                            while (entries.hasNext()) {
                                BridgeImporter.UpdateMapping mapping = (BridgeImporter.UpdateMapping)entries.next();
                                Resource existing = mapping.getExisting();
                                Resource neww = mapping.getNew();
                                if (existing == null || neww == null) continue;
                                BridgeImportWizard.this.diffProcessor = ModelerComparePlugin.createDifferenceProcessor((Resource)existing, (Resource)neww, mappings);
                                IStatus sts = BridgeImportWizard.this.diffProcessor.execute(monitor);
                                if (sts.isOK()) {
                                    BridgeImportWizard.this.diffReports.add(BridgeImportWizard.this.diffProcessor.getDifferenceReport());
                                    continue;
                                }
                                BridgeImportWizard.this.result.add((IStatus)BridgeImportWizard.this.result);
                            }
                        }
                        catch (OperationCanceledException err) {
                        }
                        catch (Exception err) {
                            throw new InvocationTargetException(err);
                        }
                        finally {
                            monitor.done();
                        }
                    }
                };
                try {
                    new ProgressMonitorDialog(this.getShell()).run(true, true, op);
                }
                catch (Throwable err) {
                    if (err instanceof InvocationTargetException) {
                        err = ((InvocationTargetException)err).getTargetException();
                    }
                    if (this.result == null) break block4;
                    String msg = IBridgesUiConstants.UTIL.getString("BridgeImportWizard.errGetDR");
                    Status child = new Status(4, IBridgesUiConstants.PLUGIN_ID, 0, msg, err);
                    this.result.add((IStatus)child);
                }
            }
        }
        return this.diffReports;
    }

    public void importComplete() {
        final Shell shell = this.getShell();
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                shell.forceActive();
            }
        });
    }

    private void initImporter() {
        this.importer = new BridgeImporter();
        this.importer.setListener((IBridgeImporterListener)this);
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(IBridgesUiConstants.PLUGIN_ID, "importerBridge");
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions.length > 0) {
            block2: for (int i = 0; i < extensions.length; ++i) {
                IExtension extension = extensions[i];
                String uniqueId = extension.getUniqueIdentifier();
                if (uniqueId == null || !uniqueId.equals(this.importerTypeId)) continue;
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                for (int j = 0; j < elements.length; ++j) {
                    IConfigurationElement elem = elements[j];
                    try {
                        if (new Boolean(elem.getAttribute("modelIsFolder")).booleanValue()) {
                            this.importer.setModelIsFolder(true);
                        } else {
                            IConfigurationElement[] fileExtElements = elem.getChildren("fileExtension");
                            String[] fileExtensions = new String[fileExtElements.length];
                            for (int fileExtIndex = 0; fileExtIndex < fileExtElements.length; ++fileExtIndex) {
                                fileExtensions[fileExtIndex] = '*' + FileUtils.Constants.FILE_EXTENSION_SEPARATOR + fileExtElements[fileExtIndex].getValue();
                            }
                            this.importer.setFileExtensions(fileExtensions);
                        }
                        IConfigurationElement[] udps = elem.getChildren("userDefinedProperty");
                        for (int udpIndex = 0; udpIndex < udps.length; ++udpIndex) {
                            MetaMatrixOptionInfo udp = this.createUdp(udps[udpIndex]);
                            this.importer.addUdp(udp);
                        }
                        this.importer.setDescription(elem.getAttribute("description"));
                        this.importer.setMiImportLibrary(elem.getAttribute("importBridgeName"));
                        this.importer.setMiExportLibrary(elem.getAttribute("exportBridgeName"));
                        this.setWindowTitle(elem.getAttribute("wizardTitle"));
                        continue block2;
                    }
                    catch (Exception theException) {
                        String msg = IBridgesUiConstants.UTIL.getString("BridgesImportWizard.loadBridgeProblem", (Object)"className");
                        this.importer.log(msg, 4, theException);
                        continue;
                    }
                }
            }
        } else {
            String msg = IBridgesUiConstants.UTIL.getString(PREFIX + "No_Import_Bridge_extensions_found_1");
            this.importer.log(msg, 4, null);
        }
    }

    private MetaMatrixOptionInfo createUdp(IConfigurationElement element) {
        String name = element.getAttribute("name");
        String type = element.getAttribute("type");
        String defaultVal = element.getAttribute("defaultValue");
        if (defaultVal == null) {
            defaultVal = EMPTY_STRING;
        }
        return new MetaMatrixOptionInfo(name, type, null, defaultVal, null);
    }

    public void init(IWorkbench theWorkbench, IStructuredSelection theSelection) {
        this.initImporter();
        this.bmiPage = new BridgeModelImportPage(this.importer);
        this.addPage((IWizardPage)this.bmiPage);
        this.sdPage = new ShowDifferencesPage((IDifferencingWizard)this);
        this.addPage((IWizardPage)this.sdPage);
    }

    public void setInitializationData(IConfigurationElement theConfig, String thePropertyName, Object theData) throws CoreException {
        if (thePropertyName.equals("class")) {
            this.importerTypeId = (String)theData;
            if (this.importerTypeId == null || this.importerTypeId.length() == 0) {
                this.importerTypeId = UNKNOWN_TYPE;
                IBridgesUiConstants.UTIL.log(1, "Importer type not found for bridge importer.");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

