/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2;

import com.metamatrix.jdbc.base.BaseClassUtility;
import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseConnectionProperties;
import com.metamatrix.jdbc.base.BaseDriverPropertyInfos;
import com.metamatrix.jdbc.base.BaseEscapeTranslator;
import com.metamatrix.jdbc.base.BaseImplConnection;
import com.metamatrix.jdbc.base.BaseImplDatabaseMetaData;
import com.metamatrix.jdbc.db2.DB2EscapeTranslator;
import com.metamatrix.jdbc.db2.DB2ImplConnection;
import com.metamatrix.jdbc.db2.DB2ImplDatabaseMetaData;
import com.metamatrix.jdbc.db2.drda.DRDAConstants;
import java.sql.SQLException;

public class DB2Connection
extends BaseConnection {
    private static String footprint = "$Revision:   3.21.1.1  $";
    public DB2ImplConnection implCon;
    DB2ImplDatabaseMetaData databaseMetaData = null;

    protected void getImplPropertyInfo(BaseDriverPropertyInfos baseDriverPropertyInfos) {
        baseDriverPropertyInfos.put("packageCollection", "Collection where the system packages reside", DRDAConstants.DEFAULT_COLLECTION_ID_PROP, null, false);
        baseDriverPropertyInfos.put("databaseName", "Database name, Used for connections to UDB", null, null, false);
        baseDriverPropertyInfos.put("locationName", "Location Name, Used for connections to OS/390, zOS, and AS/400", null, null, false);
        baseDriverPropertyInfos.put("password", "Login Password", "", null, false);
        baseDriverPropertyInfos.put("user", "User name", "", null, false);
        baseDriverPropertyInfos.put("catalogSchema", "Allows user to specify alternate catalog for catalog functions", null, null, false);
        baseDriverPropertyInfos.put("useCurrentSchema", "Restricts unqualified catalog queries and wildcard queries to the current schema", DRDAConstants.DEFAULT_NEGATIVE_PROP, null, false);
        baseDriverPropertyInfos.put("enableCancelTimeout", "Subjects cancel requests to same query timeout value as the statement", DRDAConstants.DEFAULT_NEGATIVE_PROP, null, false);
        baseDriverPropertyInfos.put("charSetFor65535", "Specifies charset for translating binary data", "", null, false);
        String[] stringArray = new String[]{"None", "ClearText", "EncryptedPassword", "EncryptedUIDPassword", "Client"};
        baseDriverPropertyInfos.put("securityMechanism", "Specifies securityMechanism for db connection", "ClearText", stringArray, false);
        baseDriverPropertyInfos.put("authenticationMethod", "Authentication method used to connect", "ClearText", stringArray, false);
        baseDriverPropertyInfos.put("portNumber", "Port number", "50000", null, false);
        baseDriverPropertyInfos.put("addtoCreateTable", "Specifies the String to append to each CREATE statement.", null, null, false);
        if (BaseClassUtility.exposeCtsIncompatibleOptions()) {
            baseDriverPropertyInfos.put("withholdcursors", "Hold Cursors Over Commit", DRDAConstants.DEFAULT_AFFIRMATIVE_PROP, null, false);
        }
        baseDriverPropertyInfos.put("stripNewlines", "Strips newline characters from SQL statements before prepare.", DRDAConstants.DEFAULT_AFFIRMATIVE_PROP, null, false);
        baseDriverPropertyInfos.put("alternateID", "Alternate Schema for qualifying database objects.", null, null, false);
        baseDriverPropertyInfos.put("catalogIncludesSynonyms", "Includes Synonyms in catalog functions", DRDAConstants.DEFAULT_AFFIRMATIVE_PROP, null, false);
        baseDriverPropertyInfos.put("codePageOverride", "Code page override", null, null, false);
        if (BaseClassUtility.exposeCtsIncompatibleOptions()) {
            baseDriverPropertyInfos.put("sendStreamAsBlob", "Limits binary streams to the BLOB datatype", DRDAConstants.DEFAULT_NEGATIVE_PROP, null, false);
        }
        baseDriverPropertyInfos.put("allowImplicitResultSetCloseForXA", "Allows server to implicitly close resultSets", DRDAConstants.DEFAULT_AFFIRMATIVE_PROP, null, false);
        baseDriverPropertyInfos.put("createDefaultPackage", "Creates DB2 JDBC Default Package.", DRDAConstants.DEFAULT_NEGATIVE_PROP, null, false);
        baseDriverPropertyInfos.put("dynamicSections", "Specifies the number of statements\tthat the the DB2 driver package can\tprepare for a single user.", DRDAConstants.DEFAULT_DYNAMIC_SECTIONS_STRING, null, false);
        baseDriverPropertyInfos.put("grantee", "The userId to GRANT execute privileges to", DRDAConstants.DEFAULT_GRANTEE_PROP, null, false);
        baseDriverPropertyInfos.put("grantExecute", "Performs GRANT execute privileges to the specified grantee", DRDAConstants.DEFAULT_AFFIRMATIVE_PROP, null, false);
        baseDriverPropertyInfos.put("packageOwner", "Owner of the package.", null, null, false);
        baseDriverPropertyInfos.put("replacePackage", "Replace Existing Package", DRDAConstants.DEFAULT_NEGATIVE_PROP, null, false);
        baseDriverPropertyInfos.put("collectionId", "Deprecated", null, null, false);
        baseDriverPropertyInfos.put("defaultQualifier", "Deprecated.", null, null, false);
        baseDriverPropertyInfos.put("packageName", "Deprecated.", DRDAConstants.DEFAULT_PACKAGE_NAME, null, false);
        baseDriverPropertyInfos.put("versionName", "Deprecated", DRDAConstants.DEFAULT_VERNAME_PROP, null, false);
        baseDriverPropertyInfos.put("isolationLevel", "Deprecated.", DRDAConstants.DEFAULT_ISOLATION_LEVEL_PROP, null, false);
        baseDriverPropertyInfos.put("dropDefaultPackage", "Deprecated.", DRDAConstants.DEFAULT_NEGATIVE_PROP, null, false);
        baseDriverPropertyInfos.put("forceFixRow", "Deprecated.", DRDAConstants.DEFAULT_NEGATIVE_PROP, null, false);
        baseDriverPropertyInfos.put("ServerName", "Name of server to connect to", null, null, false);
    }

    protected BaseImplConnection createImplConnection(BaseConnectionProperties baseConnectionProperties) {
        this.implCon = new DB2ImplConnection(this);
        return this.implCon;
    }

    public BaseImplDatabaseMetaData createImplDatabaseMetaData(BaseConnectionProperties baseConnectionProperties) throws SQLException {
        if (this.databaseMetaData == null) {
            this.databaseMetaData = new DB2ImplDatabaseMetaData(this.implCon);
        }
        return this.databaseMetaData;
    }

    public BaseEscapeTranslator createEscapeTranslator() throws SQLException {
        return new DB2EscapeTranslator(this.implCon);
    }
}

