/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.adaptor.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public final class DevClassPathHelper {
    private static boolean inDevelopmentMode = false;
    private static String[] devDefaultClasspath;
    private static Dictionary devProperties;

    private static String[] getDevClassPath(String id, Dictionary properties, String[] defaultClasspath) {
        String entry;
        String[] result = null;
        if (id != null && properties != null && (entry = (String)properties.get(id)) != null) {
            result = DevClassPathHelper.getArrayFromList(entry);
        }
        if (result == null) {
            result = defaultClasspath;
        }
        return result;
    }

    public static String[] getDevClassPath(String id, Dictionary properties) {
        if (properties == null) {
            return DevClassPathHelper.getDevClassPath(id, devProperties, devDefaultClasspath);
        }
        return DevClassPathHelper.getDevClassPath(id, properties, DevClassPathHelper.getArrayFromList((String)properties.get("*")));
    }

    public static String[] getDevClassPath(String id) {
        return DevClassPathHelper.getDevClassPath(id, null);
    }

    public static String[] getArrayFromList(String prop) {
        if (prop == null || prop.trim().equals("")) {
            return new String[0];
        }
        Vector<String> list = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(prop, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            list.addElement(token);
        }
        return list.isEmpty() ? new String[]{} : list.toArray(new String[list.size()]);
    }

    public static boolean inDevelopmentMode() {
        return inDevelopmentMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties load(URL url) {
        Properties props = new Properties();
        try {
            InputStream is = null;
            try {
                is = url.openStream();
                props.load(is);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return props;
    }

    static {
        devProperties = null;
        String osgiDev = System.getProperty("osgi.dev");
        if (osgiDev != null) {
            try {
                inDevelopmentMode = true;
                URL location = new URL(osgiDev);
                devProperties = DevClassPathHelper.load(location);
                if (devProperties != null) {
                    devDefaultClasspath = DevClassPathHelper.getArrayFromList((String)devProperties.get("*"));
                }
            }
            catch (MalformedURLException e) {
                devDefaultClasspath = DevClassPathHelper.getArrayFromList(osgiDev);
            }
        }
    }
}

