/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.config;

import com.metamatrix.common.application.ApplicationService;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.application.ClientConnectionListener;
import com.metamatrix.dqp.config.DQPConfigSource;
import com.metamatrix.dqp.internal.application.DQPComponent;
import com.metamatrix.dqp.service.DQPServiceNames;
import com.metamatrix.license.LicenseChecker;
import com.metamatrix.license.exception.LicenseVerificationException;

public class DQPLauncher {
    private DQPConfigSource configSource;

    public DQPLauncher(DQPConfigSource configSource) {
        this.configSource = configSource;
    }

    public DQPComponent createDqp() throws ApplicationInitializationException {
        return this.createDqp(null);
    }

    public DQPComponent createDqp(ClientConnectionListener listener) throws ApplicationInitializationException {
        DQPComponent dqp = null;
        dqp = listener != null ? new DQPComponent(listener) : new DQPComponent();
        try {
            LicenseChecker.loadLicense((ClassLoader)this.getClass().getClassLoader());
        }
        catch (LicenseVerificationException e) {
            String msg = DQPPlugin.Util.getString("DQPLauncher.LicenseFailed");
            LogManager.logError("DQP", msg);
            throw new ApplicationInitializationException((Throwable)e, msg);
        }
        dqp.initialize(this.configSource.getProperties());
        this.initServices();
        for (int i = 0; i < DQPServiceNames.ALL_SERVICES.length; ++i) {
            String serviceName = DQPServiceNames.ALL_SERVICES[i];
            ApplicationService appService = this.configSource.getService(serviceName);
            dqp.installService(serviceName, appService);
            if (appService == null) {
                LogManager.logWarning("DQP", DQPPlugin.Util.getString("DQPLauncher.InstallService_ServiceIsNull", serviceName));
                continue;
            }
            LogManager.logInfo("DQP", DQPPlugin.Util.getString("DQPLauncher.InstallService_ServiceInstalled", serviceName));
        }
        dqp.start();
        return dqp;
    }

    private void initServices() throws ApplicationInitializationException {
        for (int i = 0; i < DQPServiceNames.ALL_SERVICES.length; ++i) {
            String serviceName = DQPServiceNames.ALL_SERVICES[i];
            this.configSource.getService(serviceName);
        }
    }
}

