/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket.server;

import com.metamatrix.common.api.HostInfo;
import com.metamatrix.common.comm.api.ServerListener;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.platform.socket.ObjectSocket;
import com.metamatrix.common.comm.platform.socket.ObjectSocketImpl;
import com.metamatrix.common.comm.platform.socket.SocketClientInstanceStats;
import com.metamatrix.common.comm.platform.socket.SocketLog;
import com.metamatrix.common.comm.platform.socket.server.SocketClientInstance;
import com.metamatrix.common.net.SocketHelper;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.platform.vm.controller.SocketListenerStats;
import java.io.EOFException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class SocketListener {
    private HostInfo hostInfo;
    private SocketLog log;
    private ServerListener serverListener;
    private WorkerPool workerPool;
    private int inputBufferSize;
    private int outputBufferSize;
    private boolean isReady = false;
    private boolean exitRequested = false;
    private String bindAddress = null;
    private int maxSockets = 0;
    private int maxVirtualSockets = 0;
    private int objectsReadByInactives = 0;
    private int objectsWrittenByInactives = 0;
    private List readerThreads = new ArrayList();

    public SocketListener(int port, String hostaddress, String bindaddress, ServerListener serverListener, WorkerPool workerPool, SocketLog log, int inputBufferSize, int outputBufferSize) {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(hostaddress);
        }
        catch (UnknownHostException err) {
            // empty catch block
        }
        this.bindAddress = bindaddress;
        this.hostInfo = new HostInfo(hostaddress, port, inetAddress);
        this.log = log;
        this.serverListener = serverListener;
        this.workerPool = workerPool;
        this.inputBufferSize = inputBufferSize;
        this.outputBufferSize = outputBufferSize;
        if (log.isLogged("SocketListener.xtor", 5)) {
            log.logDetail("SocketListener.xtor", "serverListener = " + this.serverListener);
        }
    }

    public SocketListener(int port, String host, ServerListener serverListener, WorkerPool workerPool, SocketLog log, int inputBufferSize, int outputBufferSize) {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(host);
        }
        catch (UnknownHostException err) {
            // empty catch block
        }
        this.hostInfo = new HostInfo(host, port, inetAddress);
        this.bindAddress = this.hostInfo.getHostName();
        this.log = log;
        this.serverListener = serverListener;
        this.workerPool = workerPool;
        this.inputBufferSize = inputBufferSize;
        this.outputBufferSize = outputBufferSize;
        if (log.isLogged("SocketListener.xtor", 5)) {
            log.logDetail("SocketListener.xtor", "serverListener = " + this.serverListener);
        }
    }

    public void run() throws CommunicationException {
        try {
            if (this.log.isLogged("SocketListener.run", 5)) {
                this.log.logDetail("SocketListener.run", "binding to port:" + this.hostInfo.getPortNumber());
            }
            InetAddress inetAddr = InetAddress.getByName(this.bindAddress);
            ServerSocket serverSocket = SocketHelper.getServerSocket(this.hostInfo.getPortNumber(), 50, inetAddr);
            serverSocket.setReceiveBufferSize(this.inputBufferSize);
            serverSocket.setSoTimeout(500);
            while (true) {
                this.log.logDetail("SocketListener.run", "listening");
                this.isReady = true;
                Socket socket = null;
                while (socket == null) {
                    try {
                        socket = serverSocket.accept();
                    }
                    catch (SocketTimeoutException e) {
                        if (!this.exitRequested) continue;
                        break;
                    }
                }
                if (socket == null && this.exitRequested) {
                    serverSocket.close();
                    break;
                }
                if (this.log.isLogged("SocketListener.run", 5)) {
                    this.log.logDetail("SocketListener.run", "accepted connection to " + socket.getPort());
                }
                try {
                    ObjectSocketImpl objectSocket = new ObjectSocketImpl(socket, this.log, this.getClass().getClassLoader(), this.inputBufferSize, this.outputBufferSize);
                    ReaderThread readerThread = new ReaderThread(objectSocket, "SocketClientInstance-" + socket.getPort());
                    this.addReaderThread(readerThread);
                    readerThread.start();
                }
                catch (Throwable t) {
                    String logContext = "SocketListener.run";
                    String logMsg = "Error creating socket reader thread.";
                    if (t instanceof EOFException) {
                        this.log.logWarning(logContext, t, logMsg);
                    } else {
                        this.log.logError(logContext, t, logMsg);
                    }
                    try {
                        socket.close();
                    }
                    catch (Throwable t1) {}
                }
            }
        }
        catch (Exception e) {
            throw new CommunicationException(e);
        }
    }

    public void stop() {
        this.exitRequested = true;
    }

    public boolean isReady() {
        return this.isReady;
    }

    protected synchronized void addReaderThread(ReaderThread readerThread) {
        this.readerThreads.add(readerThread);
    }

    public synchronized SocketListenerStats getStats() {
        SocketListenerStats stats = new SocketListenerStats();
        stats.objectsRead = this.objectsReadByInactives;
        stats.objectsWritten = this.objectsWrittenByInactives;
        for (ReaderThread thread : this.readerThreads) {
            SocketClientInstance instance = thread.getClientInstance();
            if (instance == null) continue;
            SocketClientInstanceStats instanceStats = instance.getStats();
            stats.objectsRead += instanceStats.objectsRead;
            stats.objectsWritten += instanceStats.objectsWritten;
            ++stats.sockets;
            stats.virtualSockets += instanceStats.virtualSockets.size();
        }
        stats.maxSockets = this.maxSockets = Math.max(this.maxSockets, stats.sockets);
        stats.maxVirtualSockets = this.maxVirtualSockets = Math.max(this.maxVirtualSockets, stats.virtualSockets);
        return stats;
    }

    protected class ReaderThread
    extends Thread {
        private ObjectSocket objectSocket;
        private boolean finished;
        private SocketClientInstance clientInstance;

        public ReaderThread(ObjectSocket objectSocket, String name) {
            super(name);
            this.finished = false;
            this.clientInstance = null;
            this.objectSocket = objectSocket;
        }

        protected void initClientInstance() {
            try {
                this.clientInstance = new SocketClientInstance(this.objectSocket, SocketListener.this.serverListener, SocketListener.this.workerPool, SocketListener.this.log, SocketListener.this.inputBufferSize, SocketListener.this.outputBufferSize);
                SocketListener.this.getStats();
            }
            catch (Throwable t) {
                SocketListener.this.log.logError("SocketListener.run", t, "Error creating client connection.");
                try {
                    this.objectSocket.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void recordStatistics() {
            SocketListener socketListener = SocketListener.this;
            synchronized (socketListener) {
                SocketListener.this.readerThreads.remove(this);
                if (this.clientInstance != null) {
                    SocketClientInstanceStats stats = this.clientInstance.getStats();
                    SocketListener.this.objectsReadByInactives = (int)((long)SocketListener.this.objectsReadByInactives + stats.objectsRead);
                    SocketListener.this.objectsWrittenByInactives = (int)((long)SocketListener.this.objectsWrittenByInactives + stats.objectsWritten);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.initClientInstance();
            try {
                if (this.clientInstance != null) {
                    this.clientInstance.read();
                }
            }
            finally {
                this.recordStatistics();
                this.finished = true;
            }
        }

        public boolean isFinished() {
            return this.finished;
        }

        public SocketClientInstance getClientInstance() {
            return this.clientInstance;
        }
    }
}

