/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.aop.AOP;
import com.metamatrix.common.aop.ProxyFactory;
import com.metamatrix.common.lob.LobChunk;
import com.metamatrix.common.lob.LobChunkInputStream;
import com.metamatrix.common.lob.LobChunkProducer;
import com.metamatrix.common.types.BlobType;
import com.metamatrix.common.types.InvalidReferenceException;
import com.metamatrix.core.log.Logger;
import com.metamatrix.dqp.message.CloseLobRequestMessage;
import com.metamatrix.dqp.message.LobRequestMessage;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.dqp.message.ResultsMessage;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMStatement;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class MMBlob
implements Blob {
    private MMStatement statement;
    private BlobType srcBlob;
    static /* synthetic */ Class class$com$metamatrix$jdbc$MMBlob;
    static /* synthetic */ Class class$com$metamatrix$jdbc$MMStatement;
    static /* synthetic */ Class class$com$metamatrix$common$types$BlobType;

    public static MMBlob newInstance(MMStatement statement, BlobType blob) {
        if (AOP.useproxy()) {
            Class<?> clazz;
            Class<?> clazz2 = class$com$metamatrix$jdbc$MMBlob;
            if (clazz2 == null) {
                clazz2 = class$com$metamatrix$jdbc$MMBlob = new MMBlob[0].getClass().getComponentType();
            }
            Class[] classArray = new Class[2];
            Class clazz3 = class$com$metamatrix$jdbc$MMStatement;
            if (clazz3 == null) {
                clazz3 = classArray[0] = (class$com$metamatrix$jdbc$MMStatement = new MMStatement[0].getClass().getComponentType());
            }
            if ((clazz = class$com$metamatrix$common$types$BlobType) == null) {
                clazz = class$com$metamatrix$common$types$BlobType = new BlobType[0].getClass().getComponentType();
            }
            classArray[1] = clazz;
            return (MMBlob)ProxyFactory.extend(clazz2, classArray, new Object[]{statement, blob});
        }
        return new MMBlob(statement, blob);
    }

    public MMBlob(MMStatement statement, BlobType blob) {
        this.statement = statement;
        this.srcBlob = blob;
    }

    public Logger getLogger() {
        return this.statement.getLogger();
    }

    public InputStream getBinaryStream() throws SQLException {
        try {
            this.checkReference();
            return this.srcBlob.getBinaryStream();
        }
        catch (InvalidReferenceException e) {
            return new LobStream(this.statement, this.srcBlob);
        }
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        try {
            this.checkReference();
            return this.srcBlob.getBytes(pos, length);
        }
        catch (InvalidReferenceException e) {
            return this.internal_getBytes(pos, length);
        }
    }

    byte[] internal_getBytes(long pos, int length) throws SQLException {
        byte[] dataCopy = new byte[length];
        if (pos < 1L) {
            Object[] params = new Object[]{new Long(pos)};
            throw new SQLException(JDBCPlugin.Util.getString("MMClob_MMBlob.0", params));
        }
        if (pos > this.length()) {
            return null;
        }
        if (length < 0) {
            Object[] params = new Object[]{new Integer(length)};
            throw new SQLException(JDBCPlugin.Util.getString("MMClob_MMBlob.3", params));
        }
        if (pos + (long)length > this.length()) {
            length = (int)(this.length() - pos);
        }
        LobStream in = new LobStream(this.statement, this.srcBlob);
        byte[] contents = in.getContents();
        System.arraycopy(contents, (int)pos, dataCopy, 0, length);
        return dataCopy;
    }

    public long length() throws SQLException {
        try {
            this.checkReference();
            return this.srcBlob.length();
        }
        catch (InvalidReferenceException e) {
            return this.internal_length();
        }
    }

    long internal_length() throws SQLException {
        LobStream in = new LobStream(this.statement, this.srcBlob);
        return in.getContents().length;
    }

    public long position(Blob pattern, long start) throws SQLException {
        try {
            this.checkReference();
            return this.srcBlob.position(pattern, start);
        }
        catch (InvalidReferenceException e) {
            return this.internal_position(pattern, start);
        }
    }

    long internal_position(Blob pattern, long start) throws SQLException {
        if (pattern == null || start > this.length()) {
            return -1L;
        }
        byte[] patternBytes = pattern.getBytes(1L, (int)pattern.length());
        return this.internal_position(patternBytes, start);
    }

    public long position(byte[] pattern, long start) throws SQLException {
        try {
            this.checkReference();
            return this.srcBlob.position(pattern, start);
        }
        catch (InvalidReferenceException e) {
            return this.internal_position(pattern, start);
        }
    }

    long internal_position(byte[] pattern, long start) throws SQLException {
        int position = 0;
        if (start < 1L) {
            Object[] params = new Object[]{new Long(start)};
            throw new SQLException(JDBCPlugin.Util.getString("MMClob_MMBlob.2", params));
        }
        if (pattern == null || start > this.length()) {
            return -1L;
        }
        String patternStr = new String(pattern);
        LobStream in = new LobStream(this.statement, this.srcBlob);
        String streamData = new String(in.getContents());
        position = streamData.indexOf(patternStr, (int)start - 1);
        if (position != -1) {
            ++position;
        }
        return position;
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        try {
            this.checkReference();
            return this.srcBlob.setBinaryStream(pos);
        }
        catch (InvalidReferenceException e) {
            throw new UnsupportedOperationException();
        }
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        try {
            this.checkReference();
            return this.srcBlob.setBytes(pos, bytes, offset, len);
        }
        catch (InvalidReferenceException e) {
            throw new UnsupportedOperationException();
        }
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        try {
            this.checkReference();
            return this.srcBlob.setBytes(pos, bytes);
        }
        catch (InvalidReferenceException e) {
            throw new UnsupportedOperationException();
        }
    }

    public void truncate(long len) throws SQLException {
        try {
            this.checkReference();
            this.srcBlob.truncate(len);
        }
        catch (InvalidReferenceException e) {
            throw new UnsupportedOperationException();
        }
    }

    private void checkReference() {
        if (Boolean.getBoolean("FORCE_STREAMING")) {
            throw new InvalidReferenceException();
        }
    }

    static class LobStream
    extends LobChunkInputStream {
        private byte[] contents;
        static int counter = 0;

        public LobStream(final MMStatement statement, final BlobType blobReference) {
            super(new LobChunkProducer(){
                int streamRequestId = counter++;

                public LobChunk getNextChunk() throws IOException {
                    try {
                        LobRequestMessage request = new LobRequestMessage();
                        request.setStreamId(blobReference.getReferenceStreamId());
                        request.setStreamRequestId(this.streamRequestId);
                        request.setRequestID(new RequestID(statement.getCurrentRequestID()));
                        request.setMessageKey("LOB_" + Long.toString(statement.getCurrentRequestID()));
                        ResultsMessage message = (ResultsMessage)statement.executeAsynchAndWait(request);
                        if (message.getException() != null) {
                            MetaMatrixException e = message.getException();
                            if (e instanceof IOException) {
                                throw (IOException)((Object)e);
                            }
                            throw new IOException(message.getException().getMessage());
                        }
                        return message.getLobChunk();
                    }
                    catch (SQLException e) {
                        IOException ex = new IOException(JDBCPlugin.Util.getString("StreamImpl.Unable_to_read_data_from_stream", e.getMessage()));
                        ex.initCause(e);
                        throw ex;
                    }
                }

                public void close() throws IOException {
                    try {
                        CloseLobRequestMessage request = new CloseLobRequestMessage();
                        request.setStreamId(blobReference.getReferenceStreamId());
                        request.setStreamRequestId(this.streamRequestId);
                        request.setRequestID(new RequestID(statement.getCurrentRequestID()));
                        request.setMessageKey("LOB_" + Long.toString(statement.getCurrentRequestID()));
                        statement.executeAsynch(request);
                    }
                    catch (SQLException e) {
                        IOException ex = new IOException(e.getMessage());
                        ex.initCause(e);
                        throw ex;
                    }
                }
            });
        }

        byte[] getContents() throws SQLException {
            try {
                if (this.contents == null) {
                    ByteArrayOutputStream bis = new ByteArrayOutputStream(102400);
                    byte[] buf = new byte[10240];
                    int read = this.read(buf);
                    while (read != -1) {
                        bis.write(buf, 0, read);
                        read = this.read(buf);
                    }
                    this.close();
                    this.contents = bis.toByteArray();
                    bis.close();
                }
                return this.contents;
            }
            catch (IOException e) {
                throw new SQLException(e.getMessage());
            }
        }
    }
}

