/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util.crypto;

import com.metamatrix.api.exception.MetaMatrixRuntimeException;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoFactory;
import com.metamatrix.common.util.crypto.Cryptor;
import com.metamatrix.common.util.crypto.Encryptor;
import com.metamatrix.common.util.crypto.PasswordCryptoFactory;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.Properties;
import javax.crypto.Cipher;

public class CryptoUtil {
    public static final String NONE = "none";
    private static boolean encryptionEnabled = false;
    private static boolean encryptionInitialized = false;
    private static String providerName;
    private static String providerClassname;
    private static String DEFAULT_PROVIDER_CLASSNAME;
    public static final String ENCRYPT_PREFIX = "{mmencrypt}";

    public static synchronized String initJCEProvider() {
        if (encryptionInitialized) {
            return providerName;
        }
        providerName = System.getProperty("metamatrix.encryption.jce.provider");
        if (providerName != null && providerName.trim().length() > 0 && providerName.equalsIgnoreCase(NONE)) {
            encryptionEnabled = false;
            return null;
        }
        encryptionEnabled = true;
        Provider provider = null;
        if (providerName != null && providerName.trim().length() > 0) {
            try {
                provider = CryptoUtil.addProvider(providerName);
            }
            catch (Exception e) {
                throw new MetaMatrixRuntimeException(e, CommonPlugin.Util.getString("ERR.003.030.0060", providerName));
            }
        }
        Cipher c = null;
        try {
            c = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        }
        catch (Throwable err) {
            try {
                provider = CryptoUtil.addProvider(DEFAULT_PROVIDER_CLASSNAME);
                c = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            }
            catch (Exception e) {
                throw new MetaMatrixRuntimeException(e, CommonPlugin.Util.getString("ERR.003.030.0183", "RSA/ECB/PKCS1Padding"));
            }
        }
        provider = c.getProvider();
        providerName = provider.getName();
        providerClassname = provider.getClass().getName();
        encryptionInitialized = true;
        return providerName;
    }

    private static Provider addProvider(String providerName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = Class.forName(providerName);
        Provider provider = (Provider)clazz.newInstance();
        if (System.getProperty("java.vendor").indexOf("IBM") != -1) {
            Security.insertProviderAt(provider, 3);
        } else {
            Security.addProvider(provider);
        }
        return provider;
    }

    public static synchronized void unloadJCEProvider() {
        if (encryptionInitialized && providerName != null && !providerName.equals(NONE)) {
            try {
                Class<?> clazz = Class.forName(providerClassname);
                Provider p = (Provider)clazz.newInstance();
                Provider p1 = Security.getProvider(p.getName());
                p1.clear();
                Security.removeProvider(p.getName());
            }
            catch (Exception e) {
                System.out.println(CommonPlugin.Util.getString("ERR.003.030.0060", providerName));
            }
            encryptionInitialized = false;
        }
    }

    public static boolean isEncryptionEnabled() {
        CryptoUtil.initJCEProvider();
        return encryptionEnabled;
    }

    public static Properties propertyEncrypt(String match, Properties props) throws CryptoException {
        Cryptor theCryptor = PasswordCryptoFactory.getCryptor();
        Properties modifiedProps = new Properties();
        Enumeration<?> propEnum = props.propertyNames();
        while (propEnum.hasMoreElements()) {
            String propName = (String)propEnum.nextElement();
            if (match.equalsIgnoreCase(propName)) {
                String propVal = props.getProperty(propName);
                if (propVal == null) continue;
                if (propVal.trim().length() > 0) {
                    char[] cryptValue = theCryptor.encrypt(propVal.toCharArray());
                    modifiedProps.setProperty(propName, new String(cryptValue));
                    continue;
                }
                modifiedProps.setProperty(propName, propVal);
                continue;
            }
            modifiedProps.setProperty(propName, props.getProperty(propName));
        }
        return modifiedProps;
    }

    public static Properties propertyDecrypt(String match, Properties props) throws CryptoException {
        Cryptor theCryptor = PasswordCryptoFactory.getCryptor();
        Properties modifiedProps = new Properties();
        Enumeration<?> propEnum = props.propertyNames();
        while (propEnum.hasMoreElements()) {
            String propName = (String)propEnum.nextElement();
            if (match.equalsIgnoreCase(propName)) {
                String propVal = props.getProperty(propName);
                if (propVal == null) continue;
                if (propVal.trim().length() > 0) {
                    char[] cryptValue = theCryptor.decrypt(propVal.toCharArray());
                    modifiedProps.setProperty(propName, new String(cryptValue));
                    continue;
                }
                modifiedProps.setProperty(propName, propVal);
                continue;
            }
            modifiedProps.setProperty(propName, props.getProperty(propName));
        }
        return modifiedProps;
    }

    public static Properties propertyEncryptEndsWith(String pattern, Properties props) throws CryptoException {
        return CryptoUtil.propertyEncryptEndsWith(PasswordCryptoFactory.getCryptor(), pattern, props);
    }

    public static Properties propertyEncryptEndsWith(Encryptor encryptor, String pattern, Properties props) throws CryptoException {
        Properties modifiedProps = new Properties();
        Enumeration<?> propEnum = props.propertyNames();
        pattern = pattern.toUpperCase();
        while (propEnum.hasMoreElements()) {
            String propName = (String)propEnum.nextElement();
            if (propName.toUpperCase().endsWith(pattern)) {
                String propVal = props.getProperty(propName);
                if (propVal == null) continue;
                if (propVal.trim().length() > 0) {
                    char[] cryptValue = encryptor.encrypt(propVal.toCharArray());
                    modifiedProps.setProperty(propName, new String(cryptValue));
                    continue;
                }
                modifiedProps.setProperty(propName, propVal);
                continue;
            }
            modifiedProps.setProperty(propName, props.getProperty(propName));
        }
        return modifiedProps;
    }

    public static Properties propertyDecryptEndsWith(String pattern, Properties props) throws CryptoException {
        Cryptor theCryptor = PasswordCryptoFactory.getCryptor();
        Properties modifiedProps = new Properties();
        Enumeration<?> propEnum = props.propertyNames();
        pattern = pattern.toUpperCase();
        while (propEnum.hasMoreElements()) {
            String propName = (String)propEnum.nextElement();
            if (propName.toUpperCase().endsWith(pattern)) {
                String propVal = props.getProperty(propName);
                if (propVal == null) continue;
                if (propVal.trim().length() > 0) {
                    char[] cryptValue = theCryptor.decrypt(propVal.toCharArray());
                    modifiedProps.setProperty(propName, new String(cryptValue));
                    continue;
                }
                modifiedProps.setProperty(propName, propVal);
                continue;
            }
            modifiedProps.setProperty(propName, props.getProperty(propName));
        }
        return modifiedProps;
    }

    public static char[] stringEncrypt(char[] clearText) throws CryptoException {
        return PasswordCryptoFactory.getCryptor().encrypt(clearText);
    }

    public static char[] stringDecrypt(char[] cypherText) throws CryptoException {
        String v = new String(cypherText);
        if (v.trim().length() > 0) {
            Cryptor theCryptor = PasswordCryptoFactory.getCryptor();
            char[] clearText = theCryptor.decrypt(cypherText);
            return clearText;
        }
        return cypherText;
    }

    public static boolean isValueEncrypted(String value) {
        if (value == null || value.length() < 117) {
            return false;
        }
        try {
            if (value.startsWith(ENCRYPT_PREFIX)) {
                try {
                    CryptoFactory.decodeBytes(value.substring(ENCRYPT_PREFIX.length()).toCharArray());
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
                return true;
            }
            PasswordCryptoFactory.getDecryptor().decrypt(value.toCharArray());
            return true;
        }
        catch (CryptoException err) {
            return false;
        }
    }

    static {
        DEFAULT_PROVIDER_CLASSNAME = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    }
}

