/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.internal.jobs.WorkerPool;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class Worker
extends Thread {
    private static int nextWorkerNumber = 0;
    private volatile InternalJob currentJob;
    private final WorkerPool pool;

    public Worker(WorkerPool pool) {
        super("Worker-" + nextWorkerNumber++);
        this.pool = pool;
        this.setContextClassLoader(pool.defaultContextLoader);
    }

    public Job currentJob() {
        return (Job)this.currentJob;
    }

    private IStatus handleException(InternalJob job, Throwable t) {
        String message = NLS.bind(Messages.jobs_internalError, job.getName());
        return new Status(4, "org.eclipse.core.runtime", 2, message, t);
    }

    private void log(IStatus result) {
        try {
            InternalPlatform platform = InternalPlatform.getDefault();
            if (platform.isRunning()) {
                platform.log(result);
                return;
            }
        }
        catch (RuntimeException runtimeException) {}
        Throwable t = result.getException();
        if (t != null) {
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.setPriority(5);
        try {
            try {
                while ((this.currentJob = this.pool.startJob(this)) != null) {
                    Object var3_7;
                    if (this.currentJob == null) {
                        Object var5_8 = null;
                        this.currentJob = null;
                        this.pool.endWorker(this);
                        return;
                    }
                    this.currentJob.setThread(this);
                    IStatus result = Status.OK_STATUS;
                    try {
                        try {
                            result = this.currentJob.run(this.currentJob.getProgressMonitor());
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            result = Status.CANCEL_STATUS;
                        }
                        catch (Exception e) {
                            result = this.handleException(this.currentJob, e);
                        }
                        catch (ThreadDeath e) {
                            throw e;
                        }
                        catch (Error e) {
                            result = this.handleException(this.currentJob, e);
                        }
                    }
                    catch (Throwable throwable) {
                        var3_7 = null;
                        Thread.interrupted();
                        if (result == null) {
                            result = this.handleException(this.currentJob, new NullPointerException());
                        }
                        this.pool.endJob(this.currentJob, result);
                        if ((result.getSeverity() & 6) != 0) {
                            this.log(result);
                        }
                        this.currentJob = null;
                        throw throwable;
                    }
                    {
                        var3_7 = null;
                    }
                    Thread.interrupted();
                    if (result == null) {
                        result = this.handleException(this.currentJob, new NullPointerException());
                    }
                    this.pool.endJob(this.currentJob, result);
                    if ((result.getSeverity() & 6) != 0) {
                        this.log(result);
                    }
                    this.currentJob = null;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.currentJob = null;
            this.pool.endWorker(this);
            throw throwable;
        }
        {
            Object var5_10 = null;
            this.currentJob = null;
            this.pool.endWorker(this);
            return;
        }
    }
}

