/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.lang;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.CommandContainer;
import com.metamatrix.query.sql.proc.CreateUpdateProcedureCommand;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import java.util.ArrayList;
import java.util.List;

public abstract class ProcedureContainer
extends Command
implements CommandContainer {
    private List subCommands = new ArrayList(1);
    private int updateCount = -1;

    public abstract GroupSymbol getGroup();

    public Command getSubCommand() {
        if (this.subCommands.isEmpty()) {
            return null;
        }
        return (Command)this.subCommands.get(0);
    }

    public void setSubCommand(Command subCommand) {
        if (this.subCommands.isEmpty()) {
            this.subCommands.add(null);
        }
        if (subCommand == null) {
            this.subCommands.remove(0);
        } else {
            this.subCommands.set(0, subCommand);
        }
    }

    protected void copyMetadataState(Command copy) {
        super.copyMetadataState(copy);
        CreateUpdateProcedureCommand cupc = (CreateUpdateProcedureCommand)this.getSubCommand();
        if (cupc != null) {
            CreateUpdateProcedureCommand cupcCopy = (CreateUpdateProcedureCommand)cupc.clone();
            cupcCopy.setUserCommand(copy);
            ((ProcedureContainer)copy).subCommands.add(cupcCopy);
        }
    }

    public List getContainedCommands() {
        return this.subCommands;
    }

    public int updatingModelCount(QueryMetadataInterface metadata) throws MetaMatrixComponentException {
        if (this.updateCount != -1) {
            return this.updateCount;
        }
        if (this.getGroup().isTempGroupSymbol()) {
            return 0;
        }
        try {
            if (!metadata.isVirtualGroup(this.getGroup().getMetadataID())) {
                return 1;
            }
        }
        catch (QueryMetadataException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
        int updateCount = this.getSubCommandsUpdatingModelCount(metadata);
        if (updateCount == 0) {
            return 0;
        }
        return 2;
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public void setUpdateCount(int updateCount) {
        if (updateCount < 0) {
            return;
        }
        if (updateCount > 2) {
            updateCount = 2;
        }
        this.updateCount = updateCount;
    }
}

