/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.aop.AOP;
import com.metamatrix.common.aop.ProxyFactory;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.core.log.Logger;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMConnection;
import com.metamatrix.jdbc.MMSQLException;
import com.metamatrix.jdbc.MMXAResource;
import com.metamatrix.jdbc.api.Connection;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.HashSet;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public class MMXAConnection
implements XAConnection {
    private HashSet listeners;
    private XAResource resource;
    private MMConnection connection;
    private ConnectionSource cs;
    private boolean isClosed;

    public static MMXAConnection newInstance(ConnectionSource cs) {
        if (AOP.useproxy()) {
            return (MMXAConnection)ProxyFactory.extend(MMXAConnection.class, new Class[]{ConnectionSource.class}, new Object[]{cs});
        }
        return new MMXAConnection(cs);
    }

    public MMXAConnection(ConnectionSource cs) {
        this.cs = cs;
    }

    public java.sql.Connection getConnection() throws SQLException {
        MMConnection conn = this.getMMConnection();
        java.sql.Connection result = (java.sql.Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new CloseInterceptor(conn));
        return result;
    }

    MMConnection getMMConnection() throws SQLException {
        if (this.isClosed) {
            throw new SQLException(JDBCPlugin.Util.getString("MMXAConnection.connection_is_closed"));
        }
        if (this.connection == null || this.connection.isClosed()) {
            try {
                this.connection = this.cs.createConnection();
                this.connection.selectNewServerInstance();
            }
            catch (SQLException e) {
                this.handleException(e);
            }
            catch (CommunicationException err) {
                this.handleException(MMSQLException.create(err));
            }
        }
        return this.connection;
    }

    private void handleException(SQLException e) throws SQLException {
        this.notifyListener(e);
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        throw e;
    }

    public Logger getLogger() {
        if (this.connection == null) {
            return null;
        }
        return this.connection.getLogger();
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        this.listeners.add(listener);
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public XAResource getXAResource() throws SQLException {
        if (this.resource == null) {
            this.resource = MMXAResource.newInstance(this);
        }
        return this.resource;
    }

    public void close() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
        this.isClosed = true;
    }

    protected synchronized void notifyListener(SQLException e) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (ConnectionEventListener listener : this.listeners) {
                if (e == null) {
                    listener.connectionClosed(new ConnectionEvent(this));
                    continue;
                }
                listener.connectionErrorOccurred(new ConnectionEvent(this, e));
            }
        }
    }

    private final class CloseInterceptor
    implements InvocationHandler {
        private MMConnection proxiedConnection;

        CloseInterceptor(MMConnection connection) {
            this.proxiedConnection = connection;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("close".equals(method.getName())) {
                try {
                    if (!this.proxiedConnection.getAutoCommit()) {
                        this.proxiedConnection.getLogger().log(3, JDBCPlugin.Util.getString("MMXAConnection.rolling_back"));
                        if (this.proxiedConnection.getTransactionXid() == null) {
                            this.proxiedConnection.closeStatements();
                            this.proxiedConnection.rollback(false);
                        }
                    }
                }
                catch (SQLException e) {
                    this.proxiedConnection.getLogger().log(3, e, JDBCPlugin.Util.getString("MMXAConnection.rolling_back_error"));
                    MMXAConnection.this.handleException(e);
                }
                MMXAConnection.this.notifyListener(null);
                return null;
            }
            return method.invoke((Object)this.proxiedConnection, args);
        }
    }

    static interface ConnectionSource {
        public MMConnection createConnection() throws SQLException;
    }
}

