/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Sync;

public class Semaphore
implements Sync {
    protected long permits_;

    public Semaphore(long l) {
        this.permits_ = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Semaphore semaphore = this;
        synchronized (semaphore) {
            try {
                while (this.permits_ <= 0L) {
                    this.wait();
                }
                --this.permits_;
            }
            catch (InterruptedException interruptedException) {
                this.notify();
                throw interruptedException;
            }
        }
    }

    public boolean attempt(long l) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Semaphore semaphore = this;
        synchronized (semaphore) {
            if (this.permits_ > 0L) {
                --this.permits_;
                return true;
            }
            if (l <= 0L) {
                return false;
            }
            try {
                long l2 = System.currentTimeMillis();
                long l3 = l;
                do {
                    this.wait(l3);
                    if (this.permits_ <= 0L) continue;
                    --this.permits_;
                    return true;
                } while ((l3 = l - (System.currentTimeMillis() - l2)) > 0L);
                return false;
            }
            catch (InterruptedException interruptedException) {
                this.notify();
                throw interruptedException;
            }
        }
    }

    public synchronized void release() {
        ++this.permits_;
        this.notify();
    }

    public synchronized void release(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative argument");
        }
        this.permits_ += l;
        for (long i = 0L; i < l; ++i) {
            this.notify();
        }
    }

    public synchronized long permits() {
        return this.permits_;
    }
}

