/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.jms;

import com.metamatrix.connector.xml.SOAPConnectorState;
import com.metamatrix.connector.xml.XMLConnection;
import com.metamatrix.connector.xml.XMLExecution;
import com.metamatrix.connector.xml.base.BaseBatchProducer;
import com.metamatrix.connector.xml.base.BaseResultsProducer;
import com.metamatrix.connector.xml.base.CriteriaDesc;
import com.metamatrix.connector.xml.base.ExecutionInfo;
import com.metamatrix.connector.xml.base.QueryAnalyzer;
import com.metamatrix.connector.xml.base.Response;
import com.metamatrix.connector.xml.cache.IDocumentCache;
import com.metamatrix.connector.xml.jms.JMSConnection;
import com.metamatrix.connector.xml.jms.JMSConnectorState;
import com.metamatrix.connector.xml.jms.JMSRequestExecutor;
import com.metamatrix.connector.xml.soap.SOAPDocBuilder;
import com.metamatrix.data.api.AsynchQueryExecution;
import com.metamatrix.data.api.Batch;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.basic.BasicBatch;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Session;

public class JMSExecution
implements AsynchQueryExecution,
XMLExecution {
    JMSConnection connection;
    RuntimeMetadata metadata;
    ExecutionContext exeCtx;
    ConnectorEnvironment connectorEnv;
    Session session;
    ConnectorLogger logger;
    List requestExecutors;
    private int requestNumber = 0;
    List allResultsList;
    private int m_maxBatch;
    long executeStartTime;
    long receiveTimeoutDuration;
    private ExecutionInfo executionInfo;

    public JMSExecution(JMSConnection connection, RuntimeMetadata metadata, ExecutionContext exeCtx, ConnectorEnvironment connectorEnv, ConnectorLogger logger) throws ConnectorException {
        this.connection = connection;
        this.metadata = metadata;
        this.exeCtx = exeCtx;
        this.connectorEnv = connectorEnv;
        this.logger = logger;
        this.receiveTimeoutDuration = ((JMSConnectorState)((Object)connection.getState())).getReceiveTimeout();
        this.allResultsList = new ArrayList();
        try {
            this.session = connection.getJMSSession();
        }
        catch (JMSException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public void close() throws ConnectorException {
        try {
            if (this.session.getTransacted()) {
                this.session.commit();
            }
            this.session.close();
            this.connection.stop();
        }
        catch (Exception e) {
            this.logger.logError(e.getMessage());
        }
    }

    public void cancel() throws ConnectorException {
        try {
            if (this.session.getTransacted()) {
                this.session.commit();
            }
            this.session.close();
        }
        catch (JMSException e) {
            this.logger.logError(e.getMessage());
        }
    }

    public long getPollInterval() {
        long retval = this.timedOut() ? 0L : 100L;
        return retval;
    }

    public void executeAsynch(IQuery query, int maxBatchSize) throws ConnectorException {
        this.setExecuteStartTime(Calendar.getInstance().getTimeInMillis());
        this.m_maxBatch = maxBatchSize;
        QueryAnalyzer analyzer = new QueryAnalyzer(query, this.metadata, this.connection.getQueryPreprocessor(), this.logger, this.exeCtx, this.connectorEnv);
        this.executionInfo = analyzer.getExecutionInfo();
        List requestPerms = analyzer.getRequestPerms();
        this.requestExecutors = new ArrayList(requestPerms.size());
        Iterator requests = requestPerms.iterator();
        while (requests.hasNext()) {
            List<CriteriaDesc> criteriaListForOnePerm = Arrays.asList((CriteriaDesc[])requests.next());
            this.executionInfo.setParameters(criteriaListForOnePerm);
            this.requestExecutors.add(this.connection.getState().makeExecutor(this));
            this.incrementRequestNumber();
        }
    }

    public Batch nextBatch() throws ConnectorException {
        ArrayList<JMSRequestExecutor> unfinishedExecutors = new ArrayList<JMSRequestExecutor>();
        Iterator executors = this.requestExecutors.iterator();
        boolean haveResults = false;
        while (executors.hasNext()) {
            JMSRequestExecutor executor = (JMSRequestExecutor)executors.next();
            int responseCount = executor.getDocumentCount();
            for (int i = 0; i < responseCount; ++i) {
                if (executor.hasResponse()) {
                    Response response = executor.getXMLResponse(0);
                    if (this.connection.getState() instanceof SOAPConnectorState) {
                        SOAPDocBuilder.removeEnvelope((SOAPConnectorState)((Object)this.connection.getState()), response);
                    }
                    IDocumentCache cache = this.connection.getConnector().getStatementCache();
                    BaseResultsProducer resProducer = new BaseResultsProducer(cache, this.logger);
                    List responseResultList = resProducer.getResult(this.executionInfo, response);
                    this.allResultsList = BaseResultsProducer.combineResults(responseResultList, this.allResultsList);
                    haveResults = true;
                    continue;
                }
                unfinishedExecutors.add(executor);
            }
        }
        this.requestExecutors = unfinishedExecutors;
        BasicBatch batch = new BasicBatch();
        if (haveResults) {
            batch = BaseBatchProducer.createBatch(this.allResultsList, 0, this.m_maxBatch, this.executionInfo, this.exeCtx, this.connectorEnv);
            this.allResultsList.clear();
            if (this.requestExecutors.isEmpty()) {
                batch.setLast();
            }
        } else if (this.timedOut()) {
            this.logger.logInfo("Timed out");
            batch.setLast();
        }
        return batch;
    }

    private void setExecuteStartTime(long now) {
        this.executeStartTime = now;
    }

    private boolean timedOut() {
        return Calendar.getInstance().getTimeInMillis() - this.executeStartTime >= this.receiveTimeoutDuration;
    }

    public int getRequestNumber() {
        return this.requestNumber;
    }

    public void incrementRequestNumber() {
        ++this.requestNumber;
    }

    public ExecutionInfo getInfo() {
        return this.executionInfo;
    }

    public XMLConnection getConnection() {
        return this.connection;
    }

    public IDocumentCache getCache() {
        return this.connection.getConnector().getCache();
    }

    public ExecutionContext getExeContext() {
        return this.exeCtx;
    }
}

