/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.base;

import com.metamatrix.connector.xml.IQueryPreprocessor;
import com.metamatrix.connector.xml.base.CriteriaDesc;
import com.metamatrix.connector.xml.base.ExecutionInfo;
import com.metamatrix.connector.xml.base.Messages;
import com.metamatrix.connector.xml.base.OutputXPathDesc;
import com.metamatrix.connector.xml.base.RequestGenerator;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.IElement;
import com.metamatrix.data.language.IExpression;
import com.metamatrix.data.language.IFrom;
import com.metamatrix.data.language.IGroup;
import com.metamatrix.data.language.ILiteral;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.language.ISelect;
import com.metamatrix.data.language.ISelectSymbol;
import com.metamatrix.data.metadata.runtime.Element;
import com.metamatrix.data.metadata.runtime.Group;
import com.metamatrix.data.metadata.runtime.MetadataID;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class QueryAnalyzer {
    private IQuery m_query;
    private IQueryPreprocessor preprocessor;
    private RuntimeMetadata m_metadata;
    private Group m_table;
    private ExecutionInfo m_info;
    private ConnectorLogger logger;
    private ConnectorEnvironment connectorEnv;
    private ExecutionContext exeContext;

    public QueryAnalyzer(IQuery query, RuntimeMetadata metadata, IQueryPreprocessor preprocessor, ConnectorLogger logger, ExecutionContext exeContext, ConnectorEnvironment connectorEnv) throws ConnectorException {
        this.setMetaData(metadata);
        this.setQuery(query);
        this.setPreprocessor(preprocessor);
        this.setLogger(logger);
        this.setExecutionContext(exeContext);
        this.setConnectorEnvironment(connectorEnv);
        this.m_info = new ExecutionInfo();
        this.analyze();
    }

    private void setConnectorEnvironment(ConnectorEnvironment connectorEnv) {
        this.connectorEnv = connectorEnv;
    }

    private void setExecutionContext(ExecutionContext exeContext) {
        this.exeContext = exeContext;
    }

    private void setLogger(ConnectorLogger logger) {
        this.logger = logger;
    }

    private void setPreprocessor(IQueryPreprocessor preprocessor) {
        this.preprocessor = preprocessor;
    }

    public final void analyze() throws ConnectorException {
        IQuery newQuery = this.preprocessor.preprocessQuery(this.m_query, this.m_metadata, this.exeContext, this.connectorEnv, this.logger);
        this.logger.logTrace("XML Connector Framework: executing command: " + newQuery);
        this.setQuery(newQuery);
        this.setTable();
        this.setRequestedColumns();
        this.setParametersAndCriteria();
        this.setOtherProperties();
    }

    private void setMetaData(RuntimeMetadata metadata) {
        this.m_metadata = metadata;
    }

    private void setQuery(IQuery query) {
        this.m_query = query;
    }

    public ExecutionInfo getExecutionInfo() {
        return this.m_info;
    }

    private void setTable() throws ConnectorException {
        IFrom from = this.m_query.getFrom();
        List fromItems = from.getItems();
        IGroup group = (IGroup)fromItems.get(0);
        MetadataID id = group.getMetadataID();
        this.m_table = (Group)this.m_metadata.getObject(id);
        this.m_info.setTableXPath(this.m_table.getNameInSource());
    }

    private void setRequestedColumns() throws ConnectorException {
        ArrayList<OutputXPathDesc> columns = new ArrayList<OutputXPathDesc>();
        ISelect select = this.m_query.getSelect();
        List selectSymbols = select.getSelectSymbols();
        Iterator symbolsIterator = selectSymbols.iterator();
        int projectedColumnCount = 0;
        while (symbolsIterator.hasNext()) {
            ISelectSymbol selectSymbol = (ISelectSymbol)symbolsIterator.next();
            IExpression expr = selectSymbol.getExpression();
            OutputXPathDesc xpath = null;
            if (expr instanceof ILiteral) {
                xpath = new OutputXPathDesc((ILiteral)expr);
            } else if (expr instanceof IElement) {
                MetadataID elementID = ((IElement)expr).getMetadataID();
                Element element = (Element)this.m_metadata.getObject(elementID);
                xpath = new OutputXPathDesc(element);
            }
            if (xpath != null) {
                xpath.setColumnNumber(projectedColumnCount);
            }
            columns.add(xpath);
            ++projectedColumnCount;
        }
        this.m_info.setColumnCount(projectedColumnCount);
        this.m_info.setRequestedColumns(columns);
    }

    private void setParametersAndCriteria() throws ConnectorException {
        MetadataID groupID = this.m_table.getMetadataID();
        List elementList = groupID.getChildIDs();
        ArrayList params = new ArrayList();
        ArrayList crits = new ArrayList();
        ArrayList responses = new ArrayList();
        ArrayList locations = new ArrayList();
        Iterator elementListIterator = elementList.iterator();
        while (elementListIterator.hasNext()) {
            MetadataID elementID = (MetadataID)elementListIterator.next();
            Element element = (Element)this.m_metadata.getObject(elementID);
            CriteriaDesc criteria = CriteriaDesc.getCriteriaDescForColumn(element, this.m_query);
            if (criteria == null) continue;
            this.mapCriteriaToColumn(criteria, params, crits, responses, locations);
        }
        this.m_info.setParameters(params);
        this.m_info.setCriteria(crits);
        String location = null;
        Iterator iter = locations.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            CriteriaDesc crtierion = (CriteriaDesc)o;
            ArrayList values = crtierion.getValues();
            Iterator valuesIter = values.iterator();
            while (valuesIter.hasNext()) {
                Object oValue = valuesIter.next();
                String value = (String)oValue;
                if (location != null && !location.equals(value)) {
                    throw new ConnectorException(Messages.getString("QueryAnalyzer.multiple.locations.supplied"));
                }
                location = value;
            }
        }
        this.m_info.setLocation(location);
    }

    private void mapCriteriaToColumn(CriteriaDesc criteria, ArrayList params, ArrayList crits, ArrayList responses, ArrayList locations) throws ConnectorException {
        int totalColumnCount = this.m_info.getColumnCount();
        String criteriaColName = criteria.getColumnName();
        boolean matchedField = false;
        OutputXPathDesc xpath = null;
        for (int j = 0; j < this.m_info.getRequestedColumns().size(); ++j) {
            xpath = (OutputXPathDesc)this.m_info.getRequestedColumns().get(j);
            String projColName = xpath.getColumnName();
            if (!criteriaColName.equals(projColName)) continue;
            matchedField = true;
            criteria.setColumnNumber(j);
            break;
        }
        if (criteria.isParameter() || criteria.isResponseId() && !criteria.isLocation()) {
            params.add(criteria);
            if (criteria.isResponseId()) {
                responses.add(criteria);
            }
        } else {
            if (!matchedField) {
                criteria.setColumnNumber(totalColumnCount);
                xpath = new OutputXPathDesc(criteria.getElement());
                xpath.setColumnNumber(totalColumnCount++);
                this.m_info.getRequestedColumns().add(xpath);
            }
            if (xpath.isResponseId()) {
                responses.add(criteria);
            } else if (xpath.isLocation()) {
                locations.add(criteria);
            } else {
                crits.add(criteria);
            }
        }
    }

    private void setOtherProperties() throws ConnectorException {
        this.m_info.setOtherProperties(this.m_table.getProperties());
    }

    public List getRequestPerms() {
        return RequestGenerator.getRequestPerms(this.m_info.getParameters());
    }
}

