/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.common.actions.AttributeDefinition;
import com.metamatrix.common.actions.ClassDefinition;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.security.api.AuthorizationPolicyID;
import java.util.HashMap;
import java.util.Map;

public class AuthorizationModel {
    private static int ATTRIBUTE_DEFINITION_COUNT = 6;
    private static Map classLookup = new HashMap(3);
    private static Map classLookupByIDClass = new HashMap();
    private static AttributeDefinition[] attributeDefinitions = new AttributeDefinition[ATTRIBUTE_DEFINITION_COUNT];
    static /* synthetic */ java.lang.Class class$com$metamatrix$platform$security$api$AuthorizationPolicy;
    static /* synthetic */ java.lang.Class class$com$metamatrix$platform$security$api$AuthorizationPolicyID;

    public static ClassDefinition getClassDefinition(Class c) {
        return (ClassDefinition)classLookup.get(c);
    }

    public static ClassDefinition getClassDefinition(Object obj) {
        return (ClassDefinition)classLookup.get(obj.getClass());
    }

    public static ClassDefinition getClassDefinition(AuthorizationPolicyID policyID) {
        return (ClassDefinition)classLookupByIDClass.get(policyID.getClass());
    }

    public static AttributeDefinition getAttributeDefinition(int code) {
        if (code < 0 || code >= ATTRIBUTE_DEFINITION_COUNT) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0009", code));
        }
        return attributeDefinitions[code];
    }

    private static void addAttributeToLookupMap(AttributeDefinition attribute) {
        AuthorizationModel.attributeDefinitions[attribute.getCode()] = attribute;
    }

    static /* synthetic */ java.lang.Class class$(String x0) {
        try {
            return java.lang.Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        classLookup.put(Class.POLICY.getClassObject(), Class.POLICY);
        classLookupByIDClass.put(Class.POLICYID.getClassObject(), class$com$metamatrix$platform$security$api$AuthorizationPolicyID == null ? (class$com$metamatrix$platform$security$api$AuthorizationPolicyID = AuthorizationModel.class$("com.metamatrix.platform.security.api.AuthorizationPolicyID")) : class$com$metamatrix$platform$security$api$AuthorizationPolicyID);
        AuthorizationModel.addAttributeToLookupMap(Attribute.DESCRIPTION);
        AuthorizationModel.addAttributeToLookupMap(Attribute.PRINCIPAL_NAME);
        AuthorizationModel.addAttributeToLookupMap(Attribute.PRINCIPAL_SET);
        AuthorizationModel.addAttributeToLookupMap(Attribute.PERMISSION);
        AuthorizationModel.addAttributeToLookupMap(Attribute.PERMISSIONS);
        AuthorizationModel.addAttributeToLookupMap(Attribute.PERMISSION_SET);
    }

    public static class Attribute {
        public static final AttributeDefinition DESCRIPTION = new AttributeDefinition(0, "DESCRIPTION");
        public static final AttributeDefinition PRINCIPAL_NAME = new AttributeDefinition(1, "PRINCIPAL_NAME");
        public static final AttributeDefinition PRINCIPAL_SET = new AttributeDefinition(2, "PRINCIPAL_SET");
        public static final AttributeDefinition PERMISSION = new AttributeDefinition(3, "PERMISSION");
        public static final AttributeDefinition PERMISSIONS = new AttributeDefinition(4, "PERMISSIONS");
        public static final AttributeDefinition PERMISSION_SET = new AttributeDefinition(5, "PERMISSION_SET");
    }

    public static class Class {
        public static final ClassDefinition POLICY = new ClassDefinition(class$com$metamatrix$platform$security$api$AuthorizationPolicy == null ? (class$com$metamatrix$platform$security$api$AuthorizationPolicy = AuthorizationModel.class$("com.metamatrix.platform.security.api.AuthorizationPolicy")) : class$com$metamatrix$platform$security$api$AuthorizationPolicy);
        public static final ClassDefinition POLICYID = new ClassDefinition(class$com$metamatrix$platform$security$api$AuthorizationPolicyID == null ? (class$com$metamatrix$platform$security$api$AuthorizationPolicyID = AuthorizationModel.class$("com.metamatrix.platform.security.api.AuthorizationPolicyID")) : class$com$metamatrix$platform$security$api$AuthorizationPolicyID);
    }
}

