/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket.server;

import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.MessageHolder;
import com.metamatrix.common.comm.api.ServerListener;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.platform.socket.SocketLog;
import com.metamatrix.common.comm.platform.socket.server.ServerWorkItem;
import com.metamatrix.common.comm.platform.socket.server.SocketClientConnection;
import com.metamatrix.common.comm.service.ExceptionHolder;

public class ServerAsynchronousWorkItem
extends ServerWorkItem {
    String messageKey;

    public ServerAsynchronousWorkItem(SocketClientConnection clientConnection, ServerListener serverListener, Message message, String messageKey, SocketLog log) {
        super(clientConnection, message, log, serverListener);
        this.messageKey = messageKey;
    }

    void process() throws CommunicationException {
        if (this.log.isLogged("ServerAsynchronousWorkItem.process", 5)) {
            this.log.logDetail("ServerAsynchronousWorkItem.process", "forwarding message to listener:" + this.message);
        }
        try {
            this.serverListener.receive(this.clientConnection, this.message, this.messageKey);
        }
        catch (Throwable t) {
            MessageHolder holder = new MessageHolder();
            ExceptionHolder exceptionHolder = new ExceptionHolder(t);
            holder.contents = exceptionHolder;
            this.clientConnection.send(holder, this.messageKey);
        }
    }
}

