/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.admin.util;

import com.metamatrix.admin.AdminPlugin;
import com.metamatrix.admin.api.exception.AdminComponentException;
import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.exception.AdminProcessingException;
import com.metamatrix.admin.api.server.AdminRoles;
import com.metamatrix.admin.util.IAdminMethodRoleResolver;
import com.metamatrix.common.util.PropertiesUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class AdminMethodRoleResolver
implements IAdminMethodRoleResolver {
    private Map methodsToRoles = new HashMap();
    private static final String DEFAUT_METHOD_ROLES_FILE = "methodroles.properties";
    String METHOD_ROLES_FILE = null;

    public String getRoleNameForMethod(String methodName) throws AdminException {
        if (!this.methodsToRoles.containsKey(methodName)) {
            Object[] params = new Object[]{methodName};
            String msg = AdminPlugin.Util.getString("AdminMethodRoleResolver.Unknown_method", params);
            throw new AdminProcessingException(msg);
        }
        String roleName = (String)this.methodsToRoles.get(methodName);
        return roleName;
    }

    public void init() throws AdminException {
        String propFilePath = this.METHOD_ROLES_FILE == null ? DEFAUT_METHOD_ROLES_FILE : this.METHOD_ROLES_FILE;
        Properties properties = null;
        try {
            properties = PropertiesUtils.loadAsResource(this.getClass(), propFilePath);
        }
        catch (Exception err) {
            AdminComponentException e = new AdminComponentException("Unable to load " + propFilePath + " file: " + err.getMessage());
            e.setStackTrace(err.getStackTrace());
            throw e;
        }
        Properties allProps = new Properties();
        allProps.putAll((Map<?, ?>)properties);
        Set validRoleNames = AdminRoles.getAllRoleNames();
        Iterator<Object> keyItr = allProps.keySet().iterator();
        while (keyItr.hasNext()) {
            String key = (String)keyItr.next();
            String roleName = allProps.getProperty(key);
            if (roleName == null || roleName.length() == 0) {
                Object[] params = new Object[]{key};
                String msg = AdminPlugin.Util.getString("AdminMethodRoleResolver.No_roles_defined_for_method", params);
                throw new AdminComponentException(msg);
            }
            if (!validRoleNames.contains(roleName)) {
                Object[] params = new Object[]{key, roleName};
                String msg = AdminPlugin.Util.getString("AdminMethodRoleResolver.Invalid_role_defined_for_method", params);
                throw new AdminComponentException(msg);
            }
            this.methodsToRoles.put(key, roleName);
        }
    }
}

