/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseCallableStatement;
import com.metamatrix.jdbc.base.BaseCallableStatementPoolable;
import com.metamatrix.jdbc.base.BasePreparedStatement;
import com.metamatrix.jdbc.base.BasePreparedStatementPoolable;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public final class BaseStatementPool {
    private static String footprint = "$Revision:   1.6.1.0  $";
    public static final int TYPE_PREPARED_STATEMENT = 1;
    public static final int TYPE_CALLABLE_STATEMENT = 2;
    BasePoolListNode head;
    BasePoolListNode tail;
    int maxPoolSize;
    int poolSize = 0;
    boolean countingEnabled;
    long numHits;
    long numMisses;

    BaseStatementPool(int n) {
        this.maxPoolSize = n;
        this.numHits = 0L;
        this.numMisses = 0L;
        this.countingEnabled = true;
    }

    public BasePoolListNode getHead() {
        return this.head;
    }

    public BasePoolListNode getTail() {
        return this.tail;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public long getNumHits() {
        return this.numHits;
    }

    public long getNumMisses() {
        return this.numMisses;
    }

    public void resetCounts() {
        this.numHits = 0L;
        this.numMisses = 0L;
    }

    public void setCountingEnabled(boolean bl) {
        this.countingEnabled = bl;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int n) {
        this.maxPoolSize = n;
        if (this.poolSize > this.maxPoolSize) {
            if (this.maxPoolSize <= 0) {
                this.empty();
            } else {
                for (int i = this.poolSize - this.maxPoolSize; i > 0; --i) {
                    try {
                        this.head.statement.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    this.head = this.head.previous;
                }
                this.poolSize = this.maxPoolSize;
            }
        }
    }

    PreparedStatement makePreparedStatementPoolable(BasePreparedStatement basePreparedStatement) {
        BasePreparedStatementPoolable basePreparedStatementPoolable;
        basePreparedStatement.poolWrapper = basePreparedStatementPoolable = new BasePreparedStatementPoolable(basePreparedStatement, this);
        return basePreparedStatementPoolable;
    }

    CallableStatement makeCallableStatementPoolable(BaseCallableStatement baseCallableStatement) {
        BaseCallableStatementPoolable baseCallableStatementPoolable = new BaseCallableStatementPoolable(baseCallableStatement, this);
        baseCallableStatement.poolWrapper = baseCallableStatementPoolable;
        return baseCallableStatementPoolable;
    }

    public void putPreparedStatement(BasePreparedStatement basePreparedStatement) {
        try {
            basePreparedStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            try {
                basePreparedStatement.close();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            return;
        }
        this.putStatement(1, basePreparedStatement);
    }

    public void putCallableStatement(BaseCallableStatement baseCallableStatement) {
        try {
            baseCallableStatement.clearParameters();
        }
        catch (SQLException sQLException) {
            try {
                baseCallableStatement.close();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            return;
        }
        this.putStatement(2, baseCallableStatement);
    }

    private void putStatement(int n, BasePreparedStatement basePreparedStatement) {
        try {
            basePreparedStatement.clearBatchInternal();
            basePreparedStatement.closeCurrentResults(3, false);
            basePreparedStatement.implStatement.reset();
        }
        catch (SQLException sQLException) {
            try {
                basePreparedStatement.close();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            return;
        }
        BasePoolListNode basePoolListNode = new BasePoolListNode();
        basePoolListNode.statement = basePreparedStatement;
        basePoolListNode.statementType = n;
        BasePoolListNode basePoolListNode2 = this.tail;
        this.tail = basePoolListNode;
        this.tail.next = basePoolListNode2;
        this.tail.previous = null;
        basePreparedStatement.poolWrapper = null;
        if (basePoolListNode2 != null) {
            basePoolListNode2.previous = this.tail;
        }
        if (this.head == null) {
            this.head = this.tail;
        }
        ++this.poolSize;
        if (this.poolSize > this.maxPoolSize) {
            try {
                this.head.statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.head = this.head.previous;
            this.head.next = null;
            --this.poolSize;
        }
    }

    public PreparedStatement getPreparedStatement(String string, int n, int n2, boolean bl, String[] stringArray) {
        return (PreparedStatement)this.getStatement(1, string, n, n2, bl, stringArray);
    }

    public CallableStatement getCallableStatement(String string, int n, int n2) {
        return (CallableStatement)this.getStatement(2, string, n, n2, false, null);
    }

    private boolean match(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            return stringArray2 == null;
        }
        if (stringArray2 == null) {
            return false;
        }
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (stringArray[i].compareTo(stringArray2[i]) == 0) continue;
            return false;
        }
        return true;
    }

    private Statement getStatement(int n, String string, int n2, int n3, boolean bl, String[] stringArray) {
        BasePoolListNode basePoolListNode = this.head;
        while (basePoolListNode != null) {
            if (basePoolListNode.statementType == n && basePoolListNode.statement.implStatement.sql.getOriginal().equals(string) && basePoolListNode.statement.requestedResultSetType == n2 && basePoolListNode.statement.requestedResultSetConcurrency == n3 && basePoolListNode.statement.implStatement.autoGeneratedKeysRequested == bl && this.match(basePoolListNode.statement.implStatement.requestedKeyColumns, stringArray)) {
                if (basePoolListNode.previous != null) {
                    basePoolListNode.previous.next = basePoolListNode.next;
                }
                if (basePoolListNode.next != null) {
                    basePoolListNode.next.previous = basePoolListNode.previous;
                }
                if (basePoolListNode == this.head) {
                    this.head = this.head.previous;
                }
                if (basePoolListNode == this.tail) {
                    this.tail = this.tail.next;
                    if (this.tail == null) {
                        this.tail = this.head;
                    }
                }
                --this.poolSize;
                if (this.countingEnabled) {
                    ++this.numHits;
                }
                if (n == 2) {
                    return this.makeCallableStatementPoolable((BaseCallableStatement)basePoolListNode.statement);
                }
                return this.makePreparedStatementPoolable(basePoolListNode.statement);
            }
            basePoolListNode = basePoolListNode.previous;
        }
        if (this.countingEnabled) {
            ++this.numMisses;
        }
        return null;
    }

    public void empty() {
        while (this.head != null) {
            try {
                this.head.statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.head = this.head.previous;
        }
        this.poolSize = 0;
        this.tail = null;
    }

    public class BasePoolListNode {
        BasePreparedStatement statement;
        int statementType;
        BasePoolListNode previous;
        BasePoolListNode next;

        public BasePreparedStatement getStatement() {
            return this.statement;
        }

        public int getStatementType() {
            return this.statementType;
        }

        public BasePoolListNode getPrevious() {
            return this.previous;
        }

        public BasePoolListNode getNext() {
            return this.next;
        }
    }
}

