/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.message;

import com.metamatrix.common.comm.api.ClientConnection;
import com.metamatrix.dqp.message.DQPMessage;
import com.metamatrix.dqp.message.MessageProcessor;
import com.metamatrix.dqp.message.RequestID;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

public abstract class DQPInboundMessage
implements DQPMessage,
Externalizable {
    private transient ClientConnection clientConn;
    private String messageKey;
    private String connectionID;
    private String userName;
    private Serializable trustedPayload;
    private String vdbName;
    private String vdbVersion;
    private RequestID requestID;
    private Serializable executionPayload;

    public ClientConnection getClientConnection() {
        return this.clientConn;
    }

    public void assignToClientConnection(ClientConnection clientConn) {
        this.clientConn = clientConn;
        this.connectionID = (String)clientConn.getConnectionProperty("connectionID");
        if (this.requestID != null) {
            this.requestID = new RequestID(this.connectionID, this.requestID.getExecutionID());
        }
    }

    public void setClientConnection(ClientConnection clientConn) {
        this.clientConn = clientConn;
    }

    public void setUserParameters(ClientConnection connection) {
        this.userName = (String)connection.getConnectionProperty("user");
        this.vdbName = (String)connection.getConnectionProperty("vdbName");
        this.vdbVersion = (String)connection.getConnectionProperty("vdbVersion");
        this.trustedPayload = (Serializable)connection.getConnectionProperty("trustedPayload");
    }

    public void createRequestID() {
        if (this.requestID != null) {
            this.requestID = new RequestID(this.connectionID, this.requestID.getExecutionID());
        }
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public void setMessageKey(String key) {
        this.messageKey = key;
    }

    public String getConnectionID() {
        return this.connectionID;
    }

    public Serializable getTrustedPayload() {
        return this.trustedPayload;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getVdbName() {
        return this.vdbName;
    }

    public String getVdbVersion() {
        return this.vdbVersion;
    }

    public void setConnectionID(String connectionID) {
        this.connectionID = connectionID;
    }

    public void setExecutionPayload(Serializable executionPayload) {
        this.executionPayload = executionPayload;
    }

    public Serializable getExecutionPayload() {
        return this.executionPayload;
    }

    public void setTrustedPayload(Serializable trustedPayload) {
        this.trustedPayload = trustedPayload;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setVdbName(String vdbName) {
        this.vdbName = vdbName;
    }

    public void setVdbVersion(String vdbVersion) {
        this.vdbVersion = vdbVersion;
    }

    public RequestID getRequestID() {
        return this.requestID;
    }

    public void setRequestID(RequestID requestID) {
        this.requestID = requestID;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.messageKey = (String)in.readObject();
        this.connectionID = (String)in.readObject();
        this.userName = (String)in.readObject();
        this.trustedPayload = (Serializable)in.readObject();
        this.executionPayload = (Serializable)in.readObject();
        this.vdbName = (String)in.readObject();
        this.vdbVersion = (String)in.readObject();
        this.requestID = (RequestID)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.messageKey);
        out.writeObject(this.connectionID);
        out.writeObject(this.userName);
        out.writeObject(this.trustedPayload);
        out.writeObject(this.executionPayload);
        out.writeObject(this.vdbName);
        out.writeObject(this.vdbVersion);
        out.writeObject(this.requestID);
    }

    public abstract DQPMessage process(MessageProcessor var1) throws Exception;
}

