/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util.crypto.keymanage;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoKeyManager;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;

public class AsymKeyStoreManager
implements CryptoKeyManager {
    static final String KEYSTORE_TYPE = "JKS";
    private KeyStore keyStore;
    private String entryName;
    private char[] storePass;

    public AsymKeyStoreManager(String storeFile, char[] storePass, String entryName, boolean fromCP) throws CryptoException, FileNotFoundException, IOException {
        if (entryName == null) {
            throw new CryptoException("ERR.003.030.0086", CommonPlugin.Util.getString("ERR.003.030.0086"));
        }
        try {
            this.loadKeyStore(storeFile, storePass, fromCP);
        }
        catch (KeyStoreException e) {
            throw new CryptoException(e.getMessage());
        }
        this.entryName = entryName;
        this.storePass = storePass;
    }

    public AsymKeyStoreManager(URL storeFile, char[] storePass, String entryName) throws CryptoException, FileNotFoundException, IOException {
        if (entryName == null) {
            throw new CryptoException("ERR.003.030.0086", CommonPlugin.Util.getString("ERR.003.030.0086"));
        }
        try {
            this.loadKeyStore(storePass, storeFile.openStream());
        }
        catch (KeyStoreException e) {
            throw new CryptoException(e.getMessage());
        }
        this.entryName = entryName;
        this.storePass = storePass;
    }

    public AsymKeyStoreManager(String entryName, char[] storePass, KeyStore keyStore) {
        this.entryName = entryName;
        this.storePass = storePass;
        this.keyStore = keyStore;
    }

    public Key getEncryptKey() throws CryptoException {
        try {
            return this.getPublicKey(this.entryName);
        }
        catch (KeyStoreException e) {
            throw new CryptoException(e.getMessage());
        }
    }

    public Key getDecryptKey() throws CryptoException {
        try {
            return this.getPrivateKey(this.entryName);
        }
        catch (KeyStoreException e) {
            throw new CryptoException(e.getMessage());
        }
    }

    private Key getPrivateKey(String entryName) throws KeyStoreException {
        char[] entryPass = this.storePass;
        Key key = null;
        try {
            key = this.keyStore.getKey(entryName, entryPass);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyStoreException(CommonPlugin.Util.getString("ERR.003.030.0087", entryName, e.getMessage()));
        }
        catch (UnrecoverableKeyException e) {
            throw new KeyStoreException(CommonPlugin.Util.getString("ERR.003.030.0088", entryName, e.getMessage()));
        }
        if (key == null) {
            throw new KeyStoreException(CommonPlugin.Util.getString("ERR.003.030.0089", entryName));
        }
        return key;
    }

    private Key getPublicKey(String entryName) throws KeyStoreException {
        Certificate cert = this.keyStore.getCertificate(entryName);
        if (cert == null) {
            throw new KeyStoreException(CommonPlugin.Util.getString("ERR.003.030.0089", entryName));
        }
        return cert.getPublicKey();
    }

    private void loadKeyStore(String keyStoreFile, char[] keyStorePass, boolean fromCP) throws KeyStoreException, FileNotFoundException, IOException {
        InputStream stream = null;
        if (fromCP) {
            stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(keyStoreFile);
            if (stream == null) {
                throw new FileNotFoundException(CommonPlugin.Util.getString("ERR.003.030.0090", keyStoreFile));
            }
        } else {
            stream = new FileInputStream(keyStoreFile);
        }
        this.loadKeyStore(keyStorePass, stream);
    }

    private void loadKeyStore(char[] keyStorePass, InputStream stream) throws KeyStoreException, IOException {
        this.keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
        try {
            this.keyStore.load(stream, keyStorePass);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyStoreException(CommonPlugin.Util.getString("ERR.003.030.0087", this.entryName, e.getMessage()));
        }
        catch (CertificateException e) {
            throw new KeyStoreException(CommonPlugin.Util.getString("ERR.003.030.0091", e.getMessage()));
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public char[] getStorePassword() {
        return this.storePass;
    }
}

