/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util.crypto;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoFactory;
import com.metamatrix.common.util.crypto.CryptoKeyManager;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.common.util.crypto.Cryptor;
import com.metamatrix.common.util.crypto.Decryptor;
import com.metamatrix.common.util.crypto.Encryptor;
import com.metamatrix.common.util.crypto.NullCryptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;

public class PasswordCryptoFactory {
    public static final String KEYSTORE_NAME = "metamatrixpki.keystore";
    public static final String DEFAULT_KEY_NAME = "encrypt";
    private static boolean initialized = false;
    private static boolean ephemeralInitilization = false;
    private static CryptoFactory factory;
    public static final String PASS_KEY_NAME = "metamatrix.security.password.PasswordKeyStore";

    private static synchronized void init() throws CryptoException {
        if (!CryptoUtil.isEncryptionEnabled()) {
            return;
        }
        if (!initialized) {
            char[] storePass = PasswordCryptoFactory.getStorePass();
            String keyName = PasswordCryptoFactory.getKeyName();
            try {
                factory = CryptoFactory.init(KEYSTORE_NAME, storePass, keyName);
            }
            catch (FileNotFoundException e) {
                throw new CryptoException((Throwable)e, "ERR.003.030.0068", CommonPlugin.Util.getString("ERR.003.030.0068", e.getMessage()));
            }
            catch (IOException e) {
                throw new CryptoException((Throwable)e, "ERR.003.030.0068", CommonPlugin.Util.getString("ERR.003.030.0068", e.getMessage()));
            }
            initialized = true;
        }
    }

    public static synchronized void init(char[] storePass) throws CryptoException {
        if (!CryptoUtil.isEncryptionEnabled()) {
            return;
        }
        if (!initialized || ephemeralInitilization) {
            String keyName = PasswordCryptoFactory.getKeyName();
            try {
                factory = CryptoFactory.init(KEYSTORE_NAME, storePass, keyName);
            }
            catch (FileNotFoundException e) {
                throw new CryptoException((Throwable)e, "ERR.003.030.0068", CommonPlugin.Util.getString("ERR.003.030.0068", e.getMessage()));
            }
            catch (IOException e) {
                throw new CryptoException((Throwable)e, "ERR.003.030.0068", CommonPlugin.Util.getString("ERR.003.030.0068", e.getMessage()));
            }
            initialized = true;
            ephemeralInitilization = false;
        }
    }

    public static synchronized void init(String storeFilename, char[] storePass) throws CryptoException {
        if (!CryptoUtil.isEncryptionEnabled()) {
            return;
        }
        if (!initialized || ephemeralInitilization) {
            String keyName = PasswordCryptoFactory.getKeyName();
            try {
                factory = CryptoFactory.init(storeFilename, storePass, keyName, false);
            }
            catch (FileNotFoundException e) {
                throw new CryptoException((Throwable)e, "ERR.003.030.0068", CommonPlugin.Util.getString("ERR.003.030.0068", e.getMessage()));
            }
            catch (IOException e) {
                throw new CryptoException((Throwable)e, "ERR.003.030.0068", CommonPlugin.Util.getString("ERR.003.030.0068", e.getMessage()));
            }
            initialized = true;
            ephemeralInitilization = false;
        }
    }

    public static synchronized void init(URL storeFilename, char[] storePass) throws CryptoException {
        if (!CryptoUtil.isEncryptionEnabled()) {
            return;
        }
        if (!initialized || ephemeralInitilization) {
            String keyName = PasswordCryptoFactory.getKeyName();
            try {
                factory = CryptoFactory.init(storeFilename, storePass, keyName);
            }
            catch (FileNotFoundException e) {
                throw new CryptoException((Throwable)e, "ERR.003.030.0068", CommonPlugin.Util.getString("ERR.003.030.0068", e.getMessage()));
            }
            catch (IOException e) {
                throw new CryptoException((Throwable)e, "ERR.003.030.0068", CommonPlugin.Util.getString("ERR.003.030.0068", e.getMessage()));
            }
            initialized = true;
            ephemeralInitilization = false;
        }
    }

    public static synchronized void init(CryptoKeyManager keyManager) throws CryptoException {
        if (!CryptoUtil.isEncryptionEnabled()) {
            return;
        }
        factory = new CryptoFactory(keyManager);
        initialized = true;
        ephemeralInitilization = true;
    }

    private static String getKeyName() {
        return DEFAULT_KEY_NAME;
    }

    private static char[] getStorePass() throws CryptoException {
        String passKey = CurrentConfiguration.getProperty((String)PASS_KEY_NAME);
        if (passKey == null || passKey.length() == 0) {
            throw new CryptoException("ERR.003.030.0069", CommonPlugin.Util.getString("ERR.003.030.0069"));
        }
        return passKey.toCharArray();
    }

    public static Cryptor getCryptor() throws CryptoException {
        if (!CryptoUtil.isEncryptionEnabled()) {
            return new NullCryptor();
        }
        PasswordCryptoFactory.init();
        return factory.getCryptor();
    }

    public static Encryptor getSerializableEncryptor() throws CryptoException {
        if (!CryptoUtil.isEncryptionEnabled()) {
            return new NullCryptor();
        }
        PasswordCryptoFactory.init();
        return factory.getSerializableEncryptor();
    }

    public static Encryptor getEncryptor() throws CryptoException {
        return PasswordCryptoFactory.getCryptor();
    }

    public static Decryptor getDecryptor() throws CryptoException {
        return PasswordCryptoFactory.getCryptor();
    }

    public static CryptoKeyManager getCryptoKeyManager() throws CryptoException {
        PasswordCryptoFactory.init();
        return factory.getKeyManager();
    }

    public static void reinit() {
        initialized = false;
    }

    public static boolean isInitialized() {
        return initialized;
    }
}

