/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.admin.objects;

import com.metamatrix.admin.AdminPlugin;
import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.exception.AdminProcessingException;
import com.metamatrix.admin.api.objects.AdminObject;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.core.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public abstract class MMAdminObject
implements AdminObject,
Serializable {
    public static final long serialVersionUID = -8280437282118346149L;
    public static final String OBJECTS_PACKAGE = "com.metamatrix.admin.api.objects.";
    public static final int OBJECT_TYPE_CACHE = 0;
    public static final int OBJECT_TYPE_CONNECTION_POOL = 1;
    public static final int OBJECT_TYPE_CONNECTOR_BINDING = 2;
    public static final int OBJECT_TYPE_CONNECTOR_TYPE = 3;
    public static final int OBJECT_TYPE_DQP = 4;
    public static final int OBJECT_TYPE_ENTITLEMENT = 5;
    public static final int OBJECT_TYPE_EXTENSION_MODULE = 6;
    public static final int OBJECT_TYPE_GROUP = 7;
    public static final int OBJECT_TYPE_HOST = 8;
    public static final int OBJECT_TYPE_LOG_CONFIGURATION = 9;
    public static final int OBJECT_TYPE_MODEL = 10;
    public static final int OBJECT_TYPE_PROCESS_OBJECT = 11;
    public static final int OBJECT_TYPE_PROPERTY_DEFINITION = 12;
    public static final int OBJECT_TYPE_QUEUE_WORKER_POOL = 13;
    public static final int OBJECT_TYPE_REQUEST = 14;
    public static final int OBJECT_TYPE_RESOURCE = 15;
    public static final int OBJECT_TYPE_ROLE = 16;
    public static final int OBJECT_TYPE_SESSION = 17;
    public static final int OBJECT_TYPE_SOURCE_REQUEST = 18;
    public static final int OBJECT_TYPE_SYSTEM_OBJECT = 19;
    public static final int OBJECT_TYPE_USER = 20;
    public static final int OBJECT_TYPE_VDB = 21;
    private static HashMap objectTypeMap = new HashMap();
    protected String identifier;
    protected String[] identifierParts;
    protected String name;
    private Properties props = new Properties();
    private Date created;
    private String createdBy = "<default>";
    private Date lastUpdated;
    private String lastUpdatedBy = "<default>";
    protected boolean deployed;
    protected boolean registered;
    protected boolean enabled;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$Cache;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$ConnectionPool;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$ConnectorBinding;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$ConnectorType;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$DQP;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$Entitlement;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$ExtensionModule;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$Group;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$Host;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$LogConfiguration;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$Model;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$ProcessObject;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$PropertyDefinition;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$QueueWorkerPool;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$Request;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$Resource;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$Role;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$Session;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$SourceRequest;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$SystemObject;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$User;
    static /* synthetic */ Class class$com$metamatrix$admin$api$objects$VDB;

    public MMAdminObject(String[] identifierParts) {
        if (identifierParts == null) {
            throw new IllegalArgumentException(AdminPlugin.Util.getString("AbstractAdminObject.0"));
        }
        if (identifierParts.length == 0) {
            throw new IllegalArgumentException(AdminPlugin.Util.getString("AbstractAdminObject.1"));
        }
        this.setIdentifier(identifierParts);
    }

    public String getName() {
        return this.name;
    }

    protected static List buildIdentifierList(String identifier) {
        ArrayList<String> result = null;
        if (identifier.indexOf(124) != -1) {
            result = StringUtil.split(identifier, AdminObject.DELIMITER);
        } else {
            result = new ArrayList<String>(1);
            result.add(identifier);
        }
        return result;
    }

    public static String[] buildIdentifierArray(String identifier) {
        List list = MMAdminObject.buildIdentifierList(identifier);
        String[] array = new String[list.size()];
        return list.toArray(array);
    }

    public static String getNameFromIdentifier(String identifier) {
        List list = MMAdminObject.buildIdentifierList(identifier);
        int nameComponentCount = list.size();
        if (nameComponentCount > 0) {
            return (String)list.get(nameComponentCount - 1);
        }
        return null;
    }

    public static String getParentName(String identifier) {
        List list = MMAdminObject.buildIdentifierList(identifier);
        int nameComponentCount = list.size();
        if (nameComponentCount > 1) {
            return (String)list.get(nameComponentCount - 2);
        }
        return identifier;
    }

    public static String buildIdentifier(String[] identifierParts) {
        StringBuffer results = new StringBuffer();
        int length = identifierParts.length;
        for (int i = 0; i < length - 1; ++i) {
            results.append(identifierParts[i]).append('|');
        }
        results.append(identifierParts[length - 1]);
        return results.toString();
    }

    public Properties getProperties() {
        return this.props;
    }

    public String getPropertiesAsString() {
        String results = "";
        if (this.props != null) {
            results = PropertiesUtils.prettyPrint(this.props);
        }
        return results;
    }

    public void setIdentifier(String[] identifierParts) {
        this.identifier = MMAdminObject.buildIdentifier(identifierParts);
        this.identifierParts = identifierParts;
        this.name = identifierParts[identifierParts.length - 1];
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String[] getIdentifierArray() {
        return this.identifierParts;
    }

    public abstract String toString();

    public Date getCreatedDate() {
        return this.created;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Date getLastChangedDate() {
        return this.lastUpdated;
    }

    public String getLastChangedBy() {
        return this.lastUpdatedBy;
    }

    public String getPropertyValue(String name) {
        return this.props.getProperty(name);
    }

    public Date getCreated() {
        return this.created;
    }

    public boolean isDeployed() {
        return this.deployed;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public Properties getProps() {
        return this.props;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public void setDeployed(boolean deployed) {
        this.deployed = deployed;
    }

    public void setRegistered(boolean registered) {
        this.registered = registered;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public void setLastUpdatedBy(String lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public void setProperties(Properties props) {
        this.props = props;
    }

    public static int getObjectType(String className) throws AdminException {
        Integer codeInteger;
        if (className.indexOf(".") == -1) {
            className = OBJECTS_PACKAGE + className;
        }
        if ((codeInteger = (Integer)objectTypeMap.get(className)) == null) {
            String message = AdminPlugin.Util.getString("MMAdminObject.Unsupported_Admin_Object", new Object[]{className});
            throw new AdminProcessingException(message);
        }
        return codeInteger;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        objectTypeMap.put((class$com$metamatrix$admin$api$objects$Cache == null ? (class$com$metamatrix$admin$api$objects$Cache = MMAdminObject.class$("com.metamatrix.admin.api.objects.Cache")) : class$com$metamatrix$admin$api$objects$Cache).getName(), new Integer(0));
        objectTypeMap.put((class$com$metamatrix$admin$api$objects$ConnectionPool == null ? (class$com$metamatrix$admin$api$objects$ConnectionPool = MMAdminObject.class$("com.metamatrix.admin.api.objects.ConnectionPool")) : class$com$metamatrix$admin$api$objects$ConnectionPool).getName(), new Integer(1));
        objectTypeMap.put((class$com$metamatrix$admin$api$objects$ConnectorBinding == null ? (class$com$metamatrix$admin$api$objects$ConnectorBinding = MMAdminObject.class$("com.metamatrix.admin.api.objects.ConnectorBinding")) : class$com$metamatrix$admin$api$objects$ConnectorBinding).getName(), new Integer(2));
        objectTypeMap.put((class$com$metamatrix$admin$api$objects$ConnectorType == null ? (class$com$metamatrix$admin$api$objects$ConnectorType = MMAdminObject.class$("com.metamatrix.admin.api.objects.ConnectorType")) : class$com$metamatrix$admin$api$objects$ConnectorType).getName(), new Integer(3));
        objectTypeMap.put((class$com$metamatrix$admin$api$objects$DQP == null ? (class$com$metamatrix$admin$api$objects$DQP = MMAdminObject.class$("com.metamatrix.admin.api.objects.DQP")) : class$com$metamatrix$admin$api$objects$DQP).getName(), new Integer(4));
        objectTypeMap.put((class$com$metamatrix$admin$api$objects$Entitlement == null ? (class$com$metamatrix$admin$api$objects$Entitlement = MMAdminObject.class$("com.metamatrix.admin.api.objects.Entitlement")) : class$com$metamatrix$admin$api$objects$Entitlement).getName(), new Integer(5));
        objectTypeMap.put((class$com$metamatrix$admin$api$objects$ExtensionModule == null ? (class$com$metamatrix$admin$api$objects$ExtensionModule = MMAdminObject.class$("com.metamatrix.admin.api.objects.ExtensionModule")) : class$com$metamatrix$admin$api$objects$ExtensionModule).getName(), new Integer(6));
        objectTypeMap.put((class$com$metamatrix$admin$api$objects$Group == null ? (class$com$metamatrix$admin$api$objects$Group = MMAdminObject.class$("com.metamatrix.admin.api.objects.Group")) : class$com$metamatrix$admin$api$objects$Group).getName(), new Integer(7));
        objectTypeMap.put((class$com$metamatrix$admin$api$objects$Host == null ? (class$com$metamatrix$admin$api$objects$Host = MMAdminObject.class$("com.metamatrix.admin.api.objects.Host")) : class$com$metamatrix$admin$api$objects$Host).getName(), new Integer(8));
        objectTypeMap.put((class$com$metamatrix$admin$api$objects$LogConfiguration == null ? (class$com$metamatrix$admin$api$objects$LogConfiguration = MMAdminObject.class$("com.metamatrix.admin.api.objects.LogConfiguration")) : class$com$metamatrix$admin$api$objects$LogConfiguration).getName(), new Integer(9));
        objectTypeMap.put((class$com$metamatrix$admin$api$objects$Model == null ? (class$com$metamatrix$admin$api$objects$Model = MMAdminObject.class$("com.metamatrix.admin.api.objects.Model")) : class$com$metamatrix$admin$api$objects$Model).getName(), new Integer(10));
        objectTypeMap.put((class$com$metamatrix$admin$api$objects$ProcessObject == null ? (class$com$metamatrix$admin$api$objects$ProcessObject = MMAdminObject.class$("com.metamatrix.admin.api.objects.ProcessObject")) : class$com$metamatrix$admin$api$objects$ProcessObject).getName(), new Integer(11));
        objectTypeMap.put((class$com$metamatrix$admin$api$objects$PropertyDefinition == null ? (class$com$metamatrix$admin$api$objects$PropertyDefinition = MMAdminObject.class$("com.metamatrix.admin.api.objects.PropertyDefinition")) : class$com$metamatrix$admin$api$objects$PropertyDefinition).getName(), new Integer(12));
        objectTypeMap.put((class$com$metamatrix$admin$api$objects$QueueWorkerPool == null ? (class$com$metamatrix$admin$api$objects$QueueWorkerPool = MMAdminObject.class$("com.metamatrix.admin.api.objects.QueueWorkerPool")) : class$com$metamatrix$admin$api$objects$QueueWorkerPool).getName(), new Integer(13));
        objectTypeMap.put((class$com$metamatrix$admin$api$objects$Request == null ? (class$com$metamatrix$admin$api$objects$Request = MMAdminObject.class$("com.metamatrix.admin.api.objects.Request")) : class$com$metamatrix$admin$api$objects$Request).getName(), new Integer(14));
        objectTypeMap.put((class$com$metamatrix$admin$api$objects$Resource == null ? (class$com$metamatrix$admin$api$objects$Resource = MMAdminObject.class$("com.metamatrix.admin.api.objects.Resource")) : class$com$metamatrix$admin$api$objects$Resource).getName(), new Integer(15));
        objectTypeMap.put((class$com$metamatrix$admin$api$objects$Role == null ? (class$com$metamatrix$admin$api$objects$Role = MMAdminObject.class$("com.metamatrix.admin.api.objects.Role")) : class$com$metamatrix$admin$api$objects$Role).getName(), new Integer(16));
        objectTypeMap.put((class$com$metamatrix$admin$api$objects$Session == null ? (class$com$metamatrix$admin$api$objects$Session = MMAdminObject.class$("com.metamatrix.admin.api.objects.Session")) : class$com$metamatrix$admin$api$objects$Session).getName(), new Integer(17));
        objectTypeMap.put((class$com$metamatrix$admin$api$objects$SourceRequest == null ? (class$com$metamatrix$admin$api$objects$SourceRequest = MMAdminObject.class$("com.metamatrix.admin.api.objects.SourceRequest")) : class$com$metamatrix$admin$api$objects$SourceRequest).getName(), new Integer(18));
        objectTypeMap.put((class$com$metamatrix$admin$api$objects$SystemObject == null ? (class$com$metamatrix$admin$api$objects$SystemObject = MMAdminObject.class$("com.metamatrix.admin.api.objects.SystemObject")) : class$com$metamatrix$admin$api$objects$SystemObject).getName(), new Integer(19));
        objectTypeMap.put((class$com$metamatrix$admin$api$objects$User == null ? (class$com$metamatrix$admin$api$objects$User = MMAdminObject.class$("com.metamatrix.admin.api.objects.User")) : class$com$metamatrix$admin$api$objects$User).getName(), new Integer(20));
        objectTypeMap.put((class$com$metamatrix$admin$api$objects$VDB == null ? (class$com$metamatrix$admin$api$objects$VDB = MMAdminObject.class$("com.metamatrix.admin.api.objects.VDB")) : class$com$metamatrix$admin$api$objects$VDB).getName(), new Integer(21));
    }
}

