/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util.crypto.keymanage;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.util.ByteArrayHelper;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoKeyManager;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;

public class AsymKeyStoreManager
implements CryptoKeyManager {
    static final String KEYSTORE_TYPE = "JKS";
    public static final int SYMMETRIC = 0;
    public static final int ASYMMETRIC = 1;
    private KeyStore keyStore;
    private String entryName;
    private char[] storePass = null;

    public AsymKeyStoreManager(String storeFile, char[] storePass, String entryName) throws CryptoException, FileNotFoundException, IOException {
        this(storeFile, storePass, entryName, true);
    }

    public AsymKeyStoreManager(String storeFile, char[] storePass, String entryName, boolean fromCP) throws CryptoException, FileNotFoundException, IOException {
        if (entryName == null) {
            throw new CryptoException("ERR.003.030.0086", CommonPlugin.Util.getString("ERR.003.030.0086"));
        }
        try {
            this.loadKeyStore(storeFile, storePass, fromCP);
        }
        catch (KeyStoreException e) {
            throw new CryptoException(e.getMessage());
        }
        this.entryName = entryName;
        this.storePass = storePass;
    }

    public AsymKeyStoreManager(URL storeFile, char[] storePass, String entryName) throws CryptoException, FileNotFoundException, IOException {
        if (entryName == null) {
            throw new CryptoException("ERR.003.030.0086", CommonPlugin.Util.getString("ERR.003.030.0086"));
        }
        try {
            this.loadKeyStore(storeFile, storePass);
        }
        catch (KeyStoreException e) {
            throw new CryptoException(e.getMessage());
        }
        this.entryName = entryName;
        this.storePass = storePass;
    }

    public Key getEncryptKey() throws CryptoException {
        try {
            return this.getPublicKey(this.entryName);
        }
        catch (KeyStoreException e) {
            throw new CryptoException(e.getMessage());
        }
    }

    public Key getDecryptKey() throws CryptoException {
        try {
            return this.getPrivateKey(this.entryName);
        }
        catch (KeyStoreException e) {
            throw new CryptoException(e.getMessage());
        }
    }

    public void printStoreInfo(String header) {
        System.out.println(header);
        System.out.println(CommonPlugin.Util.getString("MSG.003.030.0033", this.keyStore.getType()));
        System.out.println(CommonPlugin.Util.getString("MSG.003.030.0034", KeyStore.getDefaultType()));
        System.out.println(CommonPlugin.Util.getString("MSG.003.030.0035", this.keyStore.getProvider()));
    }

    private Key getPrivateKey(String entryName) throws KeyStoreException {
        char[] entryPass = this.storePass;
        PrivateKey key = null;
        try {
            key = (PrivateKey)this.keyStore.getKey(entryName, entryPass);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyStoreException(CommonPlugin.Util.getString("ERR.003.030.0087", entryName, e.getMessage()));
        }
        catch (UnrecoverableKeyException e) {
            throw new KeyStoreException(CommonPlugin.Util.getString("ERR.003.030.0088", entryName, e.getMessage()));
        }
        if (key == null) {
            throw new KeyStoreException(CommonPlugin.Util.getString("ERR.003.030.0089", entryName));
        }
        return key;
    }

    private Key getPublicKey(String entryName) throws KeyStoreException {
        Certificate cert = this.keyStore.getCertificate(entryName);
        if (cert == null) {
            throw new KeyStoreException(CommonPlugin.Util.getString("ERR.003.030.0089", entryName));
        }
        return cert.getPublicKey();
    }

    private void loadKeyStore(String keyStoreFile, char[] keyStorePass, boolean fromCP) throws KeyStoreException, FileNotFoundException, IOException {
        this.keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
        InputStream stream = null;
        if (fromCP) {
            stream = AsymKeyStoreManager.getResourceStream(this.getClass(), keyStoreFile);
            if (stream == null) {
                throw new FileNotFoundException(CommonPlugin.Util.getString("ERR.003.030.0090", keyStoreFile));
            }
        } else {
            stream = new FileInputStream(keyStoreFile);
        }
        try {
            this.keyStore.load(stream, keyStorePass);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyStoreException(CommonPlugin.Util.getString("ERR.003.030.0087", this.entryName, e.getMessage()));
        }
        catch (CertificateException e) {
            throw new KeyStoreException(CommonPlugin.Util.getString("ERR.003.030.0091", e.getMessage()));
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private void loadKeyStore(URL keyStoreFile, char[] keyStorePass) throws KeyStoreException, FileNotFoundException, IOException {
        this.keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
        InputStream stream = keyStoreFile.openStream();
        try {
            this.keyStore.load(stream, keyStorePass);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyStoreException(CommonPlugin.Util.getString("ERR.003.030.0087", this.entryName, e.getMessage()));
        }
        catch (CertificateException e) {
            throw new KeyStoreException(CommonPlugin.Util.getString("ERR.003.030.0091", e.getMessage()));
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private static InputStream getResourceStream(Class appClass, String filename) {
        InputStream inputStream = null;
        try {
            inputStream = appClass.getClassLoader().getResourceAsStream(filename);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return inputStream;
    }

    public static void main(String[] args) throws Exception {
        String storeFile = args.length > 0 ? args[0] : null;
        char[] storePass = args.length > 1 ? args[1].toCharArray() : null;
        String entryName = args.length > 2 ? args[2] : "encrypt";
        AsymKeyStoreManager km = new AsymKeyStoreManager(storeFile, storePass, entryName);
        km.printStoreInfo("Keystore information");
        Key encryptKey = km.getEncryptKey();
        AsymKeyStoreManager.printKeyInfo("Encrypt key", encryptKey);
        Key decryptKey = km.getDecryptKey();
        AsymKeyStoreManager.printKeyInfo("Decrypt key", decryptKey);
    }

    static void printKeyInfo(String header, Key key) {
        System.out.println(header);
        System.out.println(CommonPlugin.Util.getString("MSG.003.030.0025", key.getAlgorithm()));
        System.out.println(CommonPlugin.Util.getString("MSG.003.030.0026", key.getFormat()));
        System.out.println(CommonPlugin.Util.getString("MSG.003.030.0027", ByteArrayHelper.toString(key.getEncoded())));
    }
}

