/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.merant.datadirect.jdbc.extensions.ExtEmbeddedConnection;
import com.metamatrix.jdbc.base.BaseCallableStatement;
import com.metamatrix.jdbc.base.BaseCallbleStatement;
import com.metamatrix.jdbc.base.BaseClassUtility;
import com.metamatrix.jdbc.base.BaseColumns;
import com.metamatrix.jdbc.base.BaseConnectionProperties;
import com.metamatrix.jdbc.base.BaseConnectionStartup;
import com.metamatrix.jdbc.base.BaseDatabaseMetaData;
import com.metamatrix.jdbc.base.BaseDriverPropertyInfos;
import com.metamatrix.jdbc.base.BaseEscapeTranslator;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseImplConnection;
import com.metamatrix.jdbc.base.BaseImplDatabaseMetaData;
import com.metamatrix.jdbc.base.BaseLicFileWrapper;
import com.metamatrix.jdbc.base.BaseLicenseUtility;
import com.metamatrix.jdbc.base.BasePreparedStatement;
import com.metamatrix.jdbc.base.BaseResultSetMetaData;
import com.metamatrix.jdbc.base.BaseSQL;
import com.metamatrix.jdbc.base.BaseSQLScanner;
import com.metamatrix.jdbc.base.BaseSQLToken;
import com.metamatrix.jdbc.base.BaseSavepoints;
import com.metamatrix.jdbc.base.BaseStatement;
import com.metamatrix.jdbc.base.BaseStatementPool;
import com.metamatrix.jdbc.base.BaseURLParser;
import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.extensions.ExtConnection;
import com.metamatrix.jdbc.extensions.ExtStatementPoolMonitor;
import com.metamatrix.jdbc.jdbc40.JDBC40Helper;
import com.metamatrix.util.UtilDebug;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilJDKVersionChecker;
import java.lang.management.ManagementFactory;
import java.net.Socket;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;

public abstract class BaseConnection
implements Connection,
ExtConnection,
com.ddtek.jdbc.extensions.ExtEmbeddedConnection,
ExtEmbeddedConnection {
    private static String footprint = "$Revision:   3.95.1.4  $";
    protected String driverName;
    protected BaseConnectionProperties connectProps;
    BaseDriverPropertyInfos propInfos = null;
    UtilDebug debug;
    BaseImplConnection implConnection;
    private boolean pingServerDuringIsClosed = false;
    private BaseDatabaseMetaData databaseMetaData;
    private boolean actualAutoCommitMode;
    public boolean exposedAutoCommitMode = true;
    boolean manualTxnWorkStarted = false;
    private boolean readOnlyMode;
    private String currentCatalog;
    private String originalCatalog;
    private int currentTransactionIsolation = -1;
    private int originalTransactionIsolation = -1;
    protected BaseWarnings warnings;
    protected BaseExceptions exceptions;
    protected boolean lockedEmbedding;
    protected boolean isEval;
    protected boolean isEmbedded;
    protected boolean requireCPUCheck;
    BaseStatementPool statementPool;
    ExtStatementPoolMonitor statementPoolMonitor = null;
    static long mbeanId = 0L;
    private int supportsSavepoints = -1;
    private BaseSavepoints savepoints;
    protected boolean isXAConnection;
    private int supportsTransactions = -1;
    BaseEscapeTranslator escapeTranslator;
    private boolean autoGeneratedKeysRequested = false;
    protected String[] requestedKeyColumns = null;
    protected BaseColumns requestedKeyColumnDescriptions = null;
    boolean isJavaDoubleToString;
    private int longDataCacheSize;
    public static final short LD_CACHE_DISABLED = -1;
    public static final int LD_CACHE_MAX = 2048;
    int dateTimeBehavior = 0;
    String loadLibraryPath = null;
    public int workarounds = 0;
    public static final int WA_HIBERNATE_GENERATED_KEYS = 1;
    public static final int WA_SQLSERVER_SETSAVEPOINT = 2;
    protected int prepareExecuteMode = 0;
    private String clientAppName = "";
    private String clientHostName = "";
    private String clientUser = "";
    private String clientAcctInfo = "";
    Calendar cal = Calendar.getInstance();
    char[] buff = new char[10];
    public String origUser = null;
    public String currentUser = null;
    boolean loginTimedOut = false;
    Object loginTimedOutSync;
    public int convertNull = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BaseDriverPropertyInfos getPropertyInfo() {
        if (this.propInfos == null) {
            this.propInfos = new BaseDriverPropertyInfos();
            BaseConnection baseConnection = this;
            synchronized (baseConnection) {
                this.getImplPropertyInfo(this.propInfos);
            }
            this.propInfos.put("alternateServers", "List of server connection information used to attempt an alternate connections.", "", null, false);
            if (BaseClassUtility.exposeCtsIncompatibleOptions()) {
                this.propInfos.put("batchPerformanceWorkaround", "Batch Performance Workaround", "false", null, false);
            }
            this.propInfos.put("maxPooledStatements", "Maximum number of PreparedStatement objects to pool.", "0", null, false);
            this.propInfos.put("importStatementPool", "File from which to load the contents of the statement pool.", "", null, false);
            this.propInfos.put("insensitiveResultSetBufferSize", "Maximum memory in KB to use for client-side insensitive scrolling.", "2048", null, false);
            this.propInfos.put("connectionRetryCount", "Max number of times to attempt to retry a connection.", "5", null, false);
            this.propInfos.put("connectionRetryDelay", "Time to delay before retrying connection.", "1", null, false);
            this.propInfos.put("loadBalancing", "Specifies whether to perform load balancing.", "false", null, false);
            this.propInfos.put("resultsetMetaDataOptions", "Integer bit mask for configuring the information returned in ResultSetMetaData resultsets.", "0", null, false);
            this.propInfos.put("javaDoubleToString", "Specifies whether the Java Double to String conversion algorithm should be used.", "false", null, false);
            this.propInfos.put("initializationString", "SQL executed after a connection is established.", "", null, false);
            this.propInfos.put("loadLibraryPath", "Fully qualified path to the type 2 security dll.", "", null, false);
            this.propInfos.put("workarounds", "Specify workarounds for third party applications.", "0", null, false);
            this.propInfos.put("convertNull", "Convert Null.", "1", null, false);
            this.propInfos.put("queryTimeout", "Sets the default queryTimeout for all Statements on this Connection", "0", null, false);
        }
        return this.propInfos;
    }

    public int getLongDataCacheSize() {
        return this.longDataCacheSize;
    }

    int determineLongDataCacheSize(int n, int n2) {
        if (n < -1) {
            return n2;
        }
        if (n == -1) {
            return -1;
        }
        if (n == 0) {
            return n2;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void open(BaseConnectionProperties baseConnectionProperties, BaseExceptions baseExceptions, UtilDebug utilDebug) throws SQLException {
        BaseConnection baseConnection = this;
        synchronized (baseConnection) {
            Object object;
            String string;
            this.driverName = BaseClassUtility.getRootName(this);
            this.connectProps = baseConnectionProperties;
            this.exceptions = baseExceptions;
            this.exceptions.setConnection(this);
            this.debug = utilDebug;
            this.warnings = new BaseWarnings(baseExceptions.getMessages());
            this.readOnlyMode = false;
            this.actualAutoCommitMode = true;
            if (baseConnectionProperties.get("validateIsClosed") != null) {
                this.pingServerDuringIsClosed = baseConnectionProperties.get("validateIsClosed").equalsIgnoreCase("true");
            }
            int n = 0;
            if (baseConnectionProperties.get("loginTimeout") != null) {
                n = Integer.valueOf(baseConnectionProperties.get("loginTimeout"));
            }
            this.loadLibraryPath = baseConnectionProperties.get("loadLibraryPath");
            if (baseConnectionProperties.get("workarounds") != null) {
                this.workarounds = Integer.valueOf(baseConnectionProperties.get("workarounds"));
            }
            this.implConnection = this.setupImplConnection(n);
            int n2 = 0;
            String string2 = baseConnectionProperties.get("maxPooledStatements");
            if (string2 != null) {
                n2 = Integer.parseInt(string2);
            }
            int n3 = 0;
            String string3 = baseConnectionProperties.get("maxStatements");
            if (string3 != null) {
                n3 = Integer.parseInt(string3);
            }
            int n4 = 0;
            if (n2 != 0 && n3 != 0) {
                throw baseExceptions.getException(6133);
            }
            n4 = Math.max(n2, n3);
            if (n4 > 0) {
                this.statementPool = new BaseStatementPool(n4);
                string = baseConnectionProperties.get("portNumber");
                String string4 = "jdbc_mmx_" + this.driverName.toLowerCase() + "_" + baseConnectionProperties.get("serverName");
                if (string != null) {
                    string4 = string4 + "_" + string;
                }
                string4 = string4 + "_" + mbeanId++;
                this.statementPoolMonitor = new ExtStatementPoolMonitor(this.statementPool, string4, this);
                if (UtilJDKVersionChecker.getJVMVersion() >= 1.5f) {
                    try {
                        object = ManagementFactory.getPlatformMBeanServer();
                        ObjectName objectName = new ObjectName("com.metamatrix.jdbc:type=StatementPoolMonitor,name=" + string4);
                        object.registerMBean(this.statementPoolMonitor, objectName);
                    }
                    catch (Exception exception) {
                        String[] stringArray = new String[]{exception.getMessage()};
                        this.warnings.add(6132, stringArray);
                    }
                }
                if ((object = baseConnectionProperties.get("importStatementPool")) != null && ((String)object).length() > 0) {
                    this.statementPoolMonitor.importStatements((String)object);
                }
            }
            this.isJavaDoubleToString = new Boolean(baseConnectionProperties.get("javaDoubleToString"));
            string = baseConnectionProperties.get("dateTimeBehavior");
            if (string != null) {
                if (string.equalsIgnoreCase("0")) {
                    this.dateTimeBehavior = 0;
                } else if (string.equalsIgnoreCase("1")) {
                    this.dateTimeBehavior = 1;
                } else if (string.equalsIgnoreCase("2")) {
                    this.dateTimeBehavior = 2;
                }
            }
            this.convertNull = Integer.parseInt(baseConnectionProperties.get("convertNull"));
            this.lockedEmbedding = false;
            this.isEval = false;
            this.isEmbedded = false;
            this.requireCPUCheck = true;
            this.executeInitializationString();
            this.lockedEmbedding = BaseLicenseUtility.isLocked(this);
            int n5 = Integer.parseInt(baseConnectionProperties.get("queryTimeout"));
            if (n5 > 0 && !this.implConnection.supportsCancel() && !this.implConnection.supportsQueryTimeout()) {
                throw baseExceptions.getException(6121);
            }
            if (n5 < 0 && n5 != -1) {
                throw baseExceptions.getException(6122);
            }
            if (!this.lockedEmbedding && !this.isEval && !this.isEmbedded && this.requireCPUCheck) {
                object = new BaseLicFileWrapper(this);
                ((BaseLicFileWrapper)object).checkCPUCount();
            }
        }
    }

    public void executeInitializationString() throws SQLException {
        try {
            boolean bl = false;
            String string = this.connectProps.get("initializationString");
            if (string != null && string.length() > 0) {
                Statement statement = this.createStatement();
                BaseSQLScanner baseSQLScanner = new BaseSQLScanner();
                String string2 = "";
                if (string.charAt(0) == '(') {
                    int n = string.length() - 1;
                    baseSQLScanner.setup(string.substring(1, n), '\'', '\"');
                } else {
                    baseSQLScanner.setup(string, '\'', '\"');
                }
                BaseSQLToken baseSQLToken = baseSQLScanner.getNextToken();
                while (baseSQLToken.type != 6) {
                    if (baseSQLToken.type == 15) {
                        statement.addBatch(string2);
                        bl = true;
                        string2 = "";
                    } else {
                        string2 = string2 + baseSQLToken.value;
                    }
                    baseSQLToken = baseSQLScanner.getNextToken();
                }
                if ((string2 = string2.trim()).length() > 0) {
                    statement.addBatch(string2);
                    bl = true;
                    string2 = "";
                }
                if (bl) {
                    statement.executeBatch();
                }
            }
        }
        catch (SQLException sQLException) {
            throw this.exceptions.getException(sQLException, 0, 6110);
        }
    }

    public final synchronized void reset() throws SQLException {
        if (this.implConnection != null) {
            this.commonCloseReset();
            this.commonReset(true);
        }
    }

    public final synchronized void resetXA(boolean bl) throws SQLException {
        if (this.implConnection != null) {
            this.commonCloseResetXA(bl);
            this.commonReset(true);
        }
    }

    private BaseImplConnection setupImplConnection(int n) throws SQLException {
        this.implConnection = this.createImplConnection(this.connectProps);
        this.implConnection.setup(this.connectProps, this.warnings, this.exceptions, this.debug);
        if ((this.connectProps.get("user") == null || this.connectProps.get("user").length() == 0) && this.implConnection.requiresUserId()) {
            throw this.exceptions.getException(6094);
        }
        this.implConnection.setReadOnly(this.readOnlyMode);
        if (n > 0) {
            this.loginTimedOutSync = new Object();
            final BaseConnection baseConnection = this;
            final int n2 = n;
            final BaseExceptions baseExceptions = this.exceptions;
            try {
                BaseConnectionStartup baseConnectionStartup = (BaseConnectionStartup)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws SQLException {
                        return new BaseConnectionStartup(baseConnection, n2, baseExceptions);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (SQLException)privilegedActionException.getException();
            }
        } else {
            this.connect();
        }
        return this.implConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTimedOut() {
        Object object = this.loginTimedOutSync;
        synchronized (object) {
            this.loginTimedOut = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean loginTimedOut() {
        if (this.loginTimedOutSync == null) {
            return false;
        }
        Object object = this.loginTimedOutSync;
        synchronized (object) {
            return this.loginTimedOut;
        }
    }

    void connect() throws SQLException {
        Object object;
        if (this.isXAConnection) {
            this.implConnection.prepareForXA();
        }
        String string = this.connectProps.get("alternateServers");
        int n = 1 + Integer.parseInt(this.connectProps.get("connectionRetryCount"));
        int n2 = Integer.parseInt(this.connectProps.get("connectionRetryDelay"));
        boolean bl = false;
        if (string != null && string.length() > 0 && (object = this.connectProps.get("loadBalancing")) != null && ((String)object).equalsIgnoreCase("true")) {
            bl = true;
        }
        object = null;
        SQLException sQLException = null;
        SQLException sQLException2 = null;
        String string2 = null;
        String string3 = this.connectProps.get("longDataCacheSize");
        int n3 = 0;
        try {
            n3 = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.longDataCacheSize = this.determineLongDataCacheSize(n3, 2048);
        for (int i = 0; i < n; ++i) {
            object = this.getConnectPropList((ArrayList)object, this.connectProps, string, bl);
            int n4 = ((ArrayList)object).size();
            boolean bl2 = false;
            for (int j = 0; j < n4; ++j) {
                BaseConnectionProperties baseConnectionProperties = (BaseConnectionProperties)((ArrayList)object).get(j);
                if (baseConnectionProperties == null) continue;
                try {
                    if (this.loginTimedOut()) {
                        return;
                    }
                    this.implConnection.connectProps = baseConnectionProperties;
                    this.implConnection.setConnectionStatus(2);
                    this.implConnection.open();
                    while (sQLException != null) {
                        this.warnings.addExceptionAsWarning(sQLException);
                        sQLException = sQLException.getNextException();
                    }
                    return;
                }
                catch (SQLException sQLException3) {
                    String[] stringArray = new String[]{this.connectProps.get("serverName")};
                    string2 = new UtilException(1021, stringArray).getMessage();
                    if (sQLException3.getSQLState().startsWith("08")) {
                        if (sQLException3.getMessage().indexOf(string2) != -1) {
                            bl2 = true;
                            ((ArrayList)object).set(j, null);
                        }
                        if (sQLException == null) {
                            sQLException = sQLException3;
                        }
                        if (sQLException2 != null) {
                            sQLException2.setNextException(sQLException3);
                        }
                        sQLException2 = sQLException3;
                        continue;
                    }
                    throw sQLException3;
                }
            }
            if (bl2 && n4 == 1) {
                throw sQLException;
            }
            if (n2 <= 0) continue;
            try {
                Thread.sleep(n2 * 1000);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        throw sQLException;
    }

    private ArrayList getConnectPropList(ArrayList arrayList, BaseConnectionProperties baseConnectionProperties, String string, boolean bl) throws SQLException {
        ArrayList<Object> arrayList2;
        Object object;
        ArrayList<BaseConnectionProperties> arrayList3 = arrayList;
        if (arrayList == null) {
            arrayList3 = new ArrayList<BaseConnectionProperties>();
            arrayList3.add(baseConnectionProperties);
            if (string != null && string.length() > 0) {
                BaseConnectionProperties baseConnectionProperties2 = new BaseConnectionProperties();
                object = new StringTokenizer(string, "(),");
                arrayList2 = new ArrayList();
                while (((StringTokenizer)object).hasMoreElements()) {
                    arrayList2.add(((StringTokenizer)object).nextElement());
                }
                String string2 = BaseClassUtility.getRootName(this);
                BaseURLParser baseURLParser = BaseClassUtility.getURLParser(string2);
                int n = arrayList2.size();
                for (int i = 0; i < n; ++i) {
                    BaseConnectionProperties baseConnectionProperties3 = baseConnectionProperties.copy();
                    StringBuffer stringBuffer = new StringBuffer("jdbc:mmx:");
                    stringBuffer.append(string2);
                    stringBuffer.append("://");
                    stringBuffer.append((String)arrayList2.get(i));
                    if (!baseURLParser.parse(string2, stringBuffer.toString(), baseConnectionProperties2)) {
                        throw this.exceptions.getException(6098);
                    }
                    this.implConnection.mergeAlternateConnectProps(baseConnectionProperties2, baseConnectionProperties3);
                    arrayList3.add(baseConnectionProperties3);
                }
            }
        }
        int n = arrayList3.size();
        if (bl && n > 1) {
            int n2;
            object = new Random();
            arrayList2 = new ArrayList<Object>(n);
            for (n2 = 0; n2 < n; ++n2) {
                arrayList2.add(null);
            }
            for (n2 = 0; n2 < n; ++n2) {
                int n3 = ((Random)object).nextInt(n);
                while (true) {
                    if (arrayList2.get(n3) == null) break;
                    n3 = (n3 + 1) % n;
                }
                arrayList2.set(n3, arrayList3.get(n2));
            }
            arrayList3 = arrayList2;
        }
        return arrayList3;
    }

    public final synchronized void clearWarnings() throws SQLException {
        this.warnings.clear();
    }

    public final synchronized void close() throws SQLException {
        if (this.implConnection != null) {
            this.commonCloseReset();
            this.commonClose();
        }
    }

    public final void abortConnection() throws SQLException {
        if (this.implConnection != null) {
            Socket socket = this.implConnection.getQueryTimeoutSocket();
            if (socket == null) {
                throw this.exceptions.getException(6111);
            }
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.implConnection = null;
        }
    }

    public final synchronized void closeXA(boolean bl) throws SQLException {
        if (this.implConnection != null && !this.lockedEmbedding) {
            this.commonCloseResetXA(bl);
            this.commonClose();
        }
    }

    final void commonClose() throws SQLException {
        if (this.statementPool != null) {
            this.statementPool.empty();
            this.statementPool = null;
        }
        this.implConnection.close();
        this.implConnection = null;
    }

    final void commonReset(boolean bl) throws SQLException {
        this.clientAppName = "";
        this.clientHostName = "";
        this.clientUser = "";
        this.clientAcctInfo = "";
        if (this.originalCatalog != null && this.currentCatalog != null && !this.originalCatalog.equals(this.currentCatalog)) {
            this.setCatalog(this.originalCatalog);
        }
        if (this.originalTransactionIsolation != -1 && this.originalTransactionIsolation != this.currentTransactionIsolation) {
            this.setTransactionIsolation(this.originalTransactionIsolation);
        }
        if (bl) {
            this.setAutoCommit(true);
        }
        this.setReadOnly(false);
        this.implConnection.reset();
        this.prepareExecuteMode = 0;
    }

    final void commonCloseReset() throws SQLException {
        this.clearWarnings();
        if (!this.actualAutoCommitMode) {
            try {
                this.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    final void commonCloseResetXA(boolean bl) throws SQLException {
        this.clearWarnings();
        if (!bl && !this.actualAutoCommitMode) {
            try {
                this.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    final void validateSavepoint(String string, Savepoint savepoint, boolean bl) throws SQLException {
        if (this.supportsSavepoints == -1) {
            int n = this.supportsSavepoints = this.getMetaData().supportsSavepoints() ? 1 : 0;
        }
        if (this.supportsSavepoints == 0) {
            String[] stringArray = new String[]{string};
            throw this.exceptions.getException(6003, stringArray);
        }
        if (this.savepoints == null) {
            this.savepoints = new BaseSavepoints(this.exceptions, this);
        }
        if (savepoint != null && !this.savepoints.isValid(savepoint, bl)) {
            throw this.exceptions.getException(6082);
        }
    }

    public final synchronized void commit() throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        if (!this.exposedAutoCommitMode && !this.actualAutoCommitMode) {
            if (this.savepoints != null) {
                this.savepoints.remove();
            }
            this.implConnection.commitTransaction();
            this.manualTxnWorkStarted = false;
        }
    }

    public final Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    public final synchronized Statement createStatement(int n, int n2) throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        if (this.lockedEmbedding) {
            throw this.exceptions.getException(6050);
        }
        this.validateTypeAndConcurrency("createStatement", n, n2);
        BaseStatement baseStatement = new BaseStatement(this, n, n2);
        this.postDownGradeWarnings(baseStatement, n, n2);
        return baseStatement;
    }

    final void validateTypeAndConcurrency(String string, int n, int n2) throws SQLException {
        boolean bl = false;
        switch (n) {
            case 1003: 
            case 1004: 
            case 1005: {
                break;
            }
            default: {
                bl = true;
            }
        }
        switch (n2) {
            case 1007: 
            case 1008: {
                break;
            }
            default: {
                bl = true;
            }
        }
        if (bl) {
            String[] stringArray = new String[]{string};
            throw this.exceptions.getException(6002, stringArray);
        }
    }

    private void postDownGradeWarnings(Statement statement, int n, int n2) throws SQLException {
        if (n != statement.getResultSetType()) {
            this.warnings.add(6046, "01000");
        }
        if (n2 != statement.getResultSetConcurrency()) {
            this.warnings.add(6047, "01000");
        }
    }

    public final synchronized boolean getAutoCommit() throws SQLException {
        return this.exposedAutoCommitMode;
    }

    public final synchronized boolean getActualAutoCommit() {
        return this.actualAutoCommitMode;
    }

    public final synchronized boolean getManualTxnWorkStarted() {
        return this.manualTxnWorkStarted;
    }

    public final synchronized String getCatalog() throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        if (this.currentCatalog == null) {
            this.currentCatalog = this.implConnection.getCatalog();
            if (this.originalCatalog == null) {
                this.originalCatalog = this.currentCatalog;
            }
        }
        return this.currentCatalog;
    }

    public boolean getIsJavaDoubleToString() {
        return this.isJavaDoubleToString;
    }

    public int getDateTimeBehavior() {
        return this.dateTimeBehavior;
    }

    public String getLoadLibraryPath() {
        return this.loadLibraryPath;
    }

    public final synchronized DatabaseMetaData getMetaData() throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        if (this.databaseMetaData == null) {
            BaseImplDatabaseMetaData baseImplDatabaseMetaData = this.createImplDatabaseMetaData(this.connectProps);
            baseImplDatabaseMetaData.setup(this);
            this.databaseMetaData = new BaseDatabaseMetaData(this, baseImplDatabaseMetaData);
        }
        return this.databaseMetaData;
    }

    public final synchronized int getTransactionIsolation() throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        if (this.currentTransactionIsolation == -1) {
            this.currentTransactionIsolation = this.implConnection.getTransactionIsolation();
            if (this.originalTransactionIsolation == -1) {
                this.originalTransactionIsolation = this.currentTransactionIsolation;
            }
        }
        return this.currentTransactionIsolation;
    }

    public final Map getTypeMap() throws SQLException {
        return new HashMap();
    }

    public final synchronized SQLWarning getWarnings() {
        return this.warnings.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isClosed() {
        boolean bl;
        boolean bl2 = bl = this.implConnection == null;
        if (!bl) {
            BaseConnection baseConnection = this;
            synchronized (baseConnection) {
                switch (this.implConnection.getConnectionStatus()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        bl = true;
                        break;
                    }
                    case 2: {
                        if (!this.pingServerDuringIsClosed) break;
                        Statement statement = null;
                        try {
                            statement = this.createStatement();
                            statement.execute("Test Server Connectivity");
                            break;
                        }
                        catch (SQLException sQLException) {
                            if (sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8') {
                                bl = true;
                                String[] stringArray = new String[]{sQLException.getMessage()};
                                this.warnings.add(6001, stringArray, sQLException.getSQLState());
                            }
                            if (statement == null) break;
                            try {
                                statement.close();
                                break;
                            }
                            catch (SQLException sQLException2) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }
        return bl;
    }

    public final synchronized boolean isReadOnly() throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        return this.readOnlyMode;
    }

    public final String nativeSQL(String string) throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        BaseEscapeTranslator baseEscapeTranslator = this.getEscapeTranslator();
        baseEscapeTranslator.setWarnings(this.warnings);
        BaseSQL baseSQL = new BaseSQL(string, 3, this.implConnection.quotingChar, this.implConnection.intoIsOptional, baseEscapeTranslator, this.exceptions);
        return baseSQL.getFormatted();
    }

    public final CallableStatement prepareCall(String string) throws SQLException {
        if (string != null && string.charAt(0) == '-' && string.charAt(2) == '!' && string.equals("--!ddtc!\n{call ddtc(?)}")) {
            return new BaseCallbleStatement(this);
        }
        return this.prepareCall(string, 1003, 1007);
    }

    public final synchronized CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        if (this.lockedEmbedding) {
            throw this.exceptions.getException(6050);
        }
        this.validateTypeAndConcurrency("prepareCall", n, n2);
        CallableStatement callableStatement = null;
        if (this.statementPool != null) {
            callableStatement = this.statementPool.getCallableStatement(string, n, n2);
        }
        if (callableStatement == null) {
            BaseCallableStatement baseCallableStatement = new BaseCallableStatement(this, string, n, n2);
            callableStatement = this.statementPool != null ? this.statementPool.makeCallableStatementPoolable(baseCallableStatement) : baseCallableStatement;
        }
        this.postDownGradeWarnings(callableStatement, n, n2);
        return callableStatement;
    }

    public final PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007);
    }

    public final synchronized PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.finalizeTxnMode(false);
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        if (this.lockedEmbedding) {
            throw this.exceptions.getException(6050);
        }
        this.validateTypeAndConcurrency("prepareStatement", n, n2);
        PreparedStatement preparedStatement = null;
        if (this.statementPool != null) {
            preparedStatement = this.statementPool.getPreparedStatement(string, n, n2, this.autoGeneratedKeysRequested, this.requestedKeyColumns);
        }
        if (preparedStatement == null) {
            BasePreparedStatement basePreparedStatement = new BasePreparedStatement(this, string, n, n2, this.autoGeneratedKeysRequested, this.requestedKeyColumnDescriptions, this.requestedKeyColumns);
            preparedStatement = this.statementPool != null ? this.statementPool.makePreparedStatementPoolable(basePreparedStatement) : basePreparedStatement;
        }
        this.postDownGradeWarnings(preparedStatement, n, n2);
        return preparedStatement;
    }

    public final synchronized void rollback() throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        if (!this.exposedAutoCommitMode && !this.actualAutoCommitMode) {
            if (this.savepoints != null) {
                this.savepoints.remove();
            }
            this.implConnection.rollbackTransaction();
            this.manualTxnWorkStarted = false;
        }
    }

    public final synchronized void setAutoCommit(boolean bl) throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        this.ValidateSupportsTransactions(bl);
        if (this.manualTxnWorkStarted && bl) {
            this.setAutoCommitInternal(true);
            this.manualTxnWorkStarted = false;
        }
        this.exposedAutoCommitMode = bl;
    }

    public final synchronized void setActualAutoCommit(boolean bl) throws SQLException {
        this.setAutoCommitInternal(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setAutoCommitInternal(boolean bl) throws SQLException {
        boolean bl2 = this.actualAutoCommitMode;
        boolean bl3 = false;
        if (bl) {
            if (this.actualAutoCommitMode) return;
            try {
                this.actualAutoCommitMode = true;
                this.implConnection.stopManualTransactionMode();
                bl3 = true;
                if (this.savepoints == null) return;
                this.savepoints.remove();
                return;
            }
            finally {
                if (!bl3) {
                    this.actualAutoCommitMode = bl2;
                }
            }
        }
        if (!this.actualAutoCommitMode) return;
        try {
            this.actualAutoCommitMode = false;
            this.implConnection.startManualTransactionMode();
            bl3 = true;
            return;
        }
        finally {
            if (!bl3) {
                this.actualAutoCommitMode = bl2;
            }
        }
    }

    synchronized boolean finalizeTxnMode(boolean bl) throws SQLException {
        if (this.exposedAutoCommitMode != this.actualAutoCommitMode) {
            try {
                this.setAutoCommitInternal(this.exposedAutoCommitMode);
            }
            catch (SQLException sQLException) {
                throw this.exceptions.getException(sQLException, 6096);
            }
        }
        boolean bl2 = this.manualTxnWorkStarted;
        if (!this.exposedAutoCommitMode && bl) {
            this.manualTxnWorkStarted = true;
        }
        return bl2;
    }

    public final synchronized void setCatalog(String string) throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        if (this.currentCatalog != null && this.currentCatalog.equals(string)) {
            return;
        }
        if (this.originalCatalog == null) {
            this.originalCatalog = this.getCatalog();
        }
        this.implConnection.setCatalog(string);
        this.currentCatalog = new String(string);
    }

    public void setCurrentCatalog(String string) {
        this.currentCatalog = string;
        if (this.originalCatalog == null) {
            this.originalCatalog = string;
        }
    }

    public final synchronized void setReadOnly(boolean bl) throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        this.readOnlyMode = bl;
        this.implConnection.setReadOnly(bl);
    }

    public final synchronized void setTransactionIsolation(int n) throws SQLException {
        if (n == 2112) {
            this.lockedEmbedding = false;
            return;
        }
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        this.finalizeTxnMode(false);
        if (this.originalTransactionIsolation == -1) {
            this.originalTransactionIsolation = this.implConnection.getTransactionIsolation();
        }
        this.implConnection.setTransactionIsolation(n);
        this.currentTransactionIsolation = n;
    }

    public final void setTypeMap(Map map) throws SQLException {
    }

    public void modifyUserSpecifiedConnectProperties(BaseConnectionProperties baseConnectionProperties) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean unlock(String string) throws SQLException {
        BaseConnection baseConnection = this;
        synchronized (baseConnection) {
            if (this.lockedEmbedding) {
                this.lockedEmbedding = !BaseLicenseUtility.unlock(string);
            }
            return !this.lockedEmbedding;
        }
    }

    protected abstract void getImplPropertyInfo(BaseDriverPropertyInfos var1);

    protected abstract BaseImplConnection createImplConnection(BaseConnectionProperties var1) throws SQLException;

    public abstract BaseImplDatabaseMetaData createImplDatabaseMetaData(BaseConnectionProperties var1) throws SQLException;

    public BaseEscapeTranslator createEscapeTranslator() throws SQLException {
        return null;
    }

    public final BaseEscapeTranslator getEscapeTranslator() throws SQLException {
        if (this.escapeTranslator == null) {
            this.escapeTranslator = this.createEscapeTranslator();
        }
        return this.escapeTranslator;
    }

    public boolean getBatchIsJDBCCompliant() {
        return true;
    }

    public static Properties makeSpyProperties(String string) {
        Properties properties = new Properties();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(61);
            if (n == -1) continue;
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            properties.put(string3, string4);
        }
        return properties;
    }

    public final BaseConnectionProperties getConnectProperties() {
        return this.connectProps;
    }

    public void setHoldability(int n) throws SQLException {
        int n2 = this.getHoldability();
        if (n2 != n) {
            throw this.exceptions.getException(6109);
        }
    }

    public int getHoldability() throws SQLException {
        int n = this.implConnection.getHoldability();
        if (n == -1) {
            n = this.getMetaData().getResultSetHoldability();
        }
        return n;
    }

    public BaseExceptions getExceptions() {
        return this.exceptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Savepoint setSavepoint() throws SQLException {
        BaseConnection baseConnection = this;
        synchronized (baseConnection) {
            this.validateSavepoint("Connection.setSavepoint", null, false);
            this.finalizeTxnMode(false);
            Savepoint savepoint = null;
            if (!this.actualAutoCommitMode) {
                savepoint = this.savepoints.createSavepoint(null);
                try {
                    this.implConnection.setSavepoint(this.savepoints.getName(savepoint));
                }
                catch (SQLException sQLException) {
                    this.savepoints.remove(savepoint, false);
                    throw sQLException;
                }
            } else {
                throw this.exceptions.getException(6027, "25S01");
            }
            return savepoint;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Savepoint setSavepoint(String string) throws SQLException {
        BaseConnection baseConnection = this;
        synchronized (baseConnection) {
            this.validateSavepoint("Connection.setSavepoint", null, false);
            this.finalizeTxnMode(false);
            Savepoint savepoint = null;
            if (!this.actualAutoCommitMode) {
                savepoint = this.savepoints.get(string);
                if (savepoint != null) {
                    this.implConnection.implicitReleaseSavepoint(string);
                    savepoint = null;
                }
                savepoint = this.savepoints.createSavepoint(string);
                try {
                    this.implConnection.setSavepoint(string);
                }
                catch (SQLException sQLException) {
                    this.savepoints.remove(savepoint, false);
                    throw sQLException;
                }
            } else {
                throw this.exceptions.getException(6027, "25S01");
            }
            return savepoint;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rollback(Savepoint savepoint) throws SQLException {
        BaseConnection baseConnection = this;
        synchronized (baseConnection) {
            this.validateSavepoint("Connection.rollback(Savepoint)", savepoint, true);
            if (!this.exposedAutoCommitMode) {
                if (!this.actualAutoCommitMode) {
                    String string = this.savepoints.getName(savepoint);
                    this.savepoints.remove(savepoint, true);
                    this.implConnection.rollbackTransaction(string);
                }
            } else {
                throw this.exceptions.getException(6027, "25S01");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseSavepoint(Savepoint savepoint) throws SQLException {
        BaseConnection baseConnection = this;
        synchronized (baseConnection) {
            this.validateSavepoint("releaseSavepoint.rollback", savepoint, true);
            if (!this.exposedAutoCommitMode) {
                if (!this.actualAutoCommitMode) {
                    String string = this.savepoints.getName(savepoint);
                    this.savepoints.remove(savepoint, true);
                    this.implConnection.releaseSavepoint(string);
                }
            } else {
                throw this.exceptions.getException(6027, "25S01");
            }
        }
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        String[] stringArray = new String[]{"Connection.createStatement"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        String[] stringArray = new String[]{"Connection.prepareStatement"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        String[] stringArray = new String[]{"Connection.prepareCall"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        try {
            if (n == 2) {
                PreparedStatement preparedStatement = this.prepareStatement(string);
                return preparedStatement;
            }
            if (n != 1) {
                String[] stringArray = new String[]{"Connection.prepareStatement"};
                throw this.exceptions.getException(6069, stringArray);
            }
            if (this.getMetaData().supportsGetGeneratedKeys()) {
                this.autoGeneratedKeysRequested = true;
                PreparedStatement preparedStatement = this.prepareStatement(string);
                return preparedStatement;
            }
            String[] stringArray = new String[]{"Connection.prepareStatement"};
            throw this.exceptions.getException(6003, stringArray);
        }
        finally {
            this.autoGeneratedKeysRequested = false;
        }
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        try {
            if (this.implConnection.supportsDMLWithResults) {
                if (nArray == null || nArray.length == 0) {
                    String[] stringArray = new String[]{"Connection.prepareStatement(String, int[])"};
                    throw this.exceptions.getException(6069, stringArray);
                }
                this.requestedKeyColumnDescriptions = new BaseColumns();
                this.requestedKeyColumns = new String[nArray.length];
                this.mapKeyColumnIndexesToColumnNamesAndDescriptions(string, nArray, this.requestedKeyColumns, this.requestedKeyColumnDescriptions);
                PreparedStatement preparedStatement = this.prepareStatement(string);
                return preparedStatement;
            }
            if (this.getMetaData().supportsGetGeneratedKeys() && (this.workarounds & 1) > 0) {
                if (nArray == null) {
                    String[] stringArray = new String[]{"Connection.prepareStatement(String, int[])"};
                    throw this.exceptions.getException(6069, stringArray);
                }
                if (nArray.length != 1) {
                    String[] stringArray = new String[]{"indexes"};
                    throw this.exceptions.getException(6118, stringArray);
                }
                PreparedStatement preparedStatement = this.prepareStatement(string, 1);
                return preparedStatement;
            }
            String[] stringArray = new String[]{"Connection.prepareStatement(String, int[])"};
            throw this.exceptions.getException(6003, stringArray);
        }
        finally {
            this.requestedKeyColumns = null;
            this.requestedKeyColumnDescriptions = null;
        }
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        try {
            if (this.implConnection.supportsDMLWithResults) {
                if (stringArray == null || stringArray.length == 0) {
                    String[] stringArray2 = new String[]{"Connection.prepareStatement(String, String[])"};
                    throw this.exceptions.getException(6069, stringArray2);
                }
                this.requestedKeyColumns = stringArray;
                if (this.implConnection.requiresColDescriptionsForGeneratedKeys()) {
                    this.requestedKeyColumnDescriptions = new BaseColumns();
                    this.mapKeyColumnNamesToColumnDescriptions(string, stringArray, this.requestedKeyColumnDescriptions);
                } else {
                    this.requestedKeyColumnDescriptions = null;
                }
                PreparedStatement preparedStatement = this.prepareStatement(string);
                return preparedStatement;
            }
            if (this.getMetaData().supportsGetGeneratedKeys() && (this.workarounds & 1) > 0) {
                if (stringArray == null) {
                    String[] stringArray3 = new String[]{"Connection.prepareStatement(String, String[])"};
                    throw this.exceptions.getException(6069, stringArray3);
                }
                if (stringArray.length != 1) {
                    String[] stringArray4 = new String[]{"names"};
                    throw this.exceptions.getException(6118, stringArray4);
                }
                PreparedStatement preparedStatement = this.prepareStatement(string, 1);
                return preparedStatement;
            }
            String[] stringArray5 = new String[]{"Connection.prepareStatement(String, String[])"};
            throw this.exceptions.getException(6003, stringArray5);
        }
        finally {
            this.requestedKeyColumns = null;
            this.requestedKeyColumnDescriptions = null;
        }
    }

    public void prepareForXA() {
        this.isXAConnection = true;
    }

    public synchronized void setClientApplicationName(String string) throws SQLException {
        if (string == null) {
            String[] stringArray = new String[]{"ExtConnection.setClientApplicationName"};
            throw this.exceptions.getException(6069, stringArray);
        }
        String string2 = this.implConnection.setClientApplicationName(string);
        if (!string2.equals(string)) {
            this.warnings.add(6100);
        }
        this.clientAppName = string2;
    }

    public synchronized String getClientApplicationName() throws SQLException {
        return this.clientAppName;
    }

    public synchronized void setClientHostName(String string) throws SQLException {
        if (string == null) {
            String[] stringArray = new String[]{"ExtConnection.setClientHostName"};
            throw this.exceptions.getException(6069, stringArray);
        }
        String string2 = this.implConnection.setClientHostName(string);
        if (!string2.equals(string)) {
            this.warnings.add(6100);
        }
        this.clientHostName = string2;
    }

    public synchronized String getClientHostName() throws SQLException {
        return this.clientHostName;
    }

    public synchronized void setClientUser(String string) throws SQLException {
        if (string == null) {
            String[] stringArray = new String[]{"ExtConnection.setClientUser"};
            throw this.exceptions.getException(6069, stringArray);
        }
        String string2 = this.implConnection.setClientUser(string);
        if (!string2.equals(string)) {
            this.warnings.add(6100);
        }
        this.clientUser = string2;
    }

    public synchronized String getClientUser() throws SQLException {
        return this.clientUser;
    }

    public synchronized void setClientAccountingInfo(String string) throws SQLException {
        if (string == null) {
            String[] stringArray = new String[]{"ExtConnection.setClientAccountingInfo"};
            throw this.exceptions.getException(6069, stringArray);
        }
        String string2 = this.implConnection.setClientAccountingInfo(string);
        if (!string2.equals(string)) {
            this.warnings.add(6100);
        }
        this.clientAcctInfo = string2;
    }

    public synchronized String getClientAccountingInfo() throws SQLException {
        return this.clientAcctInfo;
    }

    public synchronized String getCurrentUser() throws SQLException {
        if (this.currentUser == null) {
            this.origUser = this.currentUser = this.implConnection.getCurrentUser();
        }
        return this.currentUser;
    }

    public synchronized void setCurrentUser(String string) throws SQLException {
        this.setCurrentUser(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setCurrentUser(String string, Properties properties) throws SQLException {
        if (this.supportsReauthentication()) {
            if (string == null) {
                String[] stringArray = new String[]{"ExtConnection.setCurrentUser"};
                throw this.exceptions.getException(6069, stringArray);
            }
            if (this.currentUser == null) {
                this.origUser = this.currentUser = this.implConnection.getCurrentUser();
            }
            if (string.equals(this.currentUser)) {
                return;
            }
            if (this.manualTxnWorkStarted) {
                String[] stringArray = new String[]{"setCurrentUser"};
                throw this.exceptions.getException(6124, stringArray);
            }
            try {
                this.implConnection.setCurrentUser(string, properties);
            }
            finally {
                this.currentUser = this.implConnection.getCurrentUser();
            }
        } else {
            throw this.exceptions.getException(6119);
        }
    }

    public synchronized void setCurrentUser(Subject subject) throws SQLException {
        this.setCurrentUser(subject, null);
    }

    public synchronized void setCurrentUser(Subject subject, Properties properties) throws SQLException {
        String string;
        if (this.supportsReauthentication()) {
            if (subject == null) {
                String[] stringArray = new String[]{"ExtConnection.setCurrentUser"};
                throw this.exceptions.getException(6069, stringArray);
            }
            Set<Principal> set = subject.getPrincipals();
            if (set.size() != 1) {
                throw this.exceptions.getException(6120);
            }
            Iterator<Principal> iterator = set.iterator();
            Principal principal = iterator.next();
            string = principal.getName();
            if (principal instanceof X500Principal) {
                int n = string.indexOf("CN=");
                if (n == -1) {
                    n = string.indexOf("cn=");
                }
                if (n == -1) {
                    throw this.exceptions.getException(6134);
                }
                int n2 = string.indexOf(44, n);
                if (n2 == -1) {
                    throw this.exceptions.getException(6134);
                }
                string = string.substring(n + 3, n2);
            }
        } else {
            throw this.exceptions.getException(6119);
        }
        this.setCurrentUser(string, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resetUser() throws SQLException {
        if (this.supportsReauthentication()) {
            if (this.currentUser != null && !this.currentUser.equals(this.origUser)) {
                if (this.manualTxnWorkStarted) {
                    String[] stringArray = new String[]{"resetUser"};
                    throw this.exceptions.getException(6124, stringArray);
                }
                try {
                    this.implConnection.resetUser();
                }
                finally {
                    this.currentUser = this.implConnection.getCurrentUser();
                }
            }
        } else {
            throw this.exceptions.getException(6119);
        }
    }

    public synchronized boolean supportsReauthentication() throws SQLException {
        return this.implConnection.supportsReauthentication();
    }

    final void ValidateSupportsTransactions(boolean bl) throws SQLException {
        if (this.supportsTransactions == -1) {
            int n = this.supportsTransactions = this.getMetaData().supportsTransactions() ? 1 : 0;
        }
        if (!bl && this.supportsTransactions == 0) {
            throw this.exceptions.getException(6113, "HYC00");
        }
    }

    protected BaseResultSetMetaData getKeyColumnMetaData(String string, String string2) throws SQLException {
        Object object;
        BaseSQLScanner baseSQLScanner = new BaseSQLScanner();
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        baseSQLScanner.setup(string, '\'', '\"');
        BaseSQLToken baseSQLToken = baseSQLScanner.getNextToken();
        while (baseSQLToken.type != 6 && baseSQLToken.type != 11) {
            if (!bl) {
                if (baseSQLToken.type == 9) {
                    object = baseSQLToken.value.toLowerCase();
                    if (!((String)object).equals("insert")) break;
                    baseSQLToken = baseSQLScanner.getNextToken();
                    while (baseSQLToken.type == 17) {
                        baseSQLToken = baseSQLScanner.getNextToken();
                    }
                    object = baseSQLToken.value.toLowerCase();
                    if (((String)object).equals("into")) {
                        baseSQLToken = baseSQLScanner.getNextToken();
                        while (baseSQLToken.type == 17) {
                            baseSQLToken = baseSQLScanner.getNextToken();
                        }
                    }
                    bl = true;
                    string4 = baseSQLToken.value;
                }
                baseSQLToken = baseSQLScanner.getNextToken();
                continue;
            }
            if (baseSQLToken.type == 9 && ((String)(object = baseSQLToken.value.toLowerCase())).equals("values")) break;
            string4 = string4 + baseSQLToken.value;
            baseSQLToken = baseSQLScanner.getNextToken();
        }
        if (string4 == null || string4.length() == 0) {
            return null;
        }
        string3 = "select " + string2 + " from " + string4 + " where 0=1";
        object = new BaseStatement(this, 1003, 1007);
        ResultSet resultSet = ((BaseStatement)object).executeQuery(string3);
        return (BaseResultSetMetaData)resultSet.getMetaData();
    }

    protected void mapKeyColumnIndexesToColumnNamesAndDescriptions(String string, int[] nArray, String[] stringArray, BaseColumns baseColumns) throws SQLException {
        BaseResultSetMetaData baseResultSetMetaData = this.getKeyColumnMetaData(string, "*");
        if (baseResultSetMetaData == null) {
            return;
        }
        int n = baseResultSetMetaData.getColumnCount();
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] > n) {
                String[] stringArray2 = new String[]{"Connection.prepareStatement(String, int[])"};
                throw this.exceptions.getException(6069, stringArray2);
            }
            stringArray[i] = baseResultSetMetaData.getColumnName(nArray[i]);
            baseColumns.add(baseResultSetMetaData.columns.get(nArray[i]));
        }
    }

    protected void mapKeyColumnNamesToColumnDescriptions(String string, String[] stringArray, BaseColumns baseColumns) throws SQLException {
        String string2 = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            string2 = string2 + "," + stringArray[i];
        }
        BaseResultSetMetaData baseResultSetMetaData = this.getKeyColumnMetaData(string, string2);
        if (baseResultSetMetaData == null) {
            return;
        }
        int n = baseResultSetMetaData.getColumnCount();
        int n2 = stringArray.length;
        for (int i = 1; i <= n2; ++i) {
            baseColumns.add(baseResultSetMetaData.columns.get(i));
        }
    }

    public synchronized Properties getClientInfo() throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        Properties properties = new Properties();
        properties.put("AccountingInfo", this.clientAcctInfo);
        properties.put("ApplicationName", this.clientAppName);
        properties.put("ClientHostName", this.clientHostName);
        properties.put("ClientUser", this.clientUser);
        return properties;
    }

    public synchronized String getClientInfo(String string) throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        if (string != null) {
            if (string.equalsIgnoreCase("AccountingInfo")) {
                return this.clientAcctInfo;
            }
            if (string.equalsIgnoreCase("ApplicationName")) {
                return this.clientAppName;
            }
            if (string.equalsIgnoreCase("ClientHostName")) {
                return this.clientHostName;
            }
            if (string.equalsIgnoreCase("ClientUser")) {
                return this.clientUser;
            }
        }
        return null;
    }

    public final synchronized void setClientInfo(Properties properties) throws SQLException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (properties != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            String string = "";
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                string = properties.getProperty(string2);
                if (string2.equalsIgnoreCase("AccountingInfo")) {
                    bl = true;
                } else if (string2.equalsIgnoreCase("ApplicationName")) {
                    bl2 = true;
                } else if (string2.equalsIgnoreCase("ClientHostName")) {
                    bl3 = true;
                } else if (string2.equalsIgnoreCase("ClientUser")) {
                    bl4 = true;
                }
                this.setClientInfo(string2, string);
            }
        }
        if (!bl) {
            this.setClientInfo("AccountingInfo", "");
        }
        if (!bl2) {
            this.setClientInfo("ApplicationName", "");
        }
        if (!bl3) {
            this.setClientInfo("ClientHostName", "");
        }
        if (!bl4) {
            this.setClientInfo("ClientUser", "");
        }
    }

    public final synchronized void setClientInfo(String string, String string2) throws SQLException {
        float f = UtilJDKVersionChecker.getJVMVersion();
        if ((double)f < 1.6) {
            throw this.exceptions.getException(6003);
        }
        try {
            if (this.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (string != null) {
                if (string2 == null) {
                    string2 = "";
                }
                if (string.equalsIgnoreCase("AccountingInfo")) {
                    this.setClientAccountingInfo(string2);
                    return;
                }
                if (string.equalsIgnoreCase("ApplicationName")) {
                    this.setClientApplicationName(string2);
                    return;
                }
                if (string.equalsIgnoreCase("ClientHostName")) {
                    this.setClientHostName(string2);
                    return;
                }
                if (string.equalsIgnoreCase("ClientUser")) {
                    this.setClientUser(string2);
                    return;
                }
            }
        }
        catch (SQLException sQLException) {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            hashMap.put(string, new Integer(0));
            String string3 = sQLException.getMessage();
            throw JDBC40Helper.getSQLClientException(string3, hashMap);
        }
        String[] stringArray = new String[]{string};
        this.warnings.add(6123, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isValid(int n) throws SQLException {
        boolean bl;
        if (n < 0) {
            String[] stringArray = new String[]{"Connection.isValid"};
            throw this.exceptions.getException(6069, stringArray);
        }
        boolean bl2 = bl = this.implConnection != null;
        if (bl) {
            BaseConnection baseConnection = this;
            synchronized (baseConnection) {
                switch (this.implConnection.getConnectionStatus()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        bl = false;
                        break;
                    }
                    case 2: {
                        Statement statement = null;
                        try {
                            statement = this.createStatement();
                            int n2 = statement.getQueryTimeout();
                            statement.setQueryTimeout(n);
                            statement.execute("Test Server Connectivity");
                            statement.setQueryTimeout(n2);
                            break;
                        }
                        catch (SQLException sQLException) {
                            if (sQLException.getSQLState().charAt(0) == '0' && sQLException.getSQLState().charAt(1) == '8' || sQLException.getSQLState().equalsIgnoreCase("HYT00")) {
                                bl = false;
                                String[] stringArray = new String[]{sQLException.getMessage()};
                                this.warnings.add(6001, stringArray, sQLException.getSQLState());
                            }
                            if (statement == null) break;
                            try {
                                statement.close();
                                break;
                            }
                            catch (SQLException sQLException2) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }
        return bl;
    }

    public ExtStatementPoolMonitor getStatementPoolMonitor() throws SQLException {
        if (this.implConnection == null) {
            throw this.exceptions.getException(6009);
        }
        return this.statementPoolMonitor;
    }
}

