/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.base;

import com.metamatrix.data.api.ConnectorLogger;
import java.util.HashMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class LoggingFilter
extends XMLFilterImpl {
    private StringBuffer m_buff;
    private ConnectorLogger m_logger;
    private HashMap m_namespaces;

    public LoggingFilter(ConnectorLogger logger) {
        this.m_logger = logger;
        this.m_buff = new StringBuffer();
        this.m_namespaces = new HashMap();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.m_buff.append("<");
        boolean newNamespace = false;
        if (namespaceURI != null && !namespaceURI.equals("")) {
            if (this.m_namespaces.get(namespaceURI) == null) {
                this.m_namespaces.put(namespaceURI, "ns" + (this.m_namespaces.size() + 1));
                newNamespace = true;
            }
            this.m_buff.append(this.m_namespaces.get(namespaceURI));
            this.m_buff.append(":");
        }
        this.m_buff.append(localName);
        if (newNamespace) {
            this.m_buff.append(" xmlns:");
            this.m_buff.append(this.m_namespaces.get(namespaceURI));
            this.m_buff.append("=\"");
            this.m_buff.append(namespaceURI);
            this.m_buff.append("\"");
        }
        for (int i = 0; i < atts.getLength(); ++i) {
            this.m_buff.append(" ");
            boolean isNewNS = false;
            if (atts.getURI(i) != null && !atts.getURI(i).equals("")) {
                if (this.m_namespaces.get(namespaceURI) == null) {
                    this.m_namespaces.put(namespaceURI, "ns" + (this.m_namespaces.size() + 1));
                    isNewNS = true;
                }
                this.m_buff.append(this.m_namespaces.get(namespaceURI));
                this.m_buff.append(":");
            }
            this.m_buff.append(atts.getLocalName(i));
            this.m_buff.append("=\"");
            this.m_buff.append(atts.getValue(i));
            this.m_buff.append("\" ");
            if (!isNewNS) continue;
            this.m_buff.append(" xmlns:");
            this.m_buff.append(this.m_namespaces.get(atts.getURI(i)));
            this.m_buff.append("=\"");
            this.m_buff.append(atts.getURI(i));
            this.m_buff.append("\" ");
        }
        this.m_buff.append(">\n");
        super.startElement(namespaceURI, localName, qName, atts);
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        this.m_buff.append(chars, start, length);
        super.characters(chars, start, length);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.m_buff.append("</");
        if (namespaceURI != null && !namespaceURI.equals("")) {
            this.m_buff.append(this.m_namespaces.get(namespaceURI));
            this.m_buff.append(":");
        }
        this.m_buff.append(localName);
        this.m_buff.append(">\n");
        super.endElement(namespaceURI, localName, qName);
    }

    public void endDocument() throws SAXException {
        this.m_logger.logInfo("response info");
        this.m_logger.logInfo(this.m_buff.toString());
        super.endDocument();
    }
}

