/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.api;

import com.metamatrix.api.exception.security.MetaBaseResourceNotResolvedException;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.security.api.AuthorizationPermission;
import com.metamatrix.platform.security.api.AuthorizationPermissions;
import com.metamatrix.platform.security.api.AuthorizationPermissionsImpl;
import com.metamatrix.platform.security.api.AuthorizationPolicyID;
import com.metamatrix.platform.security.api.AuthorizationResource;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class AuthorizationPolicy
implements Comparable,
Serializable {
    private Set principals;
    private AuthorizationPermissions permissions;
    private AuthorizationPolicyID authorizationPolicyID;

    public AuthorizationPolicy(AuthorizationPolicyID id) {
        if (id == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0001"));
        }
        this.authorizationPolicyID = id;
        this.principals = new HashSet();
        this.permissions = new AuthorizationPermissionsImpl();
    }

    public AuthorizationPolicy(AuthorizationPolicyID id, Set principals, Set permissions) {
        this.authorizationPolicyID = id;
        this.principals = principals != null ? new HashSet(principals) : new HashSet();
        this.permissions = new AuthorizationPermissionsImpl();
        this.permissions.add(permissions);
    }

    public AuthorizationPolicy(AuthorizationPolicy orig) {
        this.authorizationPolicyID = orig.authorizationPolicyID;
        this.principals = new HashSet(orig.principals);
        this.permissions = new AuthorizationPermissionsImpl();
        Iterator iter = orig.iterator();
        while (iter.hasNext()) {
            this.permissions.add((AuthorizationPermission)iter.next());
        }
    }

    AuthorizationPermissions getAuthorizationPermissions() {
        return this.permissions;
    }

    AuthorizationPermission getPermission(AuthorizationPermission permission) {
        AuthorizationPermission oldPermission = null;
        Iterator permItr = this.permissions.iterator();
        while (permItr.hasNext()) {
            oldPermission = (AuthorizationPermission)permItr.next();
            if (!oldPermission.equals(permission)) continue;
            return oldPermission;
        }
        return null;
    }

    public AuthorizationPermission findPermissionWithResource(AuthorizationResource resource) {
        AuthorizationPermission permission = null;
        Iterator permItr = this.permissions.iterator();
        while (permItr.hasNext()) {
            permission = (AuthorizationPermission)permItr.next();
            AuthorizationResource theResource = permission.getResource();
            if (!theResource.isCannonicallyEquivalent(resource)) continue;
            return permission;
        }
        return null;
    }

    public Collection getDependantPermissions(AuthorizationResource resource) {
        ArrayList<AuthorizationPermission> dependantPerms = new ArrayList<AuthorizationPermission>();
        AuthorizationPermission permission = null;
        Iterator permItr = this.permissions.iterator();
        while (permItr.hasNext()) {
            permission = (AuthorizationPermission)permItr.next();
            AuthorizationResource theResource = permission.getResource();
            if (!theResource.isCannonicallyEquivalent(resource)) continue;
            dependantPerms.add(permission);
        }
        return dependantPerms;
    }

    public AuthorizationPolicyID getAuthorizationPolicyID() {
        return this.authorizationPolicyID;
    }

    public Set getPrincipals() {
        return this.principals;
    }

    public int getPrincipalCount() {
        return this.principals.size();
    }

    public int getPermissionCount() {
        return this.permissions.size();
    }

    public Set getPermissions() {
        HashSet perms = new HashSet();
        Iterator permItr = this.permissions.iterator();
        while (permItr.hasNext()) {
            perms.add(permItr.next());
        }
        return perms;
    }

    public boolean hasPermissions() {
        return this.permissions.size() > 0;
    }

    public String getDescription() {
        return this.authorizationPolicyID.getDescription();
    }

    public Iterator iterator() {
        return this.permissions.iterator();
    }

    public boolean hasPrincipal() {
        return !this.principals.isEmpty();
    }

    public boolean implies(AuthorizationPermission permission) throws MetaBaseResourceNotResolvedException {
        return this.permissions.implies(permission);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        sb.append("ID=[");
        sb.append(this.authorizationPolicyID);
        sb.append("] Principals=[");
        Iterator iter = this.principals.iterator();
        while (iter.hasNext()) {
            try {
                sb.append(iter.next().toString() + ',');
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        if (this.principals.size() > 0) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("]  Permissions=[");
        sb.append(this.permissions);
        sb.append("]}");
        return sb.toString();
    }

    public int hashCode() {
        return this.authorizationPolicyID.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            return AuthorizationPolicy.compare(this, (AuthorizationPolicy)obj) == 0;
        }
        return false;
    }

    public int compareTo(Object o) throws ClassCastException {
        if (this == o) {
            return 0;
        }
        if (o == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0018"));
        }
        if (!this.getClass().isInstance(o)) {
            throw new ClassCastException(PlatformPlugin.Util.getString("ERR.014.107.0019", o.getClass()));
        }
        return AuthorizationPolicy.compare(this, (AuthorizationPolicy)o);
    }

    static int compare(AuthorizationPolicy obj1, AuthorizationPolicy obj2) {
        return obj1.hashCode() == obj2.hashCode() ? 0 : obj1.authorizationPolicyID.compareTo(obj2.authorizationPolicyID);
    }

    public void setDescription(String desc) {
        this.authorizationPolicyID.setDescription(desc);
    }

    public void setPermissions(AuthorizationPermissions permissions) {
        if (permissions != null) {
            this.permissions = permissions;
        } else {
            this.permissions.clear();
        }
    }

    public void setPrincipals(Set principals) {
        if (principals != null) {
            this.principals = new HashSet(principals);
        } else {
            this.principals.clear();
        }
    }

    public boolean addPermission(AuthorizationPermission permission) {
        if (permission == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0020"));
        }
        return this.permissions.add(permission);
    }

    public boolean addAllPermissions(AuthorizationPermissions permissions) {
        if (permissions == null && permissions.size() == 0) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0020"));
        }
        return this.permissions.add(permissions);
    }

    public boolean addAllPermissions(Set permissions) {
        if (permissions == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0020"));
        }
        if (permissions.contains(null)) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0021"));
        }
        return this.permissions.add(permissions);
    }

    public void removePermission(AuthorizationPermission permission) {
        this.permissions.remove(permission);
    }

    public void removePermissions() {
        this.permissions.clear();
        this.permissions = new AuthorizationPermissionsImpl();
    }

    public boolean addPrincipal(MetaMatrixPrincipalName principal) {
        if (principal == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0022"));
        }
        return this.principals.add(principal);
    }

    public boolean addAllPrincipals(Set newPrincipals) {
        if (newPrincipals == null) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0022"));
        }
        if (newPrincipals.contains(null)) {
            throw new IllegalArgumentException(PlatformPlugin.Util.getString("ERR.014.107.0023"));
        }
        return this.principals.addAll(newPrincipals);
    }

    public void removePrincipal(MetaMatrixPrincipalName principal) {
        this.principals.remove(principal);
    }

    public void clearPrincipals() {
        this.principals.clear();
    }
}

