/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sqlserver;

import com.metamatrix.jdbc.sqlserver.tds.TDSConnection;
import com.metamatrix.util.UtilBufferedDataQueue;
import com.metamatrix.util.UtilDataProvider;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilTransliterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.net.Socket;

public final class SQLServerByteOrderedDataReader
implements UtilDataProvider {
    private static String footprint = "$Revision:   3.25.1.0  $";
    private final int READ_BUFFER_SIZE = 65544;
    static final int PUSH_BUFFER_SIZE = 128;
    TDSConnection con;
    public UtilTransliterator transliterator;
    private byte[] staticByteArray;
    private Socket socket;
    private InputStream socketInputStream;
    private int replyBufferSize;
    private int packetStatus;
    private int packetSize;
    private int packetReadState;
    private int numBytesToStartOfPacket;
    private boolean empty;
    private boolean lastPacketInReplyBuffered;
    private int numRequestedBytes = 0;
    private byte[] primaryBuffer;
    private byte[] pushBuffer;
    private byte[] secondaryBuffer;
    private UtilBufferedDataQueue wireContentionBuffer;
    private int numBytesInPrimaryBuffer;
    private int savedNumBytesInPrimaryBuffer;
    private int numBytesInSecondaryBuffer;
    private int numBytesInPushBuffer;
    int numBytesToPrimaryBoundary;
    int savedNumBytesToPrimaryBoundary;
    int numBytesToSecondaryBoundary;
    private int numBytesReadFromPrimaryBuffer;
    private int savedNumBytesReadFromPrimaryBuffer;
    private int numBytesReadFromSecondaryBuffer;
    public int TIMEOUT_OCCURRED = 4096;
    public boolean timeoutOccurred;
    private int _lenBytes;
    private boolean _needToHandleBigMaxColumn;
    private boolean traceEmpty = false;

    public SQLServerByteOrderedDataReader(TDSConnection tDSConnection, Socket socket, int n, UtilTransliterator utilTransliterator) {
        this.con = tDSConnection;
        this.socket = socket;
        this.replyBufferSize = n;
        this.transliterator = utilTransliterator;
        try {
            this.socketInputStream = socket.getInputStream();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.packetSize = 0;
        this.packetReadState = 1;
        this.numBytesToStartOfPacket = 0;
        this.empty = true;
        this.lastPacketInReplyBuffered = false;
        this.numRequestedBytes = 0;
        this.staticByteArray = new byte[256];
        this.wireContentionBuffer = null;
        this.pushBuffer = null;
        this.numBytesInPushBuffer = 0;
        this.primaryBuffer = null;
        this.numBytesReadFromPrimaryBuffer = 0;
        this.numBytesInPrimaryBuffer = 0;
        this.numBytesToPrimaryBoundary = 0;
        this.secondaryBuffer = null;
        this.numBytesReadFromSecondaryBuffer = 0;
        this.numBytesInSecondaryBuffer = 0;
        this.numBytesToSecondaryBoundary = 0;
    }

    public void close() {
        if (this.wireContentionBuffer != null) {
            this.wireContentionBuffer.close();
        }
    }

    public void setTransliterator(UtilTransliterator utilTransliterator) {
        this.transliterator = utilTransliterator;
    }

    public final byte readToken() throws UtilException {
        if (this.numBytesReadFromPrimaryBuffer < this.numBytesToPrimaryBoundary) {
            return this.primaryBuffer[this.numBytesReadFromPrimaryBuffer++];
        }
        if (this.numBytesInPushBuffer > 0) {
            if (this.numBytesInPushBuffer == 1) {
                this.enablePrimaryBufferOptimization();
            }
            return this.pushBuffer[--this.numBytesInPushBuffer];
        }
        if (this.wireContentionBuffer != null && this.wireContentionBuffer.numBufferedBytes() > 0) {
            this.wireContentionBuffer.read(this.staticByteArray, 0, 1);
            if (this.wireContentionBuffer.numBufferedBytes() == 0 && this.numBytesInSecondaryBuffer > 0) {
                this.moveSecondaryToPrimary();
            }
            return this.staticByteArray[0];
        }
        if (this.lastPacketInReplyBuffered || this.empty) {
            return 0;
        }
        this.makeMoreDataAvailable();
        return this.primaryBuffer[this.numBytesReadFromPrimaryBuffer++];
    }

    public final byte readInt8() throws UtilException {
        if (this.numBytesReadFromPrimaryBuffer < this.numBytesToPrimaryBoundary) {
            return this.primaryBuffer[this.numBytesReadFromPrimaryBuffer++];
        }
        return this.getByte();
    }

    public final short readUnsignedInt8() throws UtilException {
        if (this.numBytesReadFromPrimaryBuffer < this.numBytesToPrimaryBoundary) {
            return (short)(this.primaryBuffer[this.numBytesReadFromPrimaryBuffer++] & 0xFF);
        }
        return (short)(this.getByte() & 0xFF);
    }

    public final short readInt16() throws UtilException {
        if (this.numBytesReadFromPrimaryBuffer + 1 < this.numBytesToPrimaryBoundary) {
            return (short)(this.primaryBuffer[this.numBytesReadFromPrimaryBuffer++] & 0xFF | this.primaryBuffer[this.numBytesReadFromPrimaryBuffer++] << 8);
        }
        return (short)(this.getByte() & 0xFF | this.getByte() << 8);
    }

    public final short readBigEndianInt16() throws UtilException {
        if (this.numBytesReadFromPrimaryBuffer + 1 < this.numBytesToPrimaryBoundary) {
            return (short)(this.primaryBuffer[this.numBytesReadFromPrimaryBuffer++] << 8 | this.primaryBuffer[this.numBytesReadFromPrimaryBuffer++] & 0xFF);
        }
        return (short)(this.getByte() << 8 | this.getByte() & 0xFF);
    }

    public final int readUnsignedInt16() throws UtilException {
        if (this.numBytesReadFromPrimaryBuffer + 1 < this.numBytesToPrimaryBoundary) {
            return this.primaryBuffer[this.numBytesReadFromPrimaryBuffer++] & 0xFF | (this.primaryBuffer[this.numBytesReadFromPrimaryBuffer++] & 0xFF) << 8;
        }
        return this.getByte() & 0xFF | (this.getByte() & 0xFF) << 8;
    }

    public final int readInt32() throws UtilException {
        if (this.numBytesReadFromPrimaryBuffer + 3 < this.numBytesToPrimaryBoundary) {
            return this.primaryBuffer[this.numBytesReadFromPrimaryBuffer++] & 0xFF | (this.primaryBuffer[this.numBytesReadFromPrimaryBuffer++] & 0xFF) << 8 | (this.primaryBuffer[this.numBytesReadFromPrimaryBuffer++] & 0xFF) << 16 | this.primaryBuffer[this.numBytesReadFromPrimaryBuffer++] << 24;
        }
        return this.getByte() & 0xFF | (this.getByte() & 0xFF) << 8 | (this.getByte() & 0xFF) << 16 | this.getByte() << 24;
    }

    public final int readBigEndianInt32() throws UtilException {
        if (this.numBytesReadFromPrimaryBuffer + 3 < this.numBytesToPrimaryBoundary) {
            return this.primaryBuffer[this.numBytesReadFromPrimaryBuffer++] << 24 | (this.primaryBuffer[this.numBytesReadFromPrimaryBuffer++] & 0xFF) << 16 | (this.primaryBuffer[this.numBytesReadFromPrimaryBuffer++] & 0xFF) << 8 | this.primaryBuffer[this.numBytesReadFromPrimaryBuffer++] & 0xFF;
        }
        return this.getByte() << 24 | (this.getByte() & 0xFF) << 16 | (this.getByte() & 0xFF) << 8 | this.getByte() & 0xFF;
    }

    public final long readUnsignedInt32() throws UtilException {
        if (this.numBytesReadFromPrimaryBuffer + 3 < this.numBytesToPrimaryBoundary) {
            return (long)this.primaryBuffer[this.numBytesReadFromPrimaryBuffer++] & 0xFFL | ((long)this.primaryBuffer[this.numBytesReadFromPrimaryBuffer++] & 0xFFL) << 8 | ((long)this.primaryBuffer[this.numBytesReadFromPrimaryBuffer++] & 0xFFL) << 16 | ((long)this.primaryBuffer[this.numBytesReadFromPrimaryBuffer++] & 0xFFL) << 24;
        }
        return (long)this.getByte() & 0xFFL | ((long)this.getByte() & 0xFFL) << 8 | ((long)this.getByte() & 0xFFL) << 16 | ((long)this.getByte() & 0xFFL) << 24;
    }

    public final float readIEEE32BitFloat() throws UtilException {
        return Float.intBitsToFloat(this.readInt32());
    }

    public final long readInt64() throws UtilException {
        this.getArrayOfBytes(this.staticByteArray, 0, 8);
        return ((long)((this.staticByteArray[0] & 0xFF) + ((this.staticByteArray[1] & 0xFF) << 8) + ((this.staticByteArray[2] & 0xFF) << 16) + (this.staticByteArray[3] << 24)) & 0xFFFFFFFFL) + ((long)((this.staticByteArray[4] & 0xFF) + ((this.staticByteArray[5] & 0xFF) << 8) + ((this.staticByteArray[6] & 0xFF) << 16) + (this.staticByteArray[7] << 24)) << 32);
    }

    public final double readIEEE64BitDouble() throws UtilException {
        return Double.longBitsToDouble(this.readInt64());
    }

    public final String readString(int n) throws UtilException {
        if (this.numBytesReadFromPrimaryBuffer + n < this.numBytesToPrimaryBoundary) {
            String string = this.transliterator.decode(this.primaryBuffer, this.numBytesReadFromPrimaryBuffer, n);
            this.numBytesReadFromPrimaryBuffer += n;
            return string;
        }
        this.transliterator.setCacheSize(n * 2);
        byte[] byArray = this.transliterator.getBytesCache();
        int n2 = this.getArrayOfBytes(byArray, 0, n);
        return this.transliterator.decode(byArray, 0, n2);
    }

    public Reader getReader(int n, boolean bl) throws UtilException {
        return this.transliterator.decodeAsReader(this.getInputStream(n, bl));
    }

    public InputStream getInputStream(int n, boolean bl) throws UtilException {
        this._lenBytes = n;
        this._needToHandleBigMaxColumn = bl;
        return new InputStream(){
            private int readSoFar;
            private int totalLen;
            private boolean atEnd;
            private boolean needToHandleBigMaxColumn;
            private int dataLenInCurrentPacket;
            private int readInPreviousPackets;
            {
                this.totalLen = SQLServerByteOrderedDataReader.this._lenBytes;
                this.needToHandleBigMaxColumn = SQLServerByteOrderedDataReader.this._needToHandleBigMaxColumn;
            }

            public int read() throws IOException {
                if (!this.needToHandleBigMaxColumn) {
                    if (this.readSoFar < this.totalLen) {
                        try {
                            byte by = SQLServerByteOrderedDataReader.this.getByte();
                            ++this.readSoFar;
                            return by & 0xFF;
                        }
                        catch (UtilException utilException) {
                            return -1;
                        }
                    }
                    if (this.atEnd) {
                        return -1;
                    }
                    this.atEnd = true;
                    return -1;
                }
                if (this.atEnd) {
                    return -1;
                }
                if (this.readSoFar - this.readInPreviousPackets == this.dataLenInCurrentPacket) {
                    try {
                        this.dataLenInCurrentPacket = SQLServerByteOrderedDataReader.this.readInt32();
                        this.readInPreviousPackets = this.readSoFar;
                        if (this.dataLenInCurrentPacket == 0) {
                            this.atEnd = true;
                            return -1;
                        }
                    }
                    catch (UtilException utilException) {
                        throw new IOException();
                    }
                }
                try {
                    byte by = SQLServerByteOrderedDataReader.this.getByte();
                    ++this.readSoFar;
                    return by & 0xFF;
                }
                catch (UtilException utilException) {
                    return -1;
                }
            }

            public int read(byte[] byArray, int n, int n2) throws IOException {
                if (!this.needToHandleBigMaxColumn) {
                    int n3 = this.totalLen - this.readSoFar;
                    if (n3 >= n2) {
                        try {
                            SQLServerByteOrderedDataReader.this.getArrayOfBytes(byArray, n, n2);
                            this.readSoFar += n2;
                            return n2;
                        }
                        catch (UtilException utilException) {
                            throw new IOException();
                        }
                    }
                    if (n3 > 0) {
                        try {
                            SQLServerByteOrderedDataReader.this.getArrayOfBytes(byArray, n, n3);
                            this.readSoFar = this.totalLen;
                            this.atEnd = true;
                            return n3;
                        }
                        catch (UtilException utilException) {
                            throw new IOException();
                        }
                    }
                    this.atEnd = true;
                    return -1;
                }
                int n4 = 0;
                if (this.atEnd) {
                    return -1;
                }
                while (true) {
                    if (this.readSoFar - this.readInPreviousPackets == this.dataLenInCurrentPacket) {
                        try {
                            this.dataLenInCurrentPacket = SQLServerByteOrderedDataReader.this.readInt32();
                            this.readInPreviousPackets = this.readSoFar;
                            if (this.dataLenInCurrentPacket == 0) {
                                this.atEnd = true;
                                return n4;
                            }
                        }
                        catch (UtilException utilException) {
                            throw new IOException();
                        }
                    }
                    if (this.dataLenInCurrentPacket >= this.readSoFar - this.readInPreviousPackets + n2) {
                        try {
                            SQLServerByteOrderedDataReader.this.getArrayOfBytes(byArray, n, n2);
                            this.readSoFar += n2;
                            return n2 + n4;
                        }
                        catch (UtilException utilException) {
                            throw new IOException();
                        }
                    }
                    int n5 = this.dataLenInCurrentPacket - (this.readSoFar - this.readInPreviousPackets);
                    try {
                        SQLServerByteOrderedDataReader.this.getArrayOfBytes(byArray, n, n5);
                        this.readSoFar += n5;
                        n4 += n5;
                        n2 -= n5;
                        n += n5;
                    }
                    catch (UtilException utilException) {
                        throw new IOException();
                    }
                }
            }

            public void close() throws IOException {
                if (!this.needToHandleBigMaxColumn) {
                    int n = this.totalLen - this.readSoFar;
                    if (n > 0) {
                        try {
                            SQLServerByteOrderedDataReader.this.readAndDiscardBytes(n);
                        }
                        catch (UtilException utilException) {
                            throw new IOException();
                        }
                    }
                } else {
                    int n = 0;
                    n = this.dataLenInCurrentPacket - (this.readSoFar - this.readInPreviousPackets);
                    if (n > 0) {
                        try {
                            SQLServerByteOrderedDataReader.this.readAndDiscardBytes(n);
                            this.readSoFar += n;
                        }
                        catch (UtilException utilException) {
                            throw new IOException();
                        }
                    }
                    try {
                        while (true) {
                            this.dataLenInCurrentPacket = SQLServerByteOrderedDataReader.this.readInt32();
                            if (this.dataLenInCurrentPacket == 0) {
                                this.atEnd = true;
                                return;
                            }
                            SQLServerByteOrderedDataReader.this.readAndDiscardBytes(this.dataLenInCurrentPacket);
                            this.readSoFar += this.dataLenInCurrentPacket;
                        }
                    }
                    catch (UtilException utilException) {
                        throw new IOException();
                    }
                }
                this.readSoFar = this.totalLen;
                this.atEnd = true;
            }
        };
    }

    public InputStream getAsciiStream(int n, boolean bl) throws UtilException {
        return this.transliterator.decodeAsAsciiStream(this.getInputStream(n, bl));
    }

    public final void readAndDiscardBytes(int n) throws UtilException {
        while (true) {
            int n2;
            int n3;
            if ((n3 = this.numBytesToPrimaryBoundary - this.numBytesReadFromPrimaryBuffer) > 0) {
                if (n <= n3) {
                    this.numBytesReadFromPrimaryBuffer += n;
                    break;
                }
                this.numBytesReadFromPrimaryBuffer += n3;
                n -= n3;
            }
            if (this.numBytesInPushBuffer > 0) {
                while (n > 0 && this.numBytesInPushBuffer > 0) {
                    --this.numBytesInPushBuffer;
                    --n;
                }
                if (this.numBytesInPushBuffer == 0) {
                    this.enablePrimaryBufferOptimization();
                    if (n > 0) continue;
                }
            }
            if (n > 0 && this.wireContentionBuffer != null && (n2 = this.wireContentionBuffer.numBufferedBytes()) > 0) {
                if (n <= n2) {
                    this.wireContentionBuffer.skip(n);
                    n2 -= n;
                    n = 0;
                } else {
                    this.wireContentionBuffer.skip(n2);
                    n2 = 0;
                    n -= n2;
                }
                if (n2 == 0 && this.numBytesInSecondaryBuffer > 0) {
                    this.moveSecondaryToPrimary();
                    if (n > 0) continue;
                }
            }
            if (n <= 0) break;
            if (this.lastPacketInReplyBuffered || this.empty) {
                throw new UtilException(1001, true);
            }
            this.makeMoreDataAvailable();
        }
    }

    private void enablePrimaryBufferOptimization() {
        this.numBytesInPrimaryBuffer = this.savedNumBytesInPrimaryBuffer;
        this.numBytesReadFromPrimaryBuffer = this.savedNumBytesReadFromPrimaryBuffer;
        this.numBytesToPrimaryBoundary = this.savedNumBytesToPrimaryBoundary;
    }

    private void disablePrimaryBufferOptimization() {
        this.savedNumBytesInPrimaryBuffer = this.numBytesInPrimaryBuffer;
        this.savedNumBytesReadFromPrimaryBuffer = this.numBytesReadFromPrimaryBuffer;
        this.savedNumBytesToPrimaryBoundary = this.numBytesToPrimaryBoundary;
        this.numBytesInPrimaryBuffer = 0;
        this.numBytesReadFromPrimaryBuffer = 0;
        this.numBytesToPrimaryBoundary = 0;
    }

    public final byte getByte() throws UtilException {
        if (this.numBytesReadFromPrimaryBuffer < this.numBytesToPrimaryBoundary) {
            return this.primaryBuffer[this.numBytesReadFromPrimaryBuffer++];
        }
        if (this.numBytesInPushBuffer > 0) {
            if (this.numBytesInPushBuffer == 1) {
                this.enablePrimaryBufferOptimization();
            }
            return this.pushBuffer[--this.numBytesInPushBuffer];
        }
        if (this.wireContentionBuffer != null && this.wireContentionBuffer.numBufferedBytes() > 0) {
            this.wireContentionBuffer.read(this.staticByteArray, 0, 1);
            if (this.wireContentionBuffer.numBufferedBytes() == 0 && this.numBytesInSecondaryBuffer > 0) {
                this.moveSecondaryToPrimary();
            }
            return this.staticByteArray[0];
        }
        if (this.lastPacketInReplyBuffered || this.empty) {
            throw new UtilException(1001, true);
        }
        this.makeMoreDataAvailable();
        return this.primaryBuffer[this.numBytesReadFromPrimaryBuffer++];
    }

    public final int getArrayOfBytes(byte[] byArray, int n, int n2) throws UtilException {
        int n3 = 0;
        while (true) {
            int n4;
            if (n2 > 0 && (n4 = this.numBytesToPrimaryBoundary - this.numBytesReadFromPrimaryBuffer) > 0) {
                int n5;
                if (n2 <= n4) {
                    if (n2 < 15) {
                        for (n5 = n2 - 1; n5 >= 0; --n5) {
                            byArray[n + n5] = this.primaryBuffer[this.numBytesReadFromPrimaryBuffer + n5];
                        }
                    } else {
                        System.arraycopy(this.primaryBuffer, this.numBytesReadFromPrimaryBuffer, byArray, n, n2);
                    }
                    this.numBytesReadFromPrimaryBuffer += n2;
                    n3 += n2;
                    break;
                }
                if (n4 < 15) {
                    for (n5 = n4 - 1; n5 >= 0; --n5) {
                        byArray[n + n5] = this.primaryBuffer[this.numBytesReadFromPrimaryBuffer + n5];
                    }
                } else {
                    System.arraycopy(this.primaryBuffer, this.numBytesReadFromPrimaryBuffer, byArray, n, n4);
                }
                this.numBytesReadFromPrimaryBuffer += n4;
                n3 += n4;
                n += n4;
                n2 -= n4;
            }
            if (this.numBytesInPushBuffer > 0) {
                while (n2 > 0 && this.numBytesInPushBuffer > 0) {
                    byArray[n] = this.pushBuffer[--this.numBytesInPushBuffer];
                    ++n3;
                    ++n;
                    --n2;
                }
                if (this.numBytesInPushBuffer == 0) {
                    this.enablePrimaryBufferOptimization();
                    if (n2 > 0) continue;
                }
            }
            if (n2 > 0 && this.wireContentionBuffer != null && this.wireContentionBuffer.numBufferedBytes() > 0) {
                n4 = this.wireContentionBuffer.read(byArray, n, n2);
                n2 -= n4;
                n += n4;
                n3 += n4;
                if (this.wireContentionBuffer.numBufferedBytes() == 0 && this.numBytesInSecondaryBuffer > 0) {
                    this.moveSecondaryToPrimary();
                    if (n2 > 0) continue;
                }
            }
            if (n2 <= 0) break;
            if (this.lastPacketInReplyBuffered || this.empty) {
                throw new UtilException(1001, true);
            }
            this.makeMoreDataAvailable();
        }
        return n3;
    }

    public final void receive() throws UtilException {
        this.primaryBuffer = this.con.getReaderBuffer(65544);
        this.makeMoreDataAvailable();
    }

    public final void prepareToReadCancelReply() throws UtilException {
        if (this.timeoutOccurred) {
            this.makeMoreDataAvailable();
            this.timeoutOccurred = false;
        } else if (this.primaryBuffer == null) {
            this.receive();
        }
    }

    public final void empty() throws UtilException {
        if (this.numBytesInPushBuffer > 0) {
            this.enablePrimaryBufferOptimization();
            this.numBytesInPushBuffer = 0;
        }
        if (this.numBytesInPrimaryBuffer != 0) {
            while (true) {
                this.numBytesReadFromPrimaryBuffer = this.numBytesToPrimaryBoundary;
                if (this.lastPacketInReplyBuffered || this.empty) break;
                this.makeMoreDataAvailable();
            }
            this.lastPacketInReplyBuffered = false;
            if (this.numBytesInPrimaryBuffer > this.numBytesReadFromPrimaryBuffer) {
                do {
                    this.makeMoreDataAvailable();
                    this.numBytesReadFromPrimaryBuffer = this.numBytesToPrimaryBoundary;
                } while (this.numBytesInPrimaryBuffer > this.numBytesReadFromPrimaryBuffer);
                this.con.setCancelPendingStatement(null);
            }
        } else if (this.numBytesInSecondaryBuffer != 0) {
            this.moveSecondaryToPrimary();
            while (true) {
                this.numBytesReadFromPrimaryBuffer = this.numBytesToPrimaryBoundary;
                if (this.lastPacketInReplyBuffered || this.empty) break;
                this.makeMoreDataAvailable();
            }
            this.lastPacketInReplyBuffered = false;
            if (this.numBytesInPrimaryBuffer > this.numBytesReadFromPrimaryBuffer) {
                do {
                    this.makeMoreDataAvailable();
                    this.numBytesReadFromPrimaryBuffer = this.numBytesToPrimaryBoundary;
                } while (this.numBytesInPrimaryBuffer > this.numBytesReadFromPrimaryBuffer);
                this.con.setCancelPendingStatement(null);
            }
        }
        if (this.wireContentionBuffer != null) {
            this.wireContentionBuffer.empty();
        }
        if (this.primaryBuffer != null) {
            this.con.putReaderBuffer(this.primaryBuffer);
            this.primaryBuffer = null;
        }
        if (this.secondaryBuffer != null) {
            this.con.putReaderBuffer(this.secondaryBuffer);
            this.secondaryBuffer = null;
        }
        this.packetSize = 0;
        this.packetReadState = 1;
        this.numBytesToStartOfPacket = 0;
        this.empty = true;
        this.lastPacketInReplyBuffered = false;
        this.numRequestedBytes = 0;
        this.numBytesReadFromPrimaryBuffer = 0;
        this.numBytesInPrimaryBuffer = 0;
        this.numBytesToPrimaryBoundary = 0;
        this.numBytesReadFromSecondaryBuffer = 0;
        this.numBytesInSecondaryBuffer = 0;
        this.numBytesToSecondaryBoundary = 0;
    }

    public boolean moreUnbufferedDataToReturn() {
        return false;
    }

    public final boolean bufferAllData() throws UtilException {
        if (this.lastPacketInReplyBuffered || this.empty) {
            return true;
        }
        int n = 0;
        if (this.wireContentionBuffer == null) {
            this.wireContentionBuffer = new UtilBufferedDataQueue(this.replyBufferSize);
        }
        if (this.replyBufferSize > 0) {
            int n2 = 0;
            int n3 = 0;
            n2 = this.numBytesInPushBuffer > 0 ? this.numBytesInPushBuffer + this.savedNumBytesInPrimaryBuffer - this.savedNumBytesReadFromPrimaryBuffer : this.numBytesInPrimaryBuffer - this.numBytesReadFromPrimaryBuffer;
            n3 = this.replyBufferSize - this.wireContentionBuffer.numBufferedBytes();
            if (n3 - n2 < 0) {
                return false;
            }
        }
        if (this.numBytesInPushBuffer > 0) {
            while (this.numBytesInPushBuffer > 0) {
                this.wireContentionBuffer.write(this.pushBuffer, --this.numBytesInPushBuffer, 1);
            }
            this.enablePrimaryBufferOptimization();
        }
        while (true) {
            int n4 = this.numBytesToPrimaryBoundary - this.numBytesReadFromPrimaryBuffer;
            n = this.wireContentionBuffer.write(this.primaryBuffer, this.numBytesReadFromPrimaryBuffer, n4);
            this.numBytesReadFromPrimaryBuffer += n;
            if (n != n4) {
                this.movePrimaryToSecondary();
                return false;
            }
            if (this.lastPacketInReplyBuffered || this.empty) {
                this.con.putReaderBuffer(this.primaryBuffer);
                this.primaryBuffer = null;
                return true;
            }
            this.makeMoreDataAvailable();
        }
    }

    public final void pushByte(byte by) throws UtilException {
        if (this.pushBuffer == null) {
            this.pushBuffer = new byte[128];
        }
        if (this.numBytesInPushBuffer == this.pushBuffer.length) {
            byte[] byArray = new byte[this.pushBuffer.length * 2];
            System.arraycopy(this.pushBuffer, 0, byArray, 0, this.numBytesInPushBuffer);
            this.pushBuffer = byArray;
        }
        if (this.numBytesInPushBuffer == 0) {
            this.disablePrimaryBufferOptimization();
        }
        this.pushBuffer[this.numBytesInPushBuffer++] = by;
    }

    public final void pushUnsignedInt16(int n) throws UtilException {
        this.pushByte((byte)(n >> 8));
        this.pushByte((byte)n);
    }

    public final void movePrimaryToSecondary() {
        if (this.secondaryBuffer != null) {
            this.con.putReaderBuffer(this.secondaryBuffer);
            this.secondaryBuffer = null;
        }
        this.secondaryBuffer = this.primaryBuffer;
        this.numBytesInSecondaryBuffer = this.numBytesInPrimaryBuffer;
        this.numBytesReadFromSecondaryBuffer = this.numBytesReadFromPrimaryBuffer;
        this.numBytesToSecondaryBoundary = this.numBytesToPrimaryBoundary;
        this.primaryBuffer = null;
        this.numBytesInPrimaryBuffer = 0;
        this.numBytesReadFromPrimaryBuffer = 0;
        this.numBytesToPrimaryBoundary = 0;
    }

    public final void moveSecondaryToPrimary() {
        if (this.primaryBuffer != null) {
            this.con.putReaderBuffer(this.primaryBuffer);
            this.primaryBuffer = null;
        }
        this.primaryBuffer = this.secondaryBuffer;
        this.numBytesInPrimaryBuffer = this.numBytesInSecondaryBuffer;
        this.numBytesReadFromPrimaryBuffer = this.numBytesReadFromSecondaryBuffer;
        this.numBytesToPrimaryBoundary = this.numBytesToSecondaryBoundary;
        this.secondaryBuffer = null;
        this.numBytesInSecondaryBuffer = 0;
        this.numBytesReadFromSecondaryBuffer = 0;
        this.numBytesToSecondaryBoundary = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void makeMoreDataAvailable() throws UtilException {
        this.empty = false;
        while (true) {
            int n;
            block39: {
                if ((this.packetReadState & this.TIMEOUT_OCCURRED) == 0) {
                    this.numRequestedBytes = 0;
                }
                if (this.packetReadState == 1) {
                    if (this.numBytesToPrimaryBoundary != this.numBytesInPrimaryBuffer) {
                        this.numBytesInPrimaryBuffer -= this.numBytesToPrimaryBoundary;
                        System.arraycopy(this.primaryBuffer, this.numBytesToPrimaryBoundary, this.primaryBuffer, 0, this.numBytesInPrimaryBuffer);
                    } else {
                        this.numBytesInPrimaryBuffer = 0;
                    }
                    this.packetReadState = 8;
                } else if (this.packetReadState == 8) {
                    if (this.numBytesInPrimaryBuffer < 9) {
                        this.numRequestedBytes = this.con.packetSize - this.numBytesInPrimaryBuffer + 8;
                        this.packetReadState = 8;
                    } else {
                        this.packetStatus = this.primaryBuffer[1];
                        this.packetSize = (this.primaryBuffer[2] & 0xFF) << 8 | this.primaryBuffer[3] & 0xFF;
                        this.packetSize -= 8;
                        this.numBytesToStartOfPacket = 8;
                        this.numBytesReadFromPrimaryBuffer = 8;
                        this.packetReadState = 4;
                    }
                } else if (this.packetReadState == 2) {
                    this.numBytesToStartOfPacket = -(this.numBytesReadFromPrimaryBuffer - this.numBytesToStartOfPacket);
                    this.numRequestedBytes = this.packetSize + this.numBytesToStartOfPacket + 8;
                    this.numBytesInPrimaryBuffer = 0;
                    this.numBytesReadFromPrimaryBuffer = 0;
                    this.packetReadState = 4;
                } else if (this.packetReadState == 3) {
                    this.numBytesToStartOfPacket = -(this.numBytesReadFromPrimaryBuffer - this.numBytesToStartOfPacket);
                    this.numRequestedBytes = this.packetSize + this.numBytesToStartOfPacket;
                    this.numBytesInPrimaryBuffer = 0;
                    this.numBytesReadFromPrimaryBuffer = 0;
                    this.packetReadState = 4;
                } else {
                    if (this.packetReadState == 4) {
                        n = this.numBytesInPrimaryBuffer - this.numBytesToStartOfPacket;
                        if ((this.packetStatus & 1) == 1) {
                            if (n > this.packetSize) {
                                this.numBytesToStartOfPacket += this.packetSize;
                                this.numBytesToPrimaryBoundary = this.numBytesToStartOfPacket;
                                this.lastPacketInReplyBuffered = true;
                                this.packetReadState = 17;
                                return;
                            }
                            if (n < this.packetSize) {
                                this.numBytesToPrimaryBoundary = this.numBytesInPrimaryBuffer;
                                this.packetReadState = 3;
                                return;
                            }
                            this.numBytesToPrimaryBoundary = this.numBytesInPrimaryBuffer;
                            this.lastPacketInReplyBuffered = true;
                            this.packetReadState = 1;
                            return;
                        }
                        if (n >= this.packetSize + 8) {
                            this.numBytesToStartOfPacket += this.packetSize;
                            this.packetReadState = 12;
                            break block39;
                        } else {
                            if (n >= this.packetSize) {
                                this.numBytesToStartOfPacket += this.packetSize;
                                this.numBytesToPrimaryBoundary = this.numBytesToStartOfPacket;
                                this.packetReadState = 1;
                                return;
                            }
                            this.numBytesToPrimaryBoundary = this.numBytesInPrimaryBuffer;
                            this.packetReadState = 2;
                            return;
                        }
                    }
                    if (this.packetReadState == 12) {
                        this.packetStatus = this.primaryBuffer[this.numBytesToStartOfPacket + 1];
                        this.packetSize = (this.primaryBuffer[this.numBytesToStartOfPacket + 2] & 0xFF) << 8 | this.primaryBuffer[this.numBytesToStartOfPacket + 3] & 0xFF;
                        this.packetSize -= 8;
                        if (this.numBytesInPrimaryBuffer > this.numBytesToStartOfPacket + 8) {
                            System.arraycopy(this.primaryBuffer, this.numBytesToStartOfPacket + 8, this.primaryBuffer, this.numBytesToStartOfPacket, this.numBytesInPrimaryBuffer - (this.numBytesToStartOfPacket + 8));
                            this.packetReadState = 4;
                        } else {
                            this.packetReadState = (this.packetStatus & 1) == 1 ? 14 : 13;
                        }
                        this.numBytesInPrimaryBuffer -= 8;
                    } else if (this.packetReadState == 13) {
                        this.numRequestedBytes = this.packetSize + 8;
                        if (this.numRequestedBytes > this.primaryBuffer.length - this.numBytesInPrimaryBuffer) {
                            this.numBytesToPrimaryBoundary = this.numBytesInPrimaryBuffer;
                            this.packetReadState = 2;
                            return;
                        }
                        this.packetReadState = 4;
                    } else if (this.packetReadState == 14) {
                        this.numRequestedBytes = this.packetSize;
                        if (this.numRequestedBytes > this.primaryBuffer.length - this.numBytesInPrimaryBuffer) {
                            this.numBytesToPrimaryBoundary = this.numBytesInPrimaryBuffer;
                            this.packetReadState = 3;
                            return;
                        }
                        this.packetReadState = 4;
                    } else if (this.packetReadState == 17) {
                        System.arraycopy(this.primaryBuffer, this.numBytesToStartOfPacket, this.primaryBuffer, 0, this.numBytesInPrimaryBuffer - this.numBytesToStartOfPacket);
                        this.numBytesInPrimaryBuffer -= this.numBytesToStartOfPacket;
                        this.packetReadState = 8;
                    } else if ((this.packetReadState & this.TIMEOUT_OCCURRED) != 0) {
                        this.packetReadState &= ~this.TIMEOUT_OCCURRED;
                    }
                }
            }
            if (this.numRequestedBytes <= 0) continue;
            try {
                n = this.socketInputStream.read(this.primaryBuffer, this.numBytesInPrimaryBuffer, this.numRequestedBytes);
                if (n == -1) {
                    throw new UtilException(1001, true);
                }
                this.numBytesInPrimaryBuffer += n;
            }
            catch (InterruptedIOException interruptedIOException) {
                this.timeoutOccurred = true;
                this.packetReadState |= this.TIMEOUT_OCCURRED;
                throw new UtilException(1029);
            }
            catch (IOException iOException) {
                if (iOException.getMessage().indexOf("recv failed") == -1 && iOException.getMessage().indexOf("Connection reset") == -1) {
                    throw new UtilException(1001, true);
                }
                throw new UtilException(1032, iOException.getMessage(), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean lookAheadForBytes(int n, byte[] byArray) throws UtilException {
        boolean bl;
        block7: {
            bl = false;
            int n2 = 0;
            byte[] byArray2 = new byte[n];
            try {
                n2 = this.getArrayOfBytes(byArray2, 0, n);
                if (n2 != n) break block7;
                for (int i = 0; i < byArray.length; ++i) {
                    if (byArray2[n - 1] != byArray[i]) continue;
                    bl = true;
                }
            }
            catch (UtilException utilException) {
                bl = false;
                return bl;
            }
            finally {
                for (int i = n2 - 1; i >= 0; --i) {
                    this.pushByte(byArray2[i]);
                }
            }
        }
        return bl;
    }

    public void reset() {
    }

    public void setSocket(Socket socket) throws UtilException {
        try {
            this.socket = socket;
            this.socketInputStream = this.socket.getInputStream();
        }
        catch (Exception exception) {
            throw new UtilException(1018, exception.toString());
        }
    }
}

