/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.log;

import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.log.LogListener;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.internal.core.log.PlatformLimitSizeLogWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;

public class FileLimitSizeLogWriter
implements LogListener {
    public static final String FILE_SIZE_LIMIT = "metamatrix.log.size.limit.kbs";
    public static final String FILE_SIZE_MONITOR_TIME = "metamatrix.log.size.monitor.mins";
    public static final String ARCHIVE_PREFIX = "a_";
    private static final long DEFUALT_ROLLOVER_SIZE = 1000L;
    private static final int DEFAULT_WAIT_TIME = 60;
    private static final long SIZE_MULTIPLIER = 1000L;
    private static final long MIN_MULTIPLIER = 60000L;
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd_HH-mm";
    static DateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd_HH-mm");
    private FileSizeMonitorThread rollOverThread = null;
    private File currentLogFile = null;
    private PlatformLimitSizeLogWriter limitwriter = null;
    private String prefixName = null;
    private String suffixName = null;
    private File parentFile = null;
    private long filecnt = 1L;
    private Properties props;
    private WriterPreferenceReadWriteLock rwlock;
    private static final String PERIOD = ".";
    private static final String UNDERSCORE = "_";
    private static final String EMPTY = "";

    public FileLimitSizeLogWriter(File file) {
        if (file == null) {
            String msg = CorePlugin.Util.getString("FileLogWriter.The_File_reference_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        this.currentLogFile = file;
        this.rolloverPreviousLogFile(this.currentLogFile);
        this.createPlatformLogWriter(this.currentLogFile);
        this.init();
    }

    public FileLimitSizeLogWriter(File file, boolean resetSystemStreams) {
        if (file == null) {
            String msg = CorePlugin.Util.getString("FileLogWriter.The_File_reference_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        this.currentLogFile = file;
        this.rolloverPreviousLogFile(this.currentLogFile);
        this.createPlatformLogWriter(this.currentLogFile, resetSystemStreams);
        this.init();
    }

    public FileLimitSizeLogWriter(File file, Properties properties) {
        if (file == null) {
            String msg = CorePlugin.Util.getString("FileLogWriter.The_File_reference_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        this.props = properties;
        this.currentLogFile = file;
        this.rolloverPreviousLogFile(this.currentLogFile);
        this.createPlatformLogWriter(this.currentLogFile);
        this.init();
    }

    public FileLimitSizeLogWriter(File file, Properties properties, boolean rollover) {
        if (file == null) {
            String msg = CorePlugin.Util.getString("FileLogWriter.The_File_reference_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        this.props = properties;
        this.currentLogFile = file;
        if (rollover) {
            this.rolloverPreviousLogFile(this.currentLogFile);
        }
        this.createPlatformLogWriter(this.currentLogFile);
        this.init();
    }

    private void init() {
        this.rwlock = new WriterPreferenceReadWriteLock();
        this.parentFile = this.currentLogFile.getParentFile();
        String name = this.currentLogFile.getName();
        int pos = name.lastIndexOf(PERIOD);
        String first = null;
        String ext = null;
        String period = EMPTY;
        if (pos > 0) {
            ext = name.substring(pos + 1);
            first = name.substring(0, pos);
            period = PERIOD;
        } else {
            first = name;
            ext = EMPTY;
        }
        long fileSizeLimit = 1000L;
        long timeLimit = 60L;
        if (this.props != null) {
            String limit = this.props.getProperty(FILE_SIZE_LIMIT);
            try {
                if (limit != null) {
                    fileSizeLimit = Long.parseLong(limit);
                }
            }
            catch (Throwable t) {
                fileSizeLimit = 1000L;
            }
            String time = this.props.getProperty(FILE_SIZE_MONITOR_TIME);
            try {
                if (time != null) {
                    timeLimit = Long.parseLong(time);
                }
            }
            catch (Throwable t) {
                timeLimit = 60L;
            }
        }
        this.prefixName = first;
        StringBuffer suffix = new StringBuffer(period);
        suffix.append(ext);
        this.suffixName = suffix.toString();
        this.rollOverThread = new FileSizeMonitorThread(fileSizeLimit, timeLimit, this);
        this.rollOverThread.start();
    }

    protected File getLogFile() {
        return this.currentLogFile;
    }

    protected void createPlatformLogWriter(File file) {
        this.limitwriter = new PlatformLimitSizeLogWriter(file);
    }

    protected void createPlatformLogWriter(File file, boolean resetSystemStreams) {
        this.limitwriter = new PlatformLimitSizeLogWriter(file, resetSystemStreams);
    }

    protected PlatformLimitSizeLogWriter getPlatformLogWriter() {
        return this.limitwriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logMessage(IStatus msg, long timestamp, String pluginID, String threadName) {
        try {
            this.rwlock.readLock().acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        try {
            if (this.getPlatformLogWriter() != null) {
                this.getPlatformLogWriter().logMessage(msg, timestamp, pluginID, threadName);
            }
        }
        finally {
            this.rwlock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRollOver() {
        try {
            this.rwlock.writeLock().acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        try {
            File rf = this.getNextRolloverFile();
            this.rolloverFile(rf);
        }
        finally {
            this.rwlock.writeLock().release();
        }
    }

    public void shutdown() {
        this.rollOverThread.stopThread();
        if (this.limitwriter != null) {
            this.limitwriter.shutdown();
        }
        this.limitwriter = null;
    }

    private File getNextRolloverFile() {
        String suffix = String.valueOf(this.filecnt) + this.suffixName;
        String archiveName = FileLimitSizeLogWriter.buildArchiveFileName(this.prefixName, suffix);
        File f = new File(this.parentFile, archiveName);
        ++this.filecnt;
        if (f.exists()) {
            return this.getNextRolloverFile();
        }
        return f;
    }

    private void rolloverPreviousLogFile(File logFile) {
        if (logFile.exists()) {
            String path = logFile.getAbsolutePath();
            String logFileName = logFile.getName();
            path = path.substring(0, path.indexOf(logFileName));
            int index = logFileName.lastIndexOf(PERIOD);
            String logFile_begin = logFileName.substring(0, index);
            String logFile_end = logFileName.substring(index);
            String archiveName = FileLimitSizeLogWriter.buildArchiveFileName(logFile_begin, logFile_end);
            logFile.renameTo(new File(path + archiveName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rolloverFile(File rollToFile) {
        try {
            this.getPlatformLogWriter().shutdown();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(this.currentLogFile);
                FileUtils.write((InputStream)fis, rollToFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                fis.close();
            }
            boolean deleted = this.currentLogFile.delete();
            if (!deleted) {
                Exception e = new Exception("File " + this.currentLogFile + " was not DELETED");
                e.printStackTrace();
            }
            this.createPlatformLogWriter(this.currentLogFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String buildArchiveFileName(String prefix, String suffix) {
        String mmdd = FileLimitSizeLogWriter.getDate();
        StringBuffer fileName = new StringBuffer(ARCHIVE_PREFIX);
        fileName.append(prefix);
        fileName.append(mmdd);
        fileName.append(UNDERSCORE);
        fileName.append(suffix);
        return fileName.toString();
    }

    protected static String getDate() {
        try {
            Date d = Calendar.getInstance().getTime();
            return DATE_FORMATTER.format(d);
        }
        catch (Exception e) {
            return EMPTY;
        }
    }

    class FileSizeMonitorThread
    extends Thread {
        private volatile boolean go = true;
        private FileLimitSizeLogWriter writer;
        private long max;
        private long time;

        public FileSizeMonitorThread(long maxSize, long waitTime, FileLimitSizeLogWriter logwriter) {
            super("LogFileSizeMonitor");
            this.writer = logwriter;
            this.max = maxSize;
            this.time = waitTime;
            this.setDaemon(true);
        }

        public void run() {
            CorePlugin.Util.log(CorePlugin.Util.getString("FileLimitSizeLogWriter.Maximum_Log_Size___8", new Object[]{String.valueOf(this.time), String.valueOf(this.max)}));
            long max_size = this.max * 1000L;
            long monitor_time = this.time * 60000L;
            while (this.go) {
                try {
                    Thread.sleep(monitor_time);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    long l;
                    File f = this.writer.getLogFile();
                    if (f == null || !f.exists() || (l = f.length()) < max_size) continue;
                    this.writer.performRollOver();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println(CorePlugin.Util.getString("FileLimitSizeLogWriter.Error_Checking_logwriter_rollover__10") + e.getMessage());
                }
            }
        }

        public void stopThread() {
            this.go = false;
            this.interrupt();
        }
    }
}

