/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.TimeoutException;
import org.jgroups.stack.GossipRouter;
import org.jgroups.util.Promise;

public class TUNNELDeadLockTest
extends TestCase {
    private JChannel channel;
    private Promise promise;
    private volatile int receivedCnt;
    private int msgCount = 20000;
    private int payloadSize = 32;
    private int mainTimeout = 60000;

    public TUNNELDeadLockTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.promise = new Promise();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.channel = null;
        this.promise.reset();
        this.promise = null;
    }

    private String getTUNNELProps(int routerPort) {
        String props = "TUNNEL(router_host=127.0.0.1;router_port=" + routerPort + "):" + "PING(timeout=3000;gossip_refresh=10000;num_initial_members=3;" + "gossip_host=127.0.0.1;gossip_port=" + routerPort + "):" + "FD_SOCK:" + "pbcast.NAKACK(gc_lag=100;retransmit_timeout=600,1200,2400,4800):" + "pbcast.STABLE(stability_delay=1000;desired_avg_gossip=20000;down_thread=false;max_bytes=0;up_thread=false):" + "pbcast.GMS(print_local_addr=true;join_timeout=5000;join_retry_timeout=2000;shun=true)";
        return props;
    }

    public void testStress() throws Exception {
        String props = this.getTUNNELProps(this.startRouter());
        this.channel = new JChannel(props);
        this.channel.connect("agroup");
        new Thread(new Runnable(){

            public void run() {
                try {
                    while (true) {
                        if (TUNNELDeadLockTest.this.channel == null) {
                            return;
                        }
                        Object o = TUNNELDeadLockTest.this.channel.receive(10000L);
                        if (!(o instanceof Message)) continue;
                        TUNNELDeadLockTest.this.receivedCnt++;
                        if (TUNNELDeadLockTest.this.receivedCnt % 2000 == 0) {
                            System.out.println("-- received " + TUNNELDeadLockTest.this.receivedCnt);
                        }
                        if (TUNNELDeadLockTest.this.receivedCnt == TUNNELDeadLockTest.this.msgCount) break;
                    }
                    TUNNELDeadLockTest.this.promise.setResult(new Object());
                    return;
                }
                catch (TimeoutException e) {
                    System.err.println("Timeout receiving from the channel. " + TUNNELDeadLockTest.this.receivedCnt + " msgs received so far.");
                }
                catch (Exception e) {
                    System.err.println("Error receiving data");
                    e.printStackTrace();
                }
            }
        }).start();
        new Thread(new Runnable(){

            public void run() {
                try {
                    for (int i = 0; i < TUNNELDeadLockTest.this.msgCount; ++i) {
                        TUNNELDeadLockTest.this.channel.send(null, null, (Serializable)new byte[TUNNELDeadLockTest.this.payloadSize]);
                        if (i % 2000 != 0) continue;
                        System.out.println("-- sent " + i);
                    }
                }
                catch (Exception e) {
                    System.err.println("Error sending data over ...");
                    e.printStackTrace();
                }
            }
        }).start();
        Object result = this.promise.getResult(this.mainTimeout);
        if (result == null) {
            String msg = "The channel has failed to send/receive " + this.msgCount + " messages " + "possibly because of the channel deadlock or too short " + "timeout (currently " + this.mainTimeout + " ms). " + this.receivedCnt + " messages received so far.";
            TUNNELDeadLockTest.fail((String)msg);
        }
        this.channel.close();
    }

    public static Test suite() {
        TestSuite s = new TestSuite(TUNNELDeadLockTest.class);
        return s;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TUNNELDeadLockTest.suite());
        System.exit(0);
    }

    private int startRouter() throws Exception {
        long startms;
        final int routerPort = this.getFreePort();
        Thread routerThread = new Thread(new Runnable(){

            public void run() {
                try {
                    new GossipRouter(routerPort).start();
                    System.out.println("started GossipRouter on port " + routerPort);
                }
                catch (Exception e) {
                    System.err.println("Failed to start the router on port " + routerPort);
                    e.printStackTrace();
                }
            }
        });
        routerThread.start();
        long crtms = startms = System.currentTimeMillis();
        Throwable lastConnectException = null;
        while (crtms - startms < 10000L) {
            Socket s = null;
            try {
                s = new Socket("localhost", routerPort);
            }
            catch (Exception e) {
                lastConnectException = e;
                Thread.sleep(1000L);
                crtms = System.currentTimeMillis();
                continue;
            }
            lastConnectException = null;
            DataInputStream dis = new DataInputStream(s.getInputStream());
            DataOutputStream dos = new DataOutputStream(s.getOutputStream());
            int len = dis.readInt();
            byte[] buffer = new byte[len];
            dis.read(buffer, 0, len);
            dos.writeInt(-10);
            dos.writeUTF("nogroup_setup");
            dis.readInt();
            s.close();
            break;
        }
        if (lastConnectException != null) {
            lastConnectException.printStackTrace();
            TUNNELDeadLockTest.fail((String)"Cannot connect to the router");
        }
        System.out.println("router ok");
        return routerPort;
    }

    private int getFreePort() throws Exception {
        ServerSocket ss = new ServerSocket(0);
        int port = ss.getLocalPort();
        ss.close();
        return port;
    }
}

