/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.SuspectedException;
import org.jgroups.TimeoutException;
import org.jgroups.View;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.util.Util;

public class JGroupsMember
implements RequestHandler,
MembershipListener,
MessageListener {
    private Log logger;
    private String role;
    private String protocolConfigXmlFile;
    private String messageContents = null;
    private int numOfRepeats = 1;
    private Channel channel = null;
    private String groupName = "win2kschouProto";
    private MessageDispatcher disp = null;
    private long jtimeout = 30000L;
    private long startTime;
    private Address serverAddress = null;
    private final Object serverAddressMutex = new Object();
    private final Object serverEnds = new Object();

    public JGroupsMember(String role, String protocolConfigXmlFile, String message, int numOfRepeats) {
        this.role = role;
        this.protocolConfigXmlFile = protocolConfigXmlFile;
        this.messageContents = message;
        this.numOfRepeats = numOfRepeats > 0 ? numOfRepeats : 1;
        this.logger = LogFactory.getLog(this.getClass());
        Runtime.getRuntime().addShutdownHook(new Thread("Shutdown"){

            public void run() {
                if (null != JGroupsMember.this.channel) {
                    JGroupsMember.this.logger.info((Object)("[" + JGroupsMember.this.getLocalAddress() + "] shutdown and close channel..."));
                    JGroupsMember.this.channel.close();
                } else {
                    JGroupsMember.this.logger.info((Object)("[" + JGroupsMember.this.getLocalAddress() + "] shutdown"));
                }
            }
        });
    }

    /*
     * Exception decompiling
     */
    public boolean init() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void run() {
        String addr = this.getLocalAddress();
        if (this.role.equals("server")) {
            this.runServer();
        } else {
            this.runClient(this.messageContents, this.numOfRepeats);
        }
        if (null != this.channel) {
            this.logger.info((Object)("[" + addr + "] closing channel..."));
            this.channel.close();
            this.channel = null;
            this.logger.info((Object)("[" + addr + "] exits___ __ _ .. ."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runServer() {
        String addr = this.getLocalAddress();
        Object object = this.serverEnds;
        synchronized (object) {
            try {
                this.logger.debug((Object)("[" + addr + "] server main thread goes into wait..."));
                this.serverEnds.wait(0L);
            }
            catch (InterruptedException ix) {
                this.logger.info((Object)("[" + addr + "] server main thread is waken up."));
            }
        }
        this.logger.info((Object)("[" + addr + "] runServer() stops."));
    }

    public void runClient(String clientMessage, int repeats) {
        String addr = this.getLocalAddress();
        for (int i = 0; i < repeats; ++i) {
            Message msg = new Message(this.serverAddress, null, (Serializable)((Object)clientMessage));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("[" + addr + "] sending Message \"" + clientMessage + "\" to server at" + this.serverAddress));
            }
            try {
                Object reply = this.disp.sendMessage(msg, 1, 3000L);
                if (null != reply) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("[" + addr + "] received reply \"" + reply.toString() + "\""));
                    continue;
                }
                this.logger.debug((Object)("[" + addr + "] received null reply"));
                continue;
            }
            catch (TimeoutException tex) {
                this.logger.error((Object)("[" + addr + "] timeout exception when sending Message \"" + clientMessage + "\"; Exception: " + tex.getMessage()));
                break;
            }
            catch (SuspectedException sex) {
                this.logger.error((Object)("[" + addr + "] suspected exception when sending Message \"" + clientMessage + "\"; Exception: " + sex.getMessage()));
                break;
            }
        }
    }

    public void block() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("[" + this.getLocalAddress() + "] MembershipListener.block() is called" + " notifying this member to stop sending messages..."));
        }
    }

    public void suspect(Address suspectedMbr) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("[" + this.getLocalAddress() + "] MembershipListener.suspect(Address=" + suspectedMbr + ") is called notifying a suspected crashed member..."));
        }
    }

    public void viewAccepted(View mbrView) {
        String addr = this.getLocalAddress();
        System.out.println("[" + addr + "] MembershipListener.viewAccepted(View) is called...");
        if (null == mbrView) {
            this.logger.warn((Object)("[" + addr + "] a null View is received."));
            return;
        }
        Vector mbrs = mbrView.getMembers();
        System.out.println("[" + addr + "] View has " + mbrs.size() + " members.");
        Address mbr = null;
        Iterator it = mbrs.iterator();
        while (it.hasNext()) {
            mbr = (Address)it.next();
            this.logger.debug((Object)("[" + addr + "] View a member address: " + mbr));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getState() {
        String addr = this.getLocalAddress();
        this.logger.info((Object)("[" + addr + "] is responding to a Channel.getState() inquiry from another" + " member..."));
        try {
            byte[] result = null;
            this.logger.debug((Object)("[" + addr + "] waiting to lock serverAddress to read..."));
            Object object = this.serverAddressMutex;
            synchronized (object) {
                result = Util.objectToByteBuffer(this.serverAddress);
                this.logger.debug((Object)("[" + addr + "] has read serverAddress;" + " releasing serverAddress lock..."));
            }
            this.logger.info((Object)("[" + addr + "] replying Channel.getState() inquiry..."));
            return result;
        }
        catch (Exception ex) {
            this.logger.error((Object)("[" + addr + "] failed to serialize reply to the Channel.getState()" + " inquiry; Exception: "), (Throwable)ex);
            this.logger.error((Object)("[" + addr + "] replying null to Channel.getState() inquiry..."));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(byte[] state) {
        block7: {
            String addr = this.getLocalAddress();
            this.logger.info((Object)("[" + addr + "] is receiving a group state..."));
            try {
                if (null != state) {
                    this.logger.debug((Object)("[" + addr + "] waiting to lock serverAddress to write..."));
                    Object object = this.serverAddressMutex;
                    synchronized (object) {
                        this.serverAddress = (Address)Util.objectFromByteBuffer(state);
                        this.logger.debug((Object)("[" + addr + "] has written to serverAddress;" + " releasing serverAddress lock..."));
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("[" + addr + "] Got a state from a group coordinator that " + "the server address is " + this.serverAddress));
                    }
                    break block7;
                }
                this.logger.error((Object)("[" + addr + "] Got null state."));
            }
            catch (Exception ex) {
                this.logger.error((Object)("[" + addr + "] failed to de-serialize the state; Exception: "), (Throwable)ex);
            }
        }
    }

    public void receive(Message message) {
        String addr = this.getLocalAddress();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("[" + addr + "] is receiving a Message via MessageListener..."));
        }
        if (null == message) {
            this.logger.error((Object)("[" + addr + "] got a null Message."));
            return;
        }
        Address src = message.getSrc();
        if (message.getObject() instanceof String) {
            String contents = (String)message.getObject();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("[" + addr + "] got a Message \"" + contents + "\" from member at " + src.toString()));
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("[" + addr + "] got a Message from member at " + src.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handle(Message message) {
        String addr = this.getLocalAddress();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("[" + addr + "] is receiving a Message via RequestHandler..."));
        }
        if (null == message) {
            this.logger.error((Object)("[" + addr + "] got a null Message."));
            return null;
        }
        Address src = message.getSrc();
        if (message.getObject() instanceof String) {
            String contents = (String)message.getObject();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("[" + addr + "] got a Message \"" + contents + "\" from member at " + src.toString()));
            }
            if (contents.equals("server")) {
                this.logger.debug((Object)("[" + addr + "] waiting to lock serverAddress to write..."));
                Object object = this.serverAddressMutex;
                synchronized (object) {
                    this.serverAddress = src;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("[" + addr + "] has written to serverAddress = " + src + "; releasing serverAddress lock.."));
                    }
                }
            } else if (contents.equals("stop")) {
                this.logger.debug((Object)("[" + addr + "] received a \"stop\" message;" + " waiting to lock serverEnds..."));
                Object object = this.serverEnds;
                synchronized (object) {
                    this.logger.debug((Object)("[" + addr + "] waking up server main thread..."));
                    this.serverEnds.notifyAll();
                }
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("[" + addr + "] got a Message from member at " + src.toString()));
        }
        if (this.role.equals("server")) {
            this.logger.debug((Object)("[" + addr + "] replying \"ACK\"..."));
            return "ACK";
        }
        this.logger.debug((Object)("[" + addr + "] replying null..."));
        return null;
    }

    private String getLocalAddress() {
        if (null == this.channel) {
            return null;
        }
        Address addr = this.channel.getLocalAddress();
        if (null == addr) {
            return null;
        }
        return addr.toString();
    }

    public static void main(String[] args) {
        JGroupsMember member = null;
        if (4 != args.length) {
            System.out.println("Usage: JGroupsMember <role> <configXmlFile> <message> <repeats>");
            System.out.println(" role = client or server.");
            System.out.println(" configXmlFile = the JGroups protocol stack config file.");
            System.out.println(" For example: config/total-token.xml");
            System.out.println(" message = the message to multi-cast to the group.");
            System.out.println(" A message \"stop\" from a client will stop");
            System.out.println(" all servers.");
            System.out.println(" repeats = if the role is \"client\", then how many");
            System.out.println(" times to repeat the sending of the message.");
            return;
        }
        String role = args[0];
        String propFile = args[1];
        String message = args[2];
        int numOfRepeats = Integer.parseInt(args[3]);
        member = new JGroupsMember(role, propFile, message, numOfRepeats);
        member.init();
        member.run();
    }
}

