/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.visitor;

import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.BetweenCriteria;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.CompoundCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.IsNullCriteria;
import com.metamatrix.query.sql.lang.MatchCriteria;
import com.metamatrix.query.sql.lang.SetCriteria;
import com.metamatrix.query.sql.proc.CriteriaSelector;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.CaseExpression;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.SearchedCaseExpression;
import com.metamatrix.query.sql.symbol.Symbol;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CriteriaTranslatorVisitor
extends LanguageVisitor {
    private Map symbolMap;
    private CriteriaSelector selector;
    private Collection translations;
    private List translatedCriteria = new ArrayList();

    public CriteriaTranslatorVisitor() {
    }

    public CriteriaTranslatorVisitor(Map symbolMap) {
        this();
        Assertion.isNotNull(symbolMap);
        this.symbolMap = symbolMap;
    }

    protected Symbol getMappedSymbol(Symbol symbol) {
        return (Symbol)this.symbolMap.get(symbol);
    }

    public void setSymbolMap(Map symbolMap) {
        this.symbolMap = symbolMap;
    }

    public void setCriteriaSelector(CriteriaSelector selector) {
        this.selector = selector;
    }

    public void setTranslations(Collection translations) {
        this.translations = translations;
    }

    public void visit(BetweenCriteria obj) {
        if (!this.selectorContainsCriteriaElements(obj, 10)) {
            return;
        }
        obj.setExpression(this.replaceExpression(obj.getExpression()));
        obj.setLowerExpression(this.replaceExpression(obj.getLowerExpression()));
        obj.setUpperExpression(this.replaceExpression(obj.getUpperExpression()));
        this.translatedCriteria.add(obj);
    }

    public void visit(CaseExpression obj) {
        obj.setExpression(this.replaceExpression(obj.getExpression()));
        int whenCount = obj.getWhenCount();
        ArrayList<Expression> whens = new ArrayList<Expression>(whenCount);
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        for (int i = 0; i < whenCount; ++i) {
            whens.add(this.replaceExpression(obj.getWhenExpression(i)));
            thens.add(this.replaceExpression(obj.getThenExpression(i)));
        }
        obj.setWhen(whens, thens);
        if (obj.getElseExpression() != null) {
            obj.setElseExpression(this.replaceExpression(obj.getElseExpression()));
        }
    }

    public void visit(CompareCriteria obj) {
        if (!this.selectorContainsCriteriaElements(obj, obj.getOperator())) {
            return;
        }
        obj.setLeftExpression(this.replaceExpression(obj.getLeftExpression()));
        obj.setRightExpression(this.replaceExpression(obj.getRightExpression()));
        this.translatedCriteria.add(obj);
    }

    public void visit(IsNullCriteria obj) {
        if (!this.selectorContainsCriteriaElements(obj, 9)) {
            return;
        }
        obj.setExpression(this.replaceExpression(obj.getExpression()));
        this.translatedCriteria.add(obj);
    }

    public void visit(MatchCriteria obj) {
        if (!this.selectorContainsCriteriaElements(obj, 7)) {
            return;
        }
        obj.setLeftExpression(this.replaceExpression(obj.getLeftExpression()));
        obj.setRightExpression(this.replaceExpression(obj.getRightExpression()));
        this.translatedCriteria.add(obj);
    }

    public void visit(SearchedCaseExpression obj) {
        int whenCount = obj.getWhenCount();
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        for (int i = 0; i < whenCount; ++i) {
            thens.add(this.replaceExpression(obj.getThenExpression(i)));
        }
        obj.setWhen(obj.getWhen(), thens);
        if (obj.getElseExpression() != null) {
            obj.setElseExpression(this.replaceExpression(obj.getElseExpression()));
        }
    }

    public void visit(SetCriteria obj) {
        if (!this.selectorContainsCriteriaElements(obj, 8)) {
            return;
        }
        obj.setExpression(this.replaceExpression(obj.getExpression()));
        ArrayList<Expression> valuesList = new ArrayList<Expression>(obj.getNumberOfValues());
        Iterator valuesIter = obj.getValues().iterator();
        while (valuesIter.hasNext()) {
            Expression valueExpr = (Expression)valuesIter.next();
            valuesList.add(this.replaceExpression(valueExpr));
        }
        obj.setValues(valuesList);
        this.translatedCriteria.add(obj);
    }

    public void visit(Function obj) {
        int argLength = obj.getArgs().length;
        Expression[] args = new Expression[argLength];
        for (int i = 0; i < argLength; ++i) {
            args[i] = this.replaceExpression(obj.getArg(i));
        }
        obj.setArgs(args);
    }

    private boolean selectorContainsCriteriaElements(Criteria criteria, int criteriaType) {
        int selectorType = this.selector.getSelectorType();
        if (selectorType != 0 && selectorType != criteriaType) {
            return false;
        }
        if (this.selector.hasElements()) {
            Iterator selectElmnIter = this.selector.getElements().iterator();
            Collection critElmnts = ElementCollectorVisitor.getElements((LanguageObject)criteria, true);
            while (selectElmnIter.hasNext()) {
                ElementSymbol selectElmnt = (ElementSymbol)selectElmnIter.next();
                if (!critElmnts.contains(selectElmnt)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private Expression replaceExpression(Expression exp) {
        if (exp instanceof AliasSymbol) {
            exp = ((AliasSymbol)exp).getSymbol();
        }
        if (exp instanceof ElementSymbol) {
            exp = this.getTranslatedExpression((ElementSymbol)exp);
        }
        return exp;
    }

    private Expression getMappedExpression(ElementSymbol obj) {
        Expression expr = (Expression)this.symbolMap.get(obj);
        if (expr != null) {
            return expr;
        }
        return obj;
    }

    private Expression getTranslatedExpression(ElementSymbol obj) {
        if (this.translations != null) {
            Iterator transIter = this.translations.iterator();
            while (transIter.hasNext()) {
                CompareCriteria compCrit = (CompareCriteria)transIter.next();
                Collection leftElmnts = ElementCollectorVisitor.getElements((LanguageObject)compCrit.getLeftExpression(), true);
                ElementSymbol element = (ElementSymbol)leftElmnts.iterator().next();
                if (!obj.equals(element)) continue;
                return compCrit.getRightExpression();
            }
        }
        return this.getMappedExpression(obj);
    }

    public Criteria getTranslatedCriteria() {
        if (this.translatedCriteria.size() > 0) {
            if (this.translatedCriteria.size() == 1) {
                return (Criteria)this.translatedCriteria.get(0);
            }
            return new CompoundCriteria(0, this.translatedCriteria);
        }
        return null;
    }
}

