/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.security.util;

import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.security.api.Credentials;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SecurityUtil {
    private static String[] algorithms = new String[]{"SHA", "MD5"};

    public static byte[] getDigestedMessage(Credentials credential) throws NoSuchAlgorithmException {
        return SecurityUtil.getDigestedMessage(credential.getCredentialsAsByteArray());
    }

    public static byte[] getDigestedMessage(byte[] password) throws NoSuchAlgorithmException {
        boolean algFound = false;
        byte[] result = null;
        for (int i = 0; i < algorithms.length; ++i) {
            try {
                MessageDigest md = MessageDigest.getInstance(algorithms[i]);
                md.update(password);
                result = md.digest();
                return result;
            }
            catch (NoSuchAlgorithmException ex) {
                continue;
            }
        }
        if (!algFound) {
            throw new NoSuchAlgorithmException(PlatformPlugin.Util.getString("ERR.014.607.0003"));
        }
        return result;
    }
}

