#!/bin/bash
set -x -e

VERSION="7.3.0"
MILESTONE="CR2"

wget -q -N http://download.eng.bos.redhat.com/rcm-guest/staging/jboss-dg/JDG-$VERSION.$MILESTONE/jboss-datagrid-$VERSION.$MILESTONE-server.zip
wget -q -N http://download.eng.bos.redhat.com/rcm-guest/staging/jboss-dg/JDG-$VERSION.$MILESTONE/jboss-datagrid-$VERSION.$MILESTONE-eap-modules.zip
# in 7.3, we removed the remote modules since the library modules include the hot rod client
# wget -q -N http://download.eng.bos.redhat.com/rcm-guest/staging/jboss-dg/JDG-$VERSION.$MILESTONE/jboss-datagrid-$VERSION.$MILESTONE-eap-modules-remote-java-client.zip

wget -q -N http://download.eng.bos.redhat.com/released/JBoss-middleware/fuse/7.2.0/fuse-karaf-7.2.0.fuse-720035-redhat-00001.zip
wget -q -N http://download.eng.rdu2.redhat.com/released/jboss/eap7/7.2.0/jboss-eap-7.2.0.zip


unzip -q -o jboss-datagrid-$VERSION.$MILESTONE-server.zip
unzip -q -o jboss-datagrid-$VERSION.$MILESTONE-eap-modules.zip
unzip -q -o jboss-eap-7.2.0.zip

mvn -f tests/pom.xml -s maven-settings.xml -Dmaven.test.failure.ignore=true -Dsurefire.timeout=600 clean install \
   -Dfuse.zip=`pwd`/fuse-karaf-7.2.0.fuse-720035-redhat-00001.zip \
   -Deap.home=`pwd`/jboss-eap-7.2 \
   -Djdg.home=`pwd`/jboss-datagrid-$VERSION-server \
   -Deap.modules.library=`pwd`/jboss-datagrid-$VERSION-eap-modules \
   -Dmaven.repo.local=${HOME}/.m2/jdg-mead-repository

