package org.infinispan.objectfilter.test;

import org.infinispan.objectfilter.impl.ProtobufMatcher;
import org.infinispan.objectfilter.test.model.MarshallerRegistration;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.config.Configuration;
import org.junit.Before;

/**
 * @author anistor@redhat.com
 * @since 7.0
 */
public class ProtobufMatcherTest extends AbstractMatcherTest {

   private SerializationContext serCtx;

   private FilterQueryFactory queryFactory;

   @Before
   public void setUp() throws Exception {
      serCtx = ProtobufUtil.newSerializationContext(Configuration.builder().build());
      MarshallerRegistration.registerMarshallers(serCtx);
      queryFactory = new FilterQueryFactory(serCtx);
   }

   @Override
   protected FilterQueryFactory createQueryFactory() {
      return queryFactory;
   }

   @Override
   protected byte[] createPerson1() throws Exception {
      return ProtobufUtil.toWrappedByteArray(serCtx, super.createPerson1());
   }

   @Override
   protected byte[] createPerson2() throws Exception {
      return ProtobufUtil.toWrappedByteArray(serCtx, super.createPerson2());
   }

   @Override
   protected ProtobufMatcher createMatcher() {
      return new ProtobufMatcher(serCtx, null);
   }
}
