package org.infinispan.server.endpoint.subsystem;

import static org.infinispan.server.endpoint.EndpointLogger.ROOT_LOGGER;

import javax.net.ssl.SSLContext;

import org.infinispan.server.core.configuration.SslConfigurationBuilder;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.msc.service.StartException;

public class EncryptableServiceHelper {

   private EncryptableServiceHelper() {
   }

   public static void fillSecurityConfiguration(EncryptableService service, SslConfigurationBuilder configurationBuilder) throws StartException {
      if(isSecurityEnabled(service)) {
         SecurityRealm encryptionRealm = service.getEncryptionSecurityRealm().getValue();
         if (encryptionRealm != null) {
            SSLContext sslContext = encryptionRealm.getSSLContext();
            if (sslContext == null) {
               throw ROOT_LOGGER.noSSLContext(service.getServerName(), encryptionRealm.getName());
            }
            if (configurationBuilder.create().requireClientAuth() && !encryptionRealm.getSupportedAuthenticationMechanisms().contains(AuthMechanism.CLIENT_CERT)) {
               throw ROOT_LOGGER.noSSLTrustStore(service.getServerName(), encryptionRealm.getName());
            }
            configurationBuilder.enable();
            configurationBuilder.sslContext(sslContext);
            configurationBuilder.requireClientAuth(service.getClientAuth());
         }
      }
   }

   public static boolean isSecurityEnabled(EncryptableService service) {
      return service.getEncryptionSecurityRealm().getOptionalValue() != null;
   }
}
