package org.infinispan.persistence.remote.upgrade;

import static org.testng.Assert.assertEquals;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.upgrade.RollingUpgradeManager;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;


@Test(testName = "upgrade.hotrod.HotRodUpgradeStressTest", groups = "stress")
public class HotRodUpgradeStressTest extends AbstractInfinispanTest {

   private static final String CACHE_NAME = "stress";

   private TestCluster sourceCluster, targetCluster;

   @BeforeClass
   public void setup() throws Exception {
      sourceCluster = new TestCluster.Builder().setName("sourceCluster").setNumMembers(2)
            .cache().name(CACHE_NAME)
            .build();

      targetCluster = new TestCluster.Builder().setName("targetCluster").setNumMembers(2)
            .cache().name(CACHE_NAME).remotePort(sourceCluster.getHotRodPort())
            .build();
   }

   @AfterClass
   public void tearDown() {
      targetCluster.destroy();
      sourceCluster.destroy();
   }


   void loadSourceCluster(int entries) {
      final RemoteCache<String, String> remoteCache = sourceCluster.getRemoteCache(CACHE_NAME);
      final AtomicInteger count = new AtomicInteger(0);
      int nThreads = Runtime.getRuntime().availableProcessors();
      ExecutorService executorService = Executors.newFixedThreadPool(nThreads);
      for (int i = 0; i < entries; i++) {
         final String s = String.valueOf(i);
         executorService.submit(new Runnable() {
            @Override
            public void run() {
               remoteCache.put(s, "value" + s);
               int progress = count.incrementAndGet();
               if (progress % 10000 == 0) {
                  System.out.printf("Loaded %d\n", progress);
               }
            }
         });
      }

      executorService.shutdown();

      try {
         while (!executorService.awaitTermination(10, TimeUnit.SECONDS)) {
         }
      } catch (InterruptedException e) {
         e.printStackTrace();
      }

   }

   @Test
   public void testMigrate() throws Exception {
      loadSourceCluster(500000);
      System.out.println("Data Loaded.");
      long start = System.currentTimeMillis();
      RollingUpgradeManager rum = targetCluster.getRollingUpgradeManager(CACHE_NAME);
      rum.synchronizeData("hotrod", 1000, 5);
      System.out.println("Elapsed (s): " + (System.currentTimeMillis() - start) / 1000);

      rum.disconnectSource("hotrod");

      assertEquals(targetCluster.getRemoteCache(CACHE_NAME).size(), sourceCluster.getRemoteCache(CACHE_NAME).size());

   }


}
