package org.infinispan.expiration.impl;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.ControlledTimeService;
import org.infinispan.util.TimeService;
import org.testng.annotations.Test;

import java.util.concurrent.TimeUnit;

import static org.testng.AssertJUnit.*;

@Test(groups = "functional", testName = "expiration.impl.ExpirationFunctionalTest")
public class ExpirationFunctionalTest extends SingleCacheManagerTest {

   protected final int SIZE = 10;
   protected ControlledTimeService timeService = new ControlledTimeService(0);
   protected ExpirationManager manager;

   protected EmbeddedCacheManager createCacheManager() throws Exception {
      ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(false);
      configure(builder);
      EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(builder);
      TestingUtil.replaceComponent(cm, TimeService.class, timeService, true);
      cache = cm.getCache();
      afterCacheCreated(cm);
      return cm;
   }

   protected void configure(ConfigurationBuilder config) {

   }

   protected void afterCacheCreated(EmbeddedCacheManager cm) {
      manager = TestingUtil.extractComponent(cache, ExpirationManager.class);
   }

   public void testSimpleExpirationLifespan() throws Exception {

      for (int i = 0; i < SIZE; i++) {
         cache.put("key-" + i, "value-" + i, 10, TimeUnit.MINUTES);
      }
      timeService.advance(TimeUnit.MINUTES.toMillis(10) + 1);
      // Required since cache loader size calls to store - we have to make sure the store expires entries
      manager.processExpiration();
      assertEquals(0, cache.size());
   }

   public void testSimpleExpirationMaxIdle() throws Exception {

      for (int i = 0; i < SIZE; i++) {
         cache.put("key-" + i, "value-" + i, 10, TimeUnit.MINUTES);
      }
      timeService.advance(TimeUnit.MINUTES.toMillis(10) + 1);
      // Required since cache loader size calls to store - we have to make sure the store expires entries
      manager.processExpiration();
      assertEquals(0, cache.size());
   }
}
