/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.hazelcast;

import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.test.junit4.CamelTestSupport;
import org.junit.Test;

public class HazelcastAtomicnumberProducerTest extends CamelTestSupport {

    @Test
    public void testSet() {
        template.sendBody("direct:set", 4711);

        long body = template.requestBody("direct:get", null, Long.class);
        assertEquals(4711, body);
    }

    @Test
    public void testGet() {
        template.sendBody("direct:set", 1234);

        long body = template.requestBody("direct:get", null, Long.class);
        assertEquals(1234, body);
    }

    @Test
    public void testIncrement() {
        template.sendBody("direct:set", 10);

        long body = template.requestBody("direct:increment", null, Long.class);
        assertEquals(11, body);
    }

    @Test
    public void testDecrement() {
        template.sendBody("direct:set", 10);

        long body = template.requestBody("direct:decrement", null, Long.class);
        assertEquals(9, body);
    }

    @Test
    public void testDestroy() throws InterruptedException {
        template.sendBody("direct:set", 10);
        template.sendBody("direct:destroy", null);
        long body = template.requestBody("direct:get", null, Long.class);
        // the body is destory
        assertEquals(0, body);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder() {
            @Override
            public void configure() throws Exception {

                from("direct:set").setHeader(HazelcastConstants.OPERATION, constant(HazelcastConstants.SETVALUE_OPERATION))
                        .to(String.format("hazelcast:%sfoo", HazelcastConstants.ATOMICNUMBER_PREFIX));

                from("direct:get").setHeader(HazelcastConstants.OPERATION, constant(HazelcastConstants.GET_OPERATION)).to(String.format("hazelcast:%sfoo", HazelcastConstants.ATOMICNUMBER_PREFIX));

                from("direct:increment").setHeader(HazelcastConstants.OPERATION, constant(HazelcastConstants.INCREMENT_OPERATION)).to(
                        String.format("hazelcast:%sfoo", HazelcastConstants.ATOMICNUMBER_PREFIX));

                from("direct:decrement").setHeader(HazelcastConstants.OPERATION, constant(HazelcastConstants.DECREMENT_OPERATION)).to(
                        String.format("hazelcast:%sfoo", HazelcastConstants.ATOMICNUMBER_PREFIX));

                from("direct:destroy").setHeader(HazelcastConstants.OPERATION, constant(HazelcastConstants.DESTROY_OPERATION)).to(
                        String.format("hazelcast:%sfoo", HazelcastConstants.ATOMICNUMBER_PREFIX));

            }
        };
    }

}
