package org.infinispan.configuration.cache;

/**
 * Configuration for the async cache store. If enabled, this provides you with asynchronous writes
 * to the cache store, giving you 'write-behind' caching.
 *
 * @author pmuir
 *
 */
public class AsyncStoreConfiguration {

   private final boolean enabled;
   private final int modificationQueueSize;
   private final int threadPoolSize;

   AsyncStoreConfiguration(boolean enabled, int modificationQueueSize,
                           int threadPoolSize) {
      this.enabled = enabled;
      this.modificationQueueSize = modificationQueueSize;
      this.threadPoolSize = threadPoolSize;
   }

   /**
    * If true, all modifications to this cache store happen asynchronously, on a separate thread.
    */
   public boolean enabled() {
      return enabled;
   }

   /**
    * @deprecated Unused.
    */
   @Deprecated
   public long flushLockTimeout() {
      return 0;
   }

   /**
    * @deprecated Unused
    */
   @Deprecated
   public AsyncStoreConfiguration flushLockTimeout(long l) {
      return this;
   }

   /**
    * Sets the size of the modification queue for the async store. If updates are made at a rate
    * that is faster than the underlying cache store can process this queue, then the async store
    * behaves like a synchronous store for that period, blocking until the queue can accept more
    * elements.
    */
   public int modificationQueueSize() {
      return modificationQueueSize;
   }

   /**
    * @deprecated Unused
    */
   @Deprecated
   public long shutdownTimeout() {
      return 0;
   }

   public AsyncStoreConfiguration shutdownTimeout(long l) {
      return this;
   }

   /**
    * Size of the thread pool whose threads are responsible for applying the modifications.
    */
   public int threadPoolSize() {
      return threadPoolSize;
   }

   @Override
   public String toString() {
      return "AsyncStoreConfiguration{" +
            "enabled=" + enabled +
            ", modificationQueueSize=" + modificationQueueSize +
            ", threadPoolSize=" + threadPoolSize +
            '}';
   }

}
