/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.redis;

public interface RedisConstants {
    String COMMAND = "CamelRedis.Command";
    String KEY = "CamelRedis.Key";
    String KEYS = "CamelRedis.Keys";
    String FIELD = "CamelRedis.Field";
    String FIELDS = "CamelRedis.Fields";
    String VALUE = "CamelRedis.Value";
    String VALUES = "CamelRedis.Values";
    String START = "CamelRedis.Start";
    String END = "CamelRedis.End";
    String TIMEOUT = "CamelRedis.Timeout";
    String OFFSET = "CamelRedis.Offset";
    String DESTINATION = "CamelRedis.Destination";
    String CHANNEL = "CamelRedis.Channel";
    String MESSAGE = "CamelRedis.Message";
    String INDEX = "CamelRedis.Index";
    String POSITION = "CamelRedis.Position";
    String PIVOT = "CamelRedis.Pivot";
    String COUNT = "CamelRedis.Count";
    String TIMESTAMP = "CamelRedis.Timestamp";
    String PATTERN = "CamelRedis.Pattern";
    String DB = "CamelRedis.Db";
    String SCORE = "CamelRedis.Score";
    String MIN = "CamelRedis.Min";
    String MAX = "CamelRedis.Max";
    String INCREMENT = "CamelRedis.Increment";
    String WITHSCORE = "CamelRedis.WithScore";
}
