#!/bin/bash

DIR=`dirname $0`
BASEDIR=`readlink -f "$DIR"`
VERSION=`xsltproc $BASEDIR/extract-gav.xslt pom.xml | cut -d: -f4`

echo "Current version: $VERSION"
echo -n "New version: "
read NEWVERSION

echo "Changing from $VERSION to $NEWVERSION"

find . -name 'pom.xml' -exec sed -i "s/<version>$VERSION<\/version>/<version>$NEWVERSION<\/version>/g" {} \;

