/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import java.io.StringWriter;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.compiler.CompileContext;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;

public class NumericLiteral
extends Expression {
    private Number value;

    public NumericLiteral(Rule rule, Type type, ParseNode token) {
        super(rule, type, token);
        this.value = (Number)token.getChild(0);
    }

    @Override
    public void bind() throws TypeException {
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        if (!(expected.isNumeric() || expected.isUndefined() || expected.isVoid() || expected == Type.OBJECT || expected == Type.STRING)) {
            throw new TypeException("NumericLiteral.typeCheck : invalid expected type " + expected.getName() + this.getPos());
        }
        return this.type;
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        return this.value;
    }

    @Override
    public void compile(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        compileContext.notifySourceLine(this.line);
        if (this.type == Type.I) {
            int val = this.value.intValue();
            if (val >= -1 && val <= 5) {
                mv.visitInsn(3 + val);
            } else {
                mv.visitLdcInsn(this.value);
            }
            compileContext.addStackCount(1);
        } else {
            float val = this.value.floatValue();
            if ((double)val == 0.0) {
                mv.visitInsn(11);
            } else if ((double)val == 1.0) {
                mv.visitInsn(12);
            } else if ((double)val == 2.0) {
                mv.visitInsn(13);
            } else {
                mv.visitLdcInsn(this.value);
            }
            compileContext.addStackCount(1);
        }
    }

    @Override
    public void writeTo(StringWriter stringWriter) {
        stringWriter.write(this.value.toString());
    }
}

