/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.objectweb.asm.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.byteman.objectweb.asm.AnnotationVisitor;
import org.jboss.byteman.objectweb.asm.Attribute;
import org.jboss.byteman.objectweb.asm.ClassVisitor;
import org.jboss.byteman.objectweb.asm.Label;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.objectweb.asm.Type;
import org.jboss.byteman.objectweb.asm.tree.AnnotationNode;
import org.jboss.byteman.objectweb.asm.tree.FieldInsnNode;
import org.jboss.byteman.objectweb.asm.tree.FrameNode;
import org.jboss.byteman.objectweb.asm.tree.IincInsnNode;
import org.jboss.byteman.objectweb.asm.tree.InsnList;
import org.jboss.byteman.objectweb.asm.tree.InsnNode;
import org.jboss.byteman.objectweb.asm.tree.IntInsnNode;
import org.jboss.byteman.objectweb.asm.tree.JumpInsnNode;
import org.jboss.byteman.objectweb.asm.tree.LabelNode;
import org.jboss.byteman.objectweb.asm.tree.LdcInsnNode;
import org.jboss.byteman.objectweb.asm.tree.LineNumberNode;
import org.jboss.byteman.objectweb.asm.tree.LocalVariableNode;
import org.jboss.byteman.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jboss.byteman.objectweb.asm.tree.MemberNode;
import org.jboss.byteman.objectweb.asm.tree.MethodInsnNode;
import org.jboss.byteman.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.jboss.byteman.objectweb.asm.tree.TableSwitchInsnNode;
import org.jboss.byteman.objectweb.asm.tree.TryCatchBlockNode;
import org.jboss.byteman.objectweb.asm.tree.TypeInsnNode;
import org.jboss.byteman.objectweb.asm.tree.VarInsnNode;

public class MethodNode
extends MemberNode
implements MethodVisitor {
    public int access;
    public String name;
    public String desc;
    public String signature;
    public List exceptions;
    public Object annotationDefault;
    public List[] visibleParameterAnnotations;
    public List[] invisibleParameterAnnotations;
    public InsnList instructions = new InsnList();
    public List tryCatchBlocks;
    public int maxStack;
    public int maxLocals;
    public List localVariables;

    public MethodNode() {
    }

    public MethodNode(int access, String name, String desc, String signature, String[] exceptions) {
        this();
        boolean isAbstract;
        this.access = access;
        this.name = name;
        this.desc = desc;
        this.signature = signature;
        this.exceptions = new ArrayList(exceptions == null ? 0 : exceptions.length);
        boolean bl = isAbstract = (access & 0x400) != 0;
        if (!isAbstract) {
            this.localVariables = new ArrayList(5);
        }
        this.tryCatchBlocks = new ArrayList();
        if (exceptions != null) {
            this.exceptions.addAll(Arrays.asList(exceptions));
        }
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return new AnnotationNode(new ArrayList(0){

            public boolean add(Object o) {
                MethodNode.this.annotationDefault = o;
                return super.add(o);
            }
        });
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        AnnotationNode an = new AnnotationNode(desc);
        if (visible) {
            if (this.visibleParameterAnnotations == null) {
                int params = Type.getArgumentTypes(this.desc).length;
                this.visibleParameterAnnotations = new List[params];
            }
            if (this.visibleParameterAnnotations[parameter] == null) {
                this.visibleParameterAnnotations[parameter] = new ArrayList(1);
            }
            this.visibleParameterAnnotations[parameter].add(an);
        } else {
            if (this.invisibleParameterAnnotations == null) {
                int params = Type.getArgumentTypes(this.desc).length;
                this.invisibleParameterAnnotations = new List[params];
            }
            if (this.invisibleParameterAnnotations[parameter] == null) {
                this.invisibleParameterAnnotations[parameter] = new ArrayList(1);
            }
            this.invisibleParameterAnnotations[parameter].add(an);
        }
        return an;
    }

    public void visitCode() {
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        this.instructions.add(new FrameNode(type, nLocal, local == null ? null : MethodNode.labelNodes(local), nStack, stack == null ? null : MethodNode.labelNodes(stack)));
    }

    public void visitInsn(int opcode) {
        this.instructions.add(new InsnNode(opcode));
    }

    public void visitIntInsn(int opcode, int operand) {
        this.instructions.add(new IntInsnNode(opcode, operand));
    }

    public void visitVarInsn(int opcode, int var) {
        this.instructions.add(new VarInsnNode(opcode, var));
    }

    public void visitTypeInsn(int opcode, String desc) {
        this.instructions.add(new TypeInsnNode(opcode, desc));
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.instructions.add(new FieldInsnNode(opcode, owner, name, desc));
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.instructions.add(new MethodInsnNode(opcode, owner, name, desc));
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.instructions.add(new JumpInsnNode(opcode, MethodNode.labelNode(label)));
    }

    public void visitLabel(Label label) {
        this.instructions.add(MethodNode.labelNode(label));
    }

    public void visitLdcInsn(Object cst) {
        this.instructions.add(new LdcInsnNode(cst));
    }

    public void visitIincInsn(int var, int increment) {
        this.instructions.add(new IincInsnNode(var, increment));
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.instructions.add(new TableSwitchInsnNode(min, max, MethodNode.labelNode(dflt), MethodNode.labelNodes(labels)));
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.instructions.add(new LookupSwitchInsnNode(MethodNode.labelNode(dflt), keys, MethodNode.labelNodes(labels)));
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.instructions.add(new MultiANewArrayInsnNode(desc, dims));
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.tryCatchBlocks.add(new TryCatchBlockNode(MethodNode.labelNode(start), MethodNode.labelNode(end), MethodNode.labelNode(handler), type));
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        this.localVariables.add(new LocalVariableNode(name, desc, signature, MethodNode.labelNode(start), MethodNode.labelNode(end), index));
    }

    public void visitLineNumber(int line, Label start) {
        this.instructions.add(new LineNumberNode(line, MethodNode.labelNode(start)));
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.maxStack = maxStack;
        this.maxLocals = maxLocals;
    }

    private static LabelNode labelNode(Label l) {
        if (l.info == null) {
            l.info = new LabelNode(l);
        }
        return (LabelNode)l.info;
    }

    private static LabelNode[] labelNodes(Label[] l) {
        LabelNode[] nodes = new LabelNode[l.length];
        for (int i = 0; i < l.length; ++i) {
            nodes[i] = MethodNode.labelNode(l[i]);
        }
        return nodes;
    }

    private static Object[] labelNodes(Object[] objs) {
        Object[] nodes = new Object[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            Object o = objs[i];
            if (o instanceof Label) {
                o = MethodNode.labelNode((Label)o);
            }
            nodes[i] = o;
        }
        return nodes;
    }

    public void accept(ClassVisitor cv) {
        String[] exceptions = new String[this.exceptions.size()];
        this.exceptions.toArray(exceptions);
        MethodVisitor mv = cv.visitMethod(this.access, this.name, this.desc, this.signature, exceptions);
        if (mv != null) {
            this.accept(mv);
        }
    }

    public void accept(MethodVisitor mv) {
        AnnotationNode an;
        int j;
        List l;
        AnnotationNode an2;
        int i;
        if (this.annotationDefault != null) {
            AnnotationVisitor av = mv.visitAnnotationDefault();
            AnnotationNode.accept(av, null, this.annotationDefault);
            if (av != null) {
                av.visitEnd();
            }
        }
        int n = this.visibleAnnotations == null ? 0 : this.visibleAnnotations.size();
        for (i = 0; i < n; ++i) {
            an2 = (AnnotationNode)this.visibleAnnotations.get(i);
            an2.accept(mv.visitAnnotation(an2.desc, true));
        }
        n = this.invisibleAnnotations == null ? 0 : this.invisibleAnnotations.size();
        for (i = 0; i < n; ++i) {
            an2 = (AnnotationNode)this.invisibleAnnotations.get(i);
            an2.accept(mv.visitAnnotation(an2.desc, false));
        }
        n = this.visibleParameterAnnotations == null ? 0 : this.visibleParameterAnnotations.length;
        for (i = 0; i < n; ++i) {
            l = this.visibleParameterAnnotations[i];
            if (l == null) continue;
            for (j = 0; j < l.size(); ++j) {
                an = (AnnotationNode)l.get(j);
                an.accept(mv.visitParameterAnnotation(i, an.desc, true));
            }
        }
        n = this.invisibleParameterAnnotations == null ? 0 : this.invisibleParameterAnnotations.length;
        for (i = 0; i < n; ++i) {
            l = this.invisibleParameterAnnotations[i];
            if (l == null) continue;
            for (j = 0; j < l.size(); ++j) {
                an = (AnnotationNode)l.get(j);
                an.accept(mv.visitParameterAnnotation(i, an.desc, false));
            }
        }
        n = this.attrs == null ? 0 : this.attrs.size();
        for (i = 0; i < n; ++i) {
            mv.visitAttribute((Attribute)this.attrs.get(i));
        }
        if (this.instructions.size() > 0) {
            mv.visitCode();
            for (i = 0; i < this.tryCatchBlocks.size(); ++i) {
                ((TryCatchBlockNode)this.tryCatchBlocks.get(i)).accept(mv);
            }
            this.instructions.accept(mv);
            n = this.localVariables == null ? 0 : this.localVariables.size();
            for (i = 0; i < n; ++i) {
                ((LocalVariableNode)this.localVariables.get(i)).accept(mv);
            }
            mv.visitMaxs(this.maxStack, this.maxLocals);
        }
        mv.visitEnd();
    }
}

