/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.security.Security;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class MacTest
extends SimpleTest {
    static byte[] keyBytes = Hex.decode("0123456789abcdef");
    static byte[] ivBytes = Hex.decode("1234567890abcdef");
    static byte[] input = Hex.decode("37363534333231204e6f77206973207468652074696d6520666f7220");
    static byte[] output1 = Hex.decode("f1d30f68");
    static byte[] output2 = Hex.decode("58d2e77e");
    static byte[] output3 = Hex.decode("cd647403");
    static byte[] keyBytesISO9797 = Hex.decode("7CA110454A1A6E570131D9619DC1376E");
    static byte[] inputISO9797 = "Hello World !!!!".getBytes();
    static byte[] outputISO9797 = Hex.decode("F09B856213BAB83B");
    static byte[] inputDesEDE64 = "Hello World !!!!".getBytes();
    static byte[] outputDesEDE64 = Hex.decode("862304d33af01096");

    private void aliasTest(SecretKey secretKey, String string, String[] stringArray) throws Exception {
        Mac mac = Mac.getInstance(string, "BC");
        mac.init(secretKey);
        mac.update(input, 0, input.length);
        byte[] byArray = mac.doFinal();
        for (int i = 0; i != stringArray.length; ++i) {
            mac = Mac.getInstance(stringArray[i], "BC");
            mac.init(secretKey);
            mac.update(input, 0, input.length);
            byte[] byArray2 = mac.doFinal();
            if (this.areEqual(byArray2, byArray)) continue;
            this.fail("Failed - expected " + new String(Hex.encode(byArray)) + " got " + new String(Hex.encode(byArray2)));
        }
    }

    public void performTest() throws Exception {
        SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, "DES");
        Mac mac = Mac.getInstance("DESMac", "BC");
        mac.init(secretKeySpec);
        mac.update(input, 0, input.length);
        byte[] byArray = mac.doFinal();
        if (!this.areEqual(byArray, output1)) {
            this.fail("Failed - expected " + new String(Hex.encode(output1)) + " got " + new String(Hex.encode(byArray)));
        }
        mac.init(secretKeySpec, new IvParameterSpec(ivBytes));
        mac.update(input, 0, input.length);
        byArray = mac.doFinal();
        if (!this.areEqual(byArray, output2)) {
            this.fail("Failed - expected " + new String(Hex.encode(output2)) + " got " + new String(Hex.encode(byArray)));
        }
        mac = Mac.getInstance("DESMac/CFB8", "BC");
        mac.init(secretKeySpec, new IvParameterSpec(ivBytes));
        mac.update(input, 0, input.length);
        byArray = mac.doFinal();
        if (!this.areEqual(byArray, output3)) {
            this.fail("Failed - expected " + new String(Hex.encode(output3)) + " got " + new String(Hex.encode(byArray)));
        }
        secretKeySpec = new SecretKeySpec(keyBytesISO9797, "DESEDE");
        mac = Mac.getInstance("ISO9797ALG3", "BC");
        mac.init(secretKeySpec);
        mac.update(inputISO9797, 0, inputISO9797.length);
        byArray = mac.doFinal();
        if (!this.areEqual(byArray, outputISO9797)) {
            this.fail("Failed - expected " + new String(Hex.encode(outputISO9797)) + " got " + new String(Hex.encode(byArray)));
        }
        secretKeySpec = new SecretKeySpec(keyBytesISO9797, "DESEDE");
        mac = Mac.getInstance("DESEDE64", "BC");
        mac.init(secretKeySpec);
        mac.update(inputDesEDE64, 0, inputDesEDE64.length);
        byArray = mac.doFinal();
        if (!this.areEqual(byArray, outputDesEDE64)) {
            this.fail("Failed - expected " + new String(Hex.encode(outputDesEDE64)) + " got " + new String(Hex.encode(byArray)));
        }
        this.aliasTest(new SecretKeySpec(keyBytesISO9797, "DESede"), "DESedeMac64withISO7816-4Padding", new String[]{"DESEDE64WITHISO7816-4PADDING", "DESEDEISO9797ALG1MACWITHISO7816-4PADDING", "DESEDEISO9797ALG1WITHISO7816-4PADDING"});
        this.aliasTest(new SecretKeySpec(keyBytesISO9797, "DESede"), "ISO9797ALG3WITHISO7816-4PADDING", new String[]{"ISO9797ALG3MACWITHISO7816-4PADDING"});
    }

    public String getName() {
        return "Mac";
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        MacTest.runTest(new MacTest());
    }
}

