/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openssl.test;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.openssl.PasswordFinder;
import org.bouncycastle.util.test.SimpleTest;

public class ReaderTest
extends SimpleTest {
    public String getName() {
        return "PEMReaderTest";
    }

    private PEMReader openPEMResource(String string, PasswordFinder passwordFinder) {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        return new PEMReader((Reader)bufferedReader, passwordFinder);
    }

    public void performTest() throws Exception {
        Object object;
        Password password = new Password("secret".toCharArray());
        PEMReader pEMReader = this.openPEMResource("test.pem", password);
        while ((object = pEMReader.readObject()) != null) {
            if (!(object instanceof KeyPair)) continue;
        }
        pEMReader = this.openPEMResource("pkcs7.pem", null);
        ContentInfo contentInfo = (ContentInfo)pEMReader.readObject();
        if (!contentInfo.getContentType().equals(CMSObjectIdentifiers.envelopedData)) {
            this.fail("failed envelopedData check");
        }
        pEMReader = this.openPEMResource("eckey.pem", null);
        ECNamedCurveParameterSpec eCNamedCurveParameterSpec = (ECNamedCurveParameterSpec)pEMReader.readObject();
        KeyPair keyPair = (KeyPair)pEMReader.readObject();
        Signature signature = Signature.getInstance("ECDSA", "BC");
        signature.initSign(keyPair.getPrivate());
        byte[] byArray = new byte[]{97, 98, 99};
        signature.update(byArray);
        byte[] byArray2 = signature.sign();
        signature.initVerify(keyPair.getPublic());
        signature.update(byArray);
        if (!signature.verify(byArray2)) {
            this.fail("EC verification failed");
        }
        if (!keyPair.getPublic().getAlgorithm().equals("ECDSA")) {
            this.fail("wrong algorithm name on public got: " + keyPair.getPublic().getAlgorithm());
        }
        if (!keyPair.getPrivate().getAlgorithm().equals("ECDSA")) {
            this.fail("wrong algorithm name on private");
        }
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
        keyPair = keyPairGenerator.generateKeyPair();
        this.keyPairTest("RSA", keyPair);
        keyPairGenerator = KeyPairGenerator.getInstance("DSA", "BC");
        keyPairGenerator.initialize(512, new SecureRandom());
        keyPair = keyPairGenerator.generateKeyPair();
        this.keyPairTest("DSA", keyPair);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PEMWriter pEMWriter = new PEMWriter(new OutputStreamWriter(byteArrayOutputStream));
        pEMWriter.writeObject(contentInfo);
        pEMWriter.close();
        pEMReader = new PEMReader(new InputStreamReader(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())));
        contentInfo = (ContentInfo)pEMReader.readObject();
        if (!contentInfo.getContentType().equals(CMSObjectIdentifiers.envelopedData)) {
            this.fail("failed envelopedData recode check");
        }
        this.doOpenSslDsaTest("unencrypted");
        this.doOpenSslRsaTest("unencrypted");
        this.doOpenSslTests("aes128");
        this.doOpenSslTests("aes192");
        this.doOpenSslTests("aes256");
        this.doOpenSslTests("blowfish");
        this.doOpenSslTests("des1");
        this.doOpenSslTests("des2");
        this.doOpenSslTests("des3");
        this.doOpenSslTests("rc2_128");
        this.doOpenSslDsaTest("rc2_40_cbc");
        this.doOpenSslRsaTest("rc2_40_cbc");
        this.doOpenSslDsaTest("rc2_64_cbc");
        this.doOpenSslRsaTest("rc2_64_cbc");
    }

    private void keyPairTest(String string, KeyPair keyPair) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PEMWriter pEMWriter = new PEMWriter(new OutputStreamWriter(byteArrayOutputStream));
        pEMWriter.writeObject(keyPair.getPublic());
        pEMWriter.close();
        PEMReader pEMReader = new PEMReader(new InputStreamReader(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())));
        PublicKey publicKey = (PublicKey)pEMReader.readObject();
        if (!publicKey.equals(keyPair.getPublic())) {
            this.fail("Failed public key read: " + string);
        }
        byteArrayOutputStream = new ByteArrayOutputStream();
        pEMWriter = new PEMWriter(new OutputStreamWriter(byteArrayOutputStream));
        pEMWriter.writeObject(keyPair.getPrivate());
        pEMWriter.close();
        pEMReader = new PEMReader(new InputStreamReader(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())));
        KeyPair keyPair2 = (KeyPair)pEMReader.readObject();
        if (!keyPair2.getPrivate().equals(keyPair.getPrivate())) {
            this.fail("Failed private key read: " + string);
        }
        if (!keyPair2.getPublic().equals(keyPair.getPublic())) {
            this.fail("Failed private key public read: " + string);
        }
    }

    private void doOpenSslTests(String string) throws IOException {
        this.doOpenSslDsaModesTest(string);
        this.doOpenSslRsaModesTest(string);
    }

    private void doOpenSslDsaModesTest(String string) throws IOException {
        this.doOpenSslDsaTest(string + "_cbc");
        this.doOpenSslDsaTest(string + "_cfb");
        this.doOpenSslDsaTest(string + "_ecb");
        this.doOpenSslDsaTest(string + "_ofb");
    }

    private void doOpenSslRsaModesTest(String string) throws IOException {
        this.doOpenSslRsaTest(string + "_cbc");
        this.doOpenSslRsaTest(string + "_cfb");
        this.doOpenSslRsaTest(string + "_ecb");
        this.doOpenSslRsaTest(string + "_ofb");
    }

    private void doOpenSslDsaTest(String string) throws IOException {
        String string2 = "dsa/openssl_dsa_" + string + ".pem";
        this.doOpenSslTestFile(string2, DSAPrivateKey.class);
    }

    private void doOpenSslRsaTest(String string) throws IOException {
        String string2 = "rsa/openssl_rsa_" + string + ".pem";
        this.doOpenSslTestFile(string2, RSAPrivateKey.class);
    }

    private void doOpenSslTestFile(String string, Class clazz) throws IOException {
        KeyPair keyPair;
        PrivateKey privateKey;
        PEMReader pEMReader = this.openPEMResource("data/" + string, new Password("changeit".toCharArray()));
        Object object = pEMReader.readObject();
        if (object == null || !(object instanceof KeyPair)) {
            this.fail("Didn't find OpenSSL key");
        }
        if (!clazz.isInstance(privateKey = (keyPair = (KeyPair)object).getPrivate())) {
            this.fail("Returned key not of correct type");
        }
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        ReaderTest.runTest(new ReaderTest());
    }

    private static class Password
    implements PasswordFinder {
        char[] password;

        Password(char[] cArray) {
            this.password = cArray;
        }

        public char[] getPassword() {
            return this.password;
        }
    }
}

