/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.test.BaseBlockCipherTest;
import org.bouncycastle.util.encoders.Hex;

public class NoekeonTest
extends BaseBlockCipherTest {
    static String[] cipherTests = new String[]{"128", "b1656851699e29fa24b70148503d2dfc", "2a78421b87c7d0924f26113f1d1349b2", "e2f687e07b75660ffc372233bc47532c"};

    public NoekeonTest() {
        super("Noekeon");
    }

    public void test(int n, byte[] byArray, byte[] byArray2, byte[] byArray3) throws Exception {
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "Noekeon");
        Cipher cipher = Cipher.getInstance("Noekeon/ECB/NoPadding", "BC");
        Cipher cipher2 = Cipher.getInstance("Noekeon/ECB/NoPadding", "BC");
        try {
            cipher2.init(1, secretKeySpec);
        }
        catch (Exception exception) {
            this.fail("Noekeon failed initialisation - " + exception.toString(), exception);
        }
        try {
            cipher.init(2, secretKeySpec);
        }
        catch (Exception exception) {
            this.fail("Noekeoen failed initialisation - " + exception.toString(), exception);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CipherOutputStream cipherOutputStream = new CipherOutputStream(byteArrayOutputStream, cipher2);
        try {
            for (int i = 0; i != byArray2.length / 2; ++i) {
                cipherOutputStream.write(byArray2[i]);
            }
            cipherOutputStream.write(byArray2, byArray2.length / 2, byArray2.length - byArray2.length / 2);
            cipherOutputStream.close();
        }
        catch (IOException iOException) {
            this.fail("Noekeon failed encryption - " + iOException.toString(), iOException);
        }
        byte[] byArray4 = byteArrayOutputStream.toByteArray();
        if (!this.areEqual(byArray4, byArray3)) {
            this.fail("Noekeon failed encryption - expected " + new String(Hex.encode(byArray3)) + " got " + new String(Hex.encode(byArray4)));
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray4);
        CipherInputStream cipherInputStream = new CipherInputStream(byteArrayInputStream, cipher);
        try {
            DataInputStream dataInputStream = new DataInputStream(cipherInputStream);
            byArray4 = new byte[byArray2.length];
            for (int i = 0; i != byArray2.length / 2; ++i) {
                byArray4[i] = (byte)dataInputStream.read();
            }
            dataInputStream.readFully(byArray4, byArray2.length / 2, byArray4.length - byArray2.length / 2);
        }
        catch (Exception exception) {
            this.fail("Noekeon failed encryption - " + exception.toString(), exception);
        }
        if (!this.areEqual(byArray4, byArray2)) {
            this.fail("Noekeon failed decryption - expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray4)));
        }
    }

    public void performTest() throws Exception {
        for (int i = 0; i != cipherTests.length; i += 4) {
            this.test(Integer.parseInt(cipherTests[i]), Hex.decode(cipherTests[i + 1]), Hex.decode(cipherTests[i + 2]), Hex.decode(cipherTests[i + 3]));
        }
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        NoekeonTest.runTest(new NoekeonTest());
    }
}

