/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.state;

import java.util.Collections;
import java.util.UUID;
import javax.jms.Destination;
import org.jboss.jms.client.delegate.DelegateSupport;
import org.jboss.jms.client.state.HierarchicalState;
import org.jboss.jms.client.state.HierarchicalStateSupport;
import org.jboss.jms.client.state.SessionState;
import org.jboss.jms.delegate.ProducerDelegate;
import org.jboss.messaging.util.Version;

public class ProducerState
extends HierarchicalStateSupport {
    private Destination destination;
    private boolean disableMessageID = false;
    private boolean disableMessageTimestamp = false;
    private int priority = 4;
    private long timeToLive = 0L;
    private int deliveryMode = 2;
    private int strictTCK;
    private SessionState parent;
    private ProducerDelegate delegate;
    private boolean isOrderingGroupEnabled = false;
    private String orderingGroupName = null;

    public ProducerState(SessionState parent, ProducerDelegate delegate, Destination dest) {
        super(parent, (DelegateSupport)((Object)delegate));
        this.children = Collections.EMPTY_SET;
        this.destination = dest;
    }

    public DelegateSupport getDelegate() {
        return (DelegateSupport)((Object)this.delegate);
    }

    public void setDelegate(DelegateSupport delegate) {
        this.delegate = (ProducerDelegate)((Object)delegate);
    }

    public void setParent(HierarchicalState parent) {
        this.parent = (SessionState)parent;
    }

    public HierarchicalState getParent() {
        return this.parent;
    }

    public Version getVersionToUse() {
        return this.parent.getVersionToUse();
    }

    public void synchronizeWith(HierarchicalState newState) throws Exception {
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination dest) {
        this.destination = dest;
    }

    public boolean isDisableMessageID() {
        return this.disableMessageID;
    }

    public void setDisableMessageID(boolean disableMessageID) {
        this.disableMessageID = disableMessageID;
    }

    public boolean isDisableMessageTimestamp() {
        return this.disableMessageTimestamp;
    }

    public void setDisableMessageTimestamp(boolean disableMessageTimestamp) {
        this.disableMessageTimestamp = disableMessageTimestamp;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public void setOrderingGroupEnabled(boolean isOrderingGroupEnabled) {
        this.isOrderingGroupEnabled = isOrderingGroupEnabled;
    }

    public boolean isOrderingGroupEnabled() {
        return this.isOrderingGroupEnabled;
    }

    public void setOrderingGroupName(String ordGroupName) {
        if (ordGroupName == null) {
            ordGroupName = "JBM-ORD-GRP:" + UUID.randomUUID().toString();
        }
        this.orderingGroupName = ordGroupName;
    }

    public String getOrderingGroupName() {
        return this.orderingGroupName;
    }

    public void disableOrderingGroup() {
        if (this.isOrderingGroupEnabled) {
            this.setOrderingGroupEnabled(false);
            this.parent.removeOrderingGroup(this.orderingGroupName);
        }
    }
}

