/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.copy;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.util.collection.ConcurrentSet;
import org.jboss.util.file.Files;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.spi.TempStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackingTempStore
implements TempStore {
    private TempStore delegate;
    private Set<File> files;

    public TrackingTempStore(TempStore delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("Null delegate");
        }
        this.delegate = delegate;
        this.files = new ConcurrentSet();
    }

    public Set<File> getFiles() {
        return Collections.unmodifiableSet(this.files);
    }

    @Override
    public File createTempFolder(VirtualFile file) {
        File dir = this.delegate.createTempFolder(file);
        this.files.add(dir);
        return dir;
    }

    @Override
    public File createTempFolder(String outerName, String innerName) {
        File dir = this.delegate.createTempFolder(outerName, innerName);
        this.files.add(dir);
        return dir;
    }

    @Override
    public void clear() {
        HashSet<File> copy = new HashSet<File>(this.files);
        this.files.clear();
        for (File dir : copy) {
            Files.delete((File)dir);
        }
    }
}

