/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.distdiff;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.soa.distdiff.Addition;
import org.jboss.soa.distdiff.Delta;
import org.jboss.soa.distdiff.DistDiff;
import org.jboss.soa.distdiff.FileComparator;
import org.jboss.soa.distdiff.Modification;
import org.jboss.soa.distdiff.Removal;
import org.jboss.soa.distdiff.ZipComparator;
import org.jboss.soa.distdiff.ZipUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryComparator {
    private DistDiff task;

    public DirectoryComparator(DistDiff task) {
        this.task = task;
    }

    public List<Delta> getChanges(File newDir, File origDir) {
        return this.getChanges(newDir, origDir, "");
    }

    public List<Delta> getChanges(File newDir, File origDir, String parent) {
        if (!newDir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory:" + newDir);
        }
        if (!origDir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory:" + origDir);
        }
        List<Delta> differences = this.getNewFiles(newDir, origDir, parent);
        List<String> commonFiles = Arrays.asList(origDir.list());
        for (String file : commonFiles) {
            if (this.task.skipFile(parent, file)) {
                this.task.log("Skipping file " + parent + file, 4);
                continue;
            }
            File origFile = new File(origDir, file);
            File newFile = new File(newDir, file);
            FileComparator comparator = new FileComparator();
            if (!newFile.exists()) {
                differences.add(new Removal(parent + file, origFile.length()));
                continue;
            }
            if (newFile.isDirectory() && origFile.isDirectory()) {
                differences.addAll(this.getChanges(newFile, origFile, parent + origFile.getName() + File.separator));
                continue;
            }
            if (newFile.isDirectory() && !origFile.isDirectory() || !newFile.isDirectory() && origFile.isDirectory()) {
                differences.add(new Modification(parent + file));
                continue;
            }
            if (ZipUtil.isZipFile(newFile.getName())) {
                ZipComparator zipComparator = new ZipComparator(this.task);
                List<Delta> zipDif = zipComparator.compare(newFile, origFile, parent + origFile.getName() + '!');
                if (zipDif.isEmpty()) continue;
                if (this.task.isDetailed()) {
                    differences.addAll(zipDif);
                    continue;
                }
                differences.add(new Modification(parent + file));
                continue;
            }
            if (comparator.compare(origFile, newFile) == 0) continue;
            differences.add(new Modification(parent + file));
        }
        return differences;
    }

    private List<Delta> getNewFiles(File newDir, File origDir, String parent) {
        ArrayList<String> differences = new ArrayList<String>();
        differences.addAll(Arrays.asList(newDir.list()));
        if (origDir != null) {
            differences.removeAll(Arrays.asList(origDir.list()));
        }
        ArrayList<Delta> deltas = new ArrayList<Delta>();
        for (String difference : differences) {
            File f = new File(newDir, difference);
            if (this.task.skipFile(parent, difference)) {
                this.task.log("Skipping file " + parent + difference, 4);
                continue;
            }
            if (f.isDirectory()) {
                deltas.add(new Addition(parent + difference, 0L));
                if (!this.task.isDetailed()) continue;
                deltas.addAll(this.getNewFiles(f, null, parent + difference + File.separator));
                continue;
            }
            deltas.add(new Addition(parent + difference, f.length()));
        }
        return deltas;
    }
}

