/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.common.math;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Random;
import org.jboss.dna.common.math.MathOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatOperations
implements MathOperations<Float>,
Comparator<Float> {
    @Override
    public Class<Float> getOperandClass() {
        return Float.class;
    }

    @Override
    public Float add(Float value1, Float value2) {
        if (value1 == null) {
            return value2 != null ? value2 : this.createZeroValue();
        }
        if (value2 == null) {
            return value1;
        }
        return Float.valueOf(value1.floatValue() + value2.floatValue());
    }

    @Override
    public Float subtract(Float value1, Float value2) {
        if (value1 == null) {
            return this.negate(value2);
        }
        if (value2 == null) {
            return value1;
        }
        return Float.valueOf(value1.floatValue() - value2.floatValue());
    }

    @Override
    public Float multiply(Float value1, Float value2) {
        if (value1 == null || value2 == null) {
            return this.createZeroValue();
        }
        return Float.valueOf(value1.floatValue() * value2.floatValue());
    }

    @Override
    public double divide(Float value1, Float value2) {
        if (value1 == null || value2 == null) {
            throw new IllegalArgumentException();
        }
        return value1.floatValue() / value2.floatValue();
    }

    @Override
    public Float negate(Float value) {
        if (value == null) {
            return this.createZeroValue();
        }
        return Float.valueOf(value.floatValue() * -1.0f);
    }

    @Override
    public Float increment(Float value) {
        if (value == null) {
            return this.createZeroValue();
        }
        return Float.valueOf(value.floatValue() + 1.0f);
    }

    @Override
    public Float maximum(Float value1, Float value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return Float.valueOf(Math.max(value1.floatValue(), value2.floatValue()));
    }

    @Override
    public Float minimum(Float value1, Float value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return Float.valueOf(Math.min(value1.floatValue(), value2.floatValue()));
    }

    @Override
    public int compare(Float value1, Float value2) {
        if (value1 == null) {
            return value2 != null ? -1 : 0;
        }
        if (value2 == null) {
            return 1;
        }
        return value1.compareTo(value2);
    }

    @Override
    public BigDecimal asBigDecimal(Float value) {
        return value != null ? new BigDecimal(value.floatValue()) : null;
    }

    @Override
    public Float fromBigDecimal(BigDecimal value) {
        return value != null ? Float.valueOf(value.floatValue()) : null;
    }

    @Override
    public Float createZeroValue() {
        return Float.valueOf(0.0f);
    }

    @Override
    public Float create(int value) {
        return Float.valueOf(value);
    }

    @Override
    public Float create(long value) {
        return Float.valueOf(value);
    }

    @Override
    public Float create(double value) {
        return Float.valueOf((float)value);
    }

    @Override
    public double sqrt(Float value) {
        return Math.sqrt(value.floatValue());
    }

    @Override
    public Comparator<Float> getComparator() {
        return this;
    }

    @Override
    public Float random(Float minimum, Float maximum, Random rng) {
        Float difference = this.subtract(maximum, minimum);
        return Float.valueOf(minimum.floatValue() + difference.floatValue() * rng.nextFloat());
    }

    @Override
    public double doubleValue(Float value) {
        return value.doubleValue();
    }

    @Override
    public float floatValue(Float value) {
        return value.floatValue();
    }

    @Override
    public int intValue(Float value) {
        return value.intValue();
    }

    @Override
    public long longValue(Float value) {
        return value.longValue();
    }

    @Override
    public short shortValue(Float value) {
        return value.shortValue();
    }

    @Override
    public int getExponentInScientificNotation(Float value) {
        int exp;
        block3: {
            double v;
            block2: {
                v = Math.abs(value.floatValue());
                exp = 0;
                if (!(v > 1.0)) break block2;
                while (v >= 10.0) {
                    v /= 10.0;
                    ++exp;
                }
                break block3;
            }
            if (v == 0.0 || !(v < 1.0)) break block3;
            while (v < 1.0) {
                v *= 10.0;
                --exp;
            }
        }
        return exp;
    }

    @Override
    public Float roundUp(Float value, int decimalShift) {
        if (value.floatValue() == 0.0f) {
            return Float.valueOf(0.0f);
        }
        double shiftedValue = (Math.abs(value.doubleValue()) * Math.pow(10.0, decimalShift) + 0.5) * (double)Math.signum(value.floatValue());
        double roundedValue = (long)shiftedValue;
        return Float.valueOf((float)(roundedValue * Math.pow(10.0, -decimalShift)));
    }

    @Override
    public Float roundDown(Float value, int decimalShift) {
        if (value.floatValue() == 0.0f) {
            return Float.valueOf(0.0f);
        }
        if (decimalShift > 0) {
            return value;
        }
        double shiftedValue = Math.abs(value.doubleValue()) * Math.pow(10.0, decimalShift) * (double)Math.signum(value.floatValue());
        double roundedValue = (long)shiftedValue;
        return Float.valueOf((float)(roundedValue * Math.pow(10.0, -decimalShift)));
    }

    @Override
    public Float keepSignificantFigures(Float value, int numSigFigs) {
        int currentExp = this.getExponentInScientificNotation(value);
        int decimalShift = (int)Math.signum(currentExp) * (Math.abs(currentExp) + numSigFigs - 1);
        return this.roundUp(value, decimalShift);
    }
}

